/*
 * Decompiled with CFR 0.152.
 */
package com.sun.errorhandler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class DebugClientTestThread
extends Thread {
    BufferedReader in = null;
    PrintWriter out = null;
    JTextArea textArea = null;
    StringBuffer message = new StringBuffer();
    Socket clientSocket = null;
    boolean connected = false;
    boolean connectionFailed = false;

    public DebugClientTestThread(JTextArea jTextArea) {
        this.textArea = jTextArea;
    }

    public void run() {
        try {
            this.clientSocket = new Socket("localhost", 4444);
            this.displayText("Connected to server\n");
            this.connected = true;
        }
        catch (UnknownHostException unknownHostException) {
            this.displayText("Could not connect. unknown host." + unknownHostException.getLocalizedMessage());
            this.connectionFailed = true;
        }
        catch (IOException iOException) {
            this.displayText("Couldn't get I/O for the connection" + iOException.getLocalizedMessage());
            this.connectionFailed = true;
        }
        try {
            this.out = new PrintWriter(this.clientSocket.getOutputStream(), true);
            this.in = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
        }
        catch (IOException iOException) {
            this.displayText("Could not get the socket I/O" + iOException.getLocalizedMessage());
        }
        while (this.connected) {
            try {
                String string = this.in.readLine();
                if (string != null) {
                    this.displayText(string);
                    this.message.append(string + "\n");
                    continue;
                }
                this.connected = false;
                this.displayText("Connection closed");
            }
            catch (IOException iOException) {
                this.displayText(iOException.getLocalizedMessage());
                this.connected = false;
            }
        }
    }

    public boolean isConnected() {
        while (!this.connected) {
            if (!this.connectionFailed) continue;
            return false;
        }
        return this.connected;
    }

    public void disconnect() {
        if (this.connected) {
            try {
                this.out.close();
                this.in.close();
                this.clientSocket.close();
            }
            catch (IOException iOException) {
                this.displayText("Error occured while disconnecting socket" + iOException.getLocalizedMessage());
            }
            this.out = null;
            this.in = null;
            this.clientSocket = null;
            this.connected = false;
        }
    }

    public void sendMessage(String string) {
        if (this.out != null) {
            this.out.println(string);
        }
    }

    public String getMessage() {
        return this.message.toString();
    }

    private void displayText(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DebugClientTestThread.this.textArea.append(string);
            }
        });
    }
}

