/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.faces.data;

import com.sun.rave.faces.util.ComponentBundle;
import java.beans.Beans;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.faces.FacesException;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;

public class CachedRowSetDataModel
extends DataModel {
    private static final ComponentBundle bundle = ComponentBundle.getBundle(CachedRowSetDataModel.class);
    private static final int DESIGN_TIME_ROWS = 5;
    private int index = -1;
    private ResultSetMetaData metadata = null;
    private CachedRowSet cachedRowSet = null;
    private boolean updated = false;

    public CachedRowSetDataModel() {
        this(null);
    }

    public CachedRowSetDataModel(CachedRowSet cachedRowSet) {
        this.setWrappedData(cachedRowSet);
    }

    public boolean isRowAvailable() {
        if (Beans.isDesignTime()) {
            return this.index >= 0 && this.index < 5;
        }
        this.executeIfNecessary();
        if (this.cachedRowSet == null) {
            return false;
        }
        if (this.index < 0) {
            return false;
        }
        try {
            return this.cachedRowSet.absolute(this.index + 1);
        }
        catch (SQLException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public int getRowCount() {
        if (Beans.isDesignTime()) {
            return 5;
        }
        return -1;
    }

    public Object getRowData() {
        if (this.cachedRowSet == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException();
        }
        try {
            this.getMetaData();
            return new CachedRowSetMap(String.CASE_INSENSITIVE_ORDER);
        }
        catch (SQLException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public int getRowIndex() {
        return this.index;
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException();
        }
        if (!Beans.isDesignTime() && this.updated && this.cachedRowSet != null) {
            try {
                if (!this.cachedRowSet.rowDeleted()) {
                    this.cachedRowSet.updateRow();
                }
                this.updated = false;
            }
            catch (SQLException e) {
                throw new FacesException((Throwable)e);
            }
        }
        int old = this.index;
        this.index = rowIndex;
        if (this.cachedRowSet == null) {
            return;
        }
        DataModelListener[] listeners = this.getDataModelListeners();
        if (old != this.index && listeners != null) {
            Object rowData = null;
            if (this.isRowAvailable()) {
                rowData = this.getRowData();
            }
            DataModelEvent event = new DataModelEvent((DataModel)this, this.index, rowData);
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                if (null == listeners[i]) continue;
                listeners[i].rowSelected(event);
            }
        }
    }

    public Object getWrappedData() {
        return this.cachedRowSet;
    }

    public void setWrappedData(Object data) {
        if (data == null) {
            this.metadata = null;
            this.cachedRowSet = null;
            this.setRowIndex(-1);
        } else {
            this.metadata = null;
            this.cachedRowSet = (CachedRowSet)data;
            this.index = -1;
            this.setRowIndex(0);
        }
    }

    public CachedRowSet getCachedRowSet() {
        return (CachedRowSet)this.getWrappedData();
    }

    public void setCachedRowSet(CachedRowSet rowSet) {
        this.setWrappedData(rowSet);
    }

    private void executeIfNecessary() {
        if (Beans.isDesignTime()) {
            return;
        }
        if (this.getCachedRowSet() == null) {
            throw new FacesException(bundle.getMessage("cachedRowSetIsNull"));
        }
        try {
            this.getCachedRowSet().isBeforeFirst();
        }
        catch (SQLException e) {
            try {
                this.getCachedRowSet().execute();
            }
            catch (SQLException e2) {
                throw new FacesException((Throwable)e2);
            }
        }
    }

    private ResultSetMetaData getMetaData() {
        if (this.metadata == null) {
            try {
                this.metadata = this.cachedRowSet.getMetaData();
            }
            catch (SQLException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return this.metadata;
    }

    private void updated() {
        this.updated = true;
    }

    private static Object getFakeData(ResultSetMetaData rsmd, String colName) throws SQLException {
        int colIndex = -1;
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            if (!rsmd.getColumnName(i).equals(colName)) continue;
            colIndex = i;
            break;
        }
        switch (rsmd.getColumnType(colIndex)) {
            case 2003: {
                return new Array(){

                    public Object getArray() {
                        return null;
                    }

                    public Object getArray(long index, int count) {
                        return null;
                    }

                    public Object getArray(long index, int count, Map map) {
                        return null;
                    }

                    public Object getArray(Map map) {
                        return null;
                    }

                    public int getBaseType() {
                        return 1;
                    }

                    public String getBaseTypeName() {
                        return "CHAR";
                    }

                    public ResultSet getResultSet() {
                        return null;
                    }

                    public ResultSet getResultSet(long index, int count) {
                        return null;
                    }

                    public ResultSet getResultSet(long index, int count, Map map) {
                        return null;
                    }

                    public ResultSet getResultSet(Map map) {
                        return null;
                    }
                };
            }
            case -5: {
                return new Long(123L);
            }
            case -2: {
                return new byte[]{1, 2, 3, 4, 5};
            }
            case -7: {
                return new Boolean(true);
            }
            case 2004: {
                return new SerialBlob(new byte[]{1, 2, 3, 4, 5});
            }
            case 16: {
                return new Boolean(true);
            }
            case 1: {
                return new String(bundle.getMessage("arbitraryCharData"));
            }
            case 2005: {
                return new SerialClob(bundle.getMessage("arbitraryClobData").toCharArray());
            }
            case 70: {
                try {
                    return new URL("http://www.sun.com");
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
            case 91: {
                return new Date(new java.util.Date().getTime());
            }
            case 3: {
                return new BigDecimal(BigInteger.ONE);
            }
            case 2001: {
                return null;
            }
            case 8: {
                return new Double(123.0);
            }
            case 6: {
                return new Double(123.0);
            }
            case 4: {
                return new Integer(123);
            }
            case 2000: {
                return new String(bundle.getMessage("arbitraryCharData"));
            }
            case -4: {
                return new byte[]{1, 2, 3, 4, 5};
            }
            case -1: {
                return new String(bundle.getMessage("arbitraryCharData"));
            }
            case 0: {
                return null;
            }
            case 2: {
                return new BigDecimal(BigInteger.ONE);
            }
            case 1111: {
                return null;
            }
            case 7: {
                return new Float(123.0f);
            }
            case 2006: {
                return new Ref(){
                    private Object data = new String(CachedRowSetDataModel.access$500().getMessage("arbitraryCharData"));

                    public String getBaseTypeName() {
                        return "CHAR";
                    }

                    public Object getObject() {
                        return this.data;
                    }

                    public Object getObject(Map map) {
                        return this.data;
                    }

                    public void setObject(Object value) {
                        this.data = value;
                    }
                };
            }
            case 5: {
                return new Short(123);
            }
            case 2002: {
                return new Struct(){
                    private String[] data = new String[]{CachedRowSetDataModel.access$500().getMessage("arbitraryCharData"), CachedRowSetDataModel.access$500().getMessage("arbitraryCharData2"), CachedRowSetDataModel.access$500().getMessage("arbitraryCharData3")};

                    public Object[] getAttributes() {
                        return this.data;
                    }

                    public Object[] getAttributes(Map map) {
                        return this.data;
                    }

                    public String getSQLTypeName() {
                        return "CHAR";
                    }
                };
            }
            case 92: {
                return new Time(new java.util.Date().getTime());
            }
            case 93: {
                return new Timestamp(new java.util.Date().getTime());
            }
            case -6: {
                return new Byte(123);
            }
            case -3: {
                return new byte[]{1, 2, 3, 4, 5};
            }
            case 12: {
                return new String(bundle.getMessage("arbitraryCharData"));
            }
        }
        return null;
    }

    static /* synthetic */ ComponentBundle access$500() {
        return bundle;
    }

    private class CachedRowSetEntries
    extends AbstractSet {
        private CachedRowSetMap map;

        public CachedRowSetEntries(CachedRowSetMap map) {
            this.map = map;
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            Object v = e.getValue();
            if (!this.map.containsKey(k)) {
                return false;
            }
            if (v == null) {
                return this.map.get(k) == null;
            }
            return v.equals(this.map.get(k));
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public Iterator iterator() {
            return new CachedRowSetEntriesIterator(this.map);
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.map.size();
        }
    }

    private class CachedRowSetEntriesIterator
    implements Iterator {
        private CachedRowSetMap map = null;
        private Iterator keys = null;

        public CachedRowSetEntriesIterator(CachedRowSetMap map) {
            this.map = map;
            this.keys = map.keySet().iterator();
        }

        public boolean hasNext() {
            return this.keys.hasNext();
        }

        public Object next() {
            Object key = this.keys.next();
            return new CachedRowSetEntry(this.map, key);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class CachedRowSetEntry
    implements Map.Entry {
        private CachedRowSetMap map;
        private Object key;

        public CachedRowSetEntry(CachedRowSetMap map, Object key) {
            this.map = map;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (this.key == null ? e.getKey() != null : !this.key.equals(e.getKey())) {
                return false;
            }
            Object v = this.map.get(this.key);
            return !(v == null ? e.getValue() != null : !v.equals(e.getValue()));
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.map.get(this.key);
        }

        public int hashCode() {
            Object value = this.map.get(this.key);
            return (this.key == null ? 0 : this.key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        public Object setValue(Object value) {
            Object previous = this.map.get(this.key);
            this.map.put(this.key, value);
            return previous;
        }
    }

    private class CachedRowSetKeys
    extends AbstractSet {
        private CachedRowSetMap map;

        public CachedRowSetKeys(CachedRowSetMap map) {
            this.map = map;
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public Iterator iterator() {
            return new CachedRowSetKeysIterator(this.map);
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.map.size();
        }
    }

    private class CachedRowSetKeysIterator
    implements Iterator {
        private CachedRowSetMap map = null;
        private Iterator keys = null;

        public CachedRowSetKeysIterator(CachedRowSetMap map) {
            this.map = map;
            this.keys = map.realKeys();
        }

        public boolean hasNext() {
            return this.keys.hasNext();
        }

        public Object next() {
            return this.keys.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class CachedRowSetMap
    extends TreeMap {
        private int index;

        public CachedRowSetMap(Comparator comparator) throws SQLException {
            super(comparator);
            this.index = CachedRowSetDataModel.this.index;
            if (!Beans.isDesignTime()) {
                CachedRowSetDataModel.this.cachedRowSet.absolute(this.index + 1);
            }
            int n = CachedRowSetDataModel.this.metadata.getColumnCount();
            for (int i = 1; i <= n; ++i) {
                super.put(CachedRowSetDataModel.this.metadata.getColumnName(i), CachedRowSetDataModel.this.metadata.getColumnName(i));
            }
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean containsValue(Object value) {
            Iterator keys = this.keySet().iterator();
            while (keys.hasNext()) {
                Object key = keys.next();
                Object contained = this.get(key);
                if (!(value == null ? contained == null : value.equals(contained))) continue;
                return true;
            }
            return false;
        }

        public Set entrySet() {
            return new CachedRowSetEntries(this);
        }

        public Object get(Object key) {
            if (!this.containsKey(key)) {
                return null;
            }
            try {
                if (Beans.isDesignTime()) {
                    return CachedRowSetDataModel.getFakeData(CachedRowSetDataModel.this.metadata, (String)this.realKey(key));
                }
                CachedRowSetDataModel.this.cachedRowSet.absolute(this.index + 1);
                return CachedRowSetDataModel.this.cachedRowSet.getObject((String)this.realKey(key));
            }
            catch (SQLException e) {
                throw new FacesException((Throwable)e);
            }
        }

        public Set keySet() {
            return new CachedRowSetKeys(this);
        }

        public Object put(Object key, Object value) {
            if (Beans.isDesignTime()) {
                return this.get(key);
            }
            if (!this.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            if (!(key instanceof String)) {
                throw new IllegalArgumentException();
            }
            try {
                CachedRowSetDataModel.this.cachedRowSet.absolute(this.index + 1);
                Object previous = CachedRowSetDataModel.this.cachedRowSet.getObject((String)this.realKey(key));
                if (previous == null && value == null) {
                    return previous;
                }
                if (previous != null && value != null && previous.equals(value)) {
                    return previous;
                }
                CachedRowSetDataModel.this.cachedRowSet.updateObject((String)this.realKey(key), value);
                CachedRowSetDataModel.this.updated();
                return previous;
            }
            catch (SQLException e) {
                throw new FacesException((Throwable)e);
            }
        }

        public void putAll(Map map) {
            if (Beans.isDesignTime()) {
                return;
            }
            Iterator keys = map.keySet().iterator();
            while (keys.hasNext()) {
                Object key = keys.next();
                this.put(key, map.get(key));
            }
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        public Collection values() {
            return new CachedRowSetValues(this);
        }

        Object realKey(Object key) {
            return super.get(key);
        }

        Iterator realKeys() {
            return super.keySet().iterator();
        }
    }

    private class CachedRowSetValues
    extends AbstractCollection {
        private CachedRowSetMap map;

        public CachedRowSetValues(CachedRowSetMap map) {
            this.map = map;
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object value) {
            return this.map.containsValue(value);
        }

        public Iterator iterator() {
            return new CachedRowSetValuesIterator(this.map);
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.map.size();
        }
    }

    private class CachedRowSetValuesIterator
    implements Iterator {
        private CachedRowSetMap map;
        private Iterator keys;

        public CachedRowSetValuesIterator(CachedRowSetMap map) {
            this.map = map;
            this.keys = map.keySet().iterator();
        }

        public boolean hasNext() {
            return this.keys.hasNext();
        }

        public Object next() {
            return this.map.get(this.keys.next());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

