/*
 * Decompiled with CFR 0.152.
 */
package com.sun.errorhandler;

import com.sun.errorhandler.DebugClientThread;
import com.sun.errorhandler.DebugProtocol;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExceptionHandler
extends HttpServlet {
    private static ResourceBundle rb = ResourceBundle.getBundle("com.sun.errorhandler.Bundle", Locale.getDefault());
    private static int debugLevel = 0;
    private boolean readPropertiesAlready = false;

    public static int getDebugLevel() {
        return debugLevel;
    }

    public void init(ServletConfig servletConfig) {
        try {
            super.init(servletConfig);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void initProps() {
        if (!this.readPropertiesAlready) {
            this.readPropertiesAlready = true;
            String string = this.getInitParameter("errorHost");
            if (string != null) {
                DebugClientThread.errorHost = string;
                String string2 = this.getInitParameter("errorPort");
                if (string2 != null) {
                    DebugClientThread.setErrorPort(string2);
                } else {
                    DebugClientThread.setErrorPort("0");
                }
            }
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.initProps();
        this.generateResponse(httpServletRequest, httpServletResponse);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.initProps();
        if (httpServletRequest.getParameter("debug") != null || httpServletRequest.getParameter("errorHost") != null || httpServletRequest.getParameter("errorPort") != null) {
            this.setDebugVars(httpServletRequest);
        }
        this.generateResponse(httpServletRequest, httpServletResponse);
    }

    public void generateResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = (String)httpServletRequest.getAttribute("javax.servlet.error.request_uri");
        httpServletResponse.setContentType("text/html;charset=UTF-8");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("<HTML>");
        printWriter.println("<HEAD>");
        printWriter.println("<TITLE>");
        printWriter.println(rb.getString("EH_pagetitle"));
        printWriter.println("</TITLE>");
        printWriter.print("<style>I{font-family:");
        printWriter.print("Verdana,UTF-8");
        printWriter.println(";font-weight:italic;font-size:8pt;color:maroon}</style>");
        printWriter.println("</HEAD>");
        printWriter.println("<BODY BGCOLOR='white'>");
        printWriter.println("<CENTER><B>");
        printWriter.println(rb.getString("EH_pagetitle"));
        printWriter.println("</B></CENTER>");
        printWriter.println("<P>");
        printWriter.println("<FONT COLOR='blue'>");
        printWriter.println("<BR><B>");
        printWriter.println(rb.getString("EH_Description"));
        printWriter.println("</B> ");
        printWriter.println(rb.getString("EH_Reason"));
        printWriter.println("<BR>");
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        for (Throwable throwable = (Throwable)httpServletRequest.getAttribute("javax.servlet.error.exception"); throwable != null; throwable = throwable.getCause()) {
            arrayList.add(throwable);
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            this.displayMessage((Throwable)arrayList.get(i), printWriter);
        }
        printWriter.println("</FONT>");
        printWriter.println("</P>");
        if (ExceptionHandler.getDebugLevel() > 0) {
            printWriter.println("<HR><P>Debugging on.</P>");
            printWriter.println("<P>Errors will be sent to " + DebugClientThread.errorHost + " port " + DebugClientThread.getErrorPort() + "</P>");
        }
        printWriter.println("</BODY>");
        printWriter.println("</HTML>");
        printWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayMessage(Throwable throwable, PrintWriter printWriter) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string = throwable.getClass().getName();
        String string2 = string.substring(string.lastIndexOf(".") + 1);
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n = -1;
        String string3 = null;
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            string3 = stackTraceElementArray[i].getFileName();
            if (string3 == null) continue;
            String string4 = stackTraceElementArray[i].getClassName();
            try {
                object4 = Class.forName(string4);
                object3 = ((Class)object4).getResource(string3);
                object2 = ((URL)object3).openStream();
                if (object2 == null) continue;
                ((InputStream)object2).close();
                n = i;
                break;
            }
            catch (Exception exception) {
                continue;
            }
        }
        printWriter.println("<BR><B>");
        printWriter.println(rb.getString("EH_ExceptionDetails"));
        printWriter.println("</B> ");
        printWriter.println(string);
        printWriter.println("<BR>");
        String string5 = throwable.getLocalizedMessage();
        if (string5 == null) {
            string5 = throwable.getMessage();
        }
        printWriter.println("&nbsp;&nbsp;" + string5 + "<BR>");
        printWriter.println("<BR><B>");
        printWriter.println(rb.getString("EH_PossibleSource"));
        printWriter.println("</B><BR>");
        printWriter.println("&nbsp;&nbsp;");
        printWriter.println(rb.getString("EH_ClassName"));
        printWriter.println(" <I>" + (stackTraceElementArray.length < 1 ? rb.getString("EH_unknownValue") : stackTraceElementArray[0].getClassName()) + "</I> <BR>");
        printWriter.println("&nbsp;&nbsp;");
        printWriter.println(rb.getString("EH_FileName"));
        printWriter.println(" <I>" + (stackTraceElementArray.length < 1 ? rb.getString("EH_unknownValue") : stackTraceElementArray[0].getFileName()) + "</I> <BR>");
        printWriter.println("&nbsp;&nbsp;");
        printWriter.println(rb.getString("EH_MethodName"));
        printWriter.println(" <I>" + (stackTraceElementArray.length < 1 ? rb.getString("EH_unknownValue") : stackTraceElementArray[0].getMethodName()) + "</I> <BR>");
        printWriter.println("&nbsp;&nbsp;");
        printWriter.println(rb.getString("EH_LineNumber"));
        printWriter.println(" <I>" + (stackTraceElementArray.length < 1 ? rb.getString("EH_unknownValue") : Integer.toString(stackTraceElementArray[0].getLineNumber())) + "</I> <BR>");
        printWriter.println("<BR>");
        if (n != -1) {
            int n2 = stackTraceElementArray[n].getLineNumber();
            object4 = stackTraceElementArray[n].getClassName();
            string3 = stackTraceElementArray[n].getFileName();
            try {
                object3 = Class.forName((String)object4);
                object2 = ((Class)object3).getResource(string3);
                if (object2 != null) {
                    object = ((URL)object2).openStream();
                    LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader((InputStream)object));
                    printWriter.println("<table width=100% bgcolor=\"#ffffcc\"><tr><td><code>");
                    for (int i = 0; i < n2 + 3; ++i) {
                        String string6 = lineNumberReader.readLine();
                        int n3 = lineNumberReader.getLineNumber();
                        if (n3 < n2 - 3) continue;
                        if (n3 == n2) {
                            printWriter.println("<FONT COLOR='red' BGCOLOR='white'><B>");
                            printWriter.println(n3 + ": " + this.appendHTMLChar(string6) + "<BR>");
                            printWriter.println("</B></FONT>");
                            continue;
                        }
                        printWriter.println(n3 + ": " + this.appendHTMLChar(string6) + "<BR>");
                    }
                    printWriter.println("</code></td></tr></table>");
                    ((InputStream)object).close();
                    lineNumberReader.close();
                }
            }
            catch (Exception exception) {}
        } else {
            printWriter.println("<table width=100% bgcolor=\"#ffffcc\"><tr><td><code>");
            printWriter.println(rb.getString("EH_NoSourceLong"));
            printWriter.println("<BR></code></td></tr></table>");
        }
        printWriter.println("<BR><B>");
        printWriter.println(rb.getString("EH_StackTrace"));
        printWriter.println(" </B><BR><BR>");
        printWriter.println("<table width=100% bgcolor=\"#eeddff\"><tr><td><code>");
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            int n4 = stackTraceElementArray[i].getLineNumber();
            object3 = stackTraceElementArray[i].getClassName();
            object2 = stackTraceElementArray[i].getFileName();
            object = stackTraceElementArray[i].getMethodName();
            if (i == n) {
                printWriter.println("<FONT COLOR='brown' BGCOLOR='white'><B>");
            }
            if (object2 != null) {
                printWriter.println((String)object3 + "." + (String)object + "(" + (String)object2 + ":" + n4 + ")<BR>");
            } else {
                printWriter.println((String)object3 + "." + (String)object + "(");
                printWriter.println(rb.getString("EH_NoSourceShort"));
                printWriter.println(")<BR>");
            }
            if (i != n) continue;
            printWriter.println("</B></FONT>");
        }
        printWriter.println("</code></td></tr></table>");
        if (n == -1) {
            n = 0;
        }
        if (DebugClientThread.errorHost != null && stackTraceElementArray.length > 0) {
            DebugClientThread debugClientThread = new DebugClientThread();
            DebugProtocol debugProtocol = new DebugProtocol();
            debugClientThread.start();
            if (debugClientThread.testConnected()) {
                debugClientThread.sendMessage(DebugProtocol.DEBUG_CLIENT_ID + DebugProtocol.DEBUG_DELIMITER + DebugProtocol.DEBUG_CLIENT_NAME);
                debugClientThread.sendMessage(DebugProtocol.DEBUG_REQUEST_START);
                debugClientThread.sendMessage(DebugProtocol.DEBUG_CLASS_NAME + DebugProtocol.DEBUG_DELIMITER + stackTraceElementArray[n].getClassName());
                debugClientThread.sendMessage(DebugProtocol.DEBUG_FILE_NAME + DebugProtocol.DEBUG_DELIMITER + stackTraceElementArray[n].getFileName());
                debugClientThread.sendMessage(DebugProtocol.DEBUG_METHOD_NAME + DebugProtocol.DEBUG_DELIMITER + stackTraceElementArray[n].getMethodName());
                debugClientThread.sendMessage(DebugProtocol.DEBUG_LINE_NUMBER + DebugProtocol.DEBUG_DELIMITER + stackTraceElementArray[n].getLineNumber());
                debugClientThread.sendMessage(DebugProtocol.DEBUG_REQUEST_END);
                debugClientThread.disconnect();
            }
        }
    }

    public String appendHTMLChar(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block8;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block8;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block8;
                }
                case ' ': {
                    stringBuffer.append("&nbsp;");
                    continue block8;
                }
                case '\n': {
                    stringBuffer.append("<br>");
                    continue block8;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private void setDebugVars(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("debug");
        if (string != null) {
            debugLevel = "1".equals(string = string.trim()) || "true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string) ? 1 : 0;
        }
        if ((string = httpServletRequest.getParameter("errorHost")) != null) {
            DebugClientThread.errorHost = !"".equals(string) ? null : string;
        }
        if ((string = httpServletRequest.getParameter("errorPort")) != null) {
            DebugClientThread.setErrorPort(string);
        }
    }
}

