/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2ee.blueprints.ui.mapviewer;

import com.sun.j2ee.blueprints.ui.design.AbstractDesignInfo;
import com.sun.j2ee.blueprints.ui.mapviewer.MapComponent;
import com.sun.j2ee.blueprints.ui.mapviewer.MapPoint;
import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.Result;
import com.sun.rave.designtime.faces.FacesDesignContext;
import com.sun.rave.designtime.faces.FacesDesignProperty;
import com.sun.rave.designtime.faces.ResolveResult;
import java.beans.PropertyDescriptor;
import javax.faces.el.ValueBinding;

public class MapComponentDesignInfo
extends AbstractDesignInfo {
    private static final String CENTER_PROPERTY = "center";
    private static final String CENTER_SUFFIX = "_center";
    private static final String ID_PROPERTY = "id";

    public MapComponentDesignInfo() {
        super(MapComponent.class);
    }

    public Result beanCreatedSetup(DesignBean bean) {
        DesignProperty prop = null;
        prop = bean.getProperty("style");
        if (prop != null) {
            String value = (String)prop.getValue();
            value = value != null ? value + "; " : "";
            value = value + "height: 300px; width: 500px";
            prop.setValue((Object)value);
        }
        if ((prop = bean.getProperty("zoomLevel")) != null) {
            prop.setValue((Object)new Integer(4));
        }
        this.createCenter(bean);
        return Result.SUCCESS;
    }

    public Result beanDeletedCleanup(DesignBean bean) {
        this.deleteCenter(bean);
        return Result.SUCCESS;
    }

    public Result beanPastedSetup(DesignBean bean) {
        DesignProperty center = bean.getProperty(CENTER_PROPERTY);
        if (center != null && center.getValueSource() != null && center.getValueSource().indexOf(CENTER_SUFFIX) >= 0) {
            this.createCenter(bean);
        }
        return Result.SUCCESS;
    }

    public void propertyChanged(DesignProperty property, Object oldValue) {
        DesignBean map;
        DesignBean center;
        PropertyDescriptor pd = property.getPropertyDescriptor();
        if (pd.getName().equals(ID_PROPERTY) && (center = this.findCenter(map = property.getDesignBean())) != null) {
            center.setInstanceName(map.getInstanceName() + CENTER_SUFFIX);
        }
    }

    private DesignBean createCenter(DesignBean bean) {
        Class mapPointClass;
        FacesDesignContext context = (FacesDesignContext)bean.getDesignContext();
        Class clazz = mapPointClass = MapPoint.class;
        if (context.canCreateBean(mapPointClass.getName(), null, null)) {
            DesignBean center = context.createBean(mapPointClass.getName(), null, null);
            center.setInstanceName(bean.getInstanceName() + CENTER_SUFFIX);
            bean.getProperty(CENTER_PROPERTY).setValueSource(context.getBindingExpr(center));
            return center;
        }
        return null;
    }

    private void deleteCenter(DesignBean bean) {
        DesignBean center = this.findCenter(bean);
        if (center == null) {
            return;
        }
        FacesDesignProperty centerProperty = (FacesDesignProperty)bean.getProperty(CENTER_PROPERTY);
        String expression = centerProperty.getValueBinding().getExpressionString();
        centerProperty.unset();
        DesignBean[] beans = bean.getDesignContext().getBeansOfType(MapComponent.class);
        int references = 0;
        for (int i = 0; i < beans.length; ++i) {
            String test;
            FacesDesignProperty prop = (FacesDesignProperty)beans[i].getProperty(CENTER_PROPERTY);
            ValueBinding vb = prop.getValueBinding();
            if (vb == null || !expression.equals(test = vb.getExpressionString())) continue;
            ++references;
        }
        if (references == 0) {
            bean.getDesignContext().deleteBean(center);
        }
    }

    private DesignBean findCenter(DesignBean bean) {
        FacesDesignContext context = (FacesDesignContext)bean.getDesignContext();
        FacesDesignProperty centerProperty = (FacesDesignProperty)bean.getProperty(CENTER_PROPERTY);
        if (centerProperty == null || !centerProperty.isBound()) {
            return null;
        }
        String expression = centerProperty.getValueBinding().getExpressionString();
        return this.findCenter(context, expression);
    }

    private DesignBean findCenter(FacesDesignContext context, String expression) {
        DesignBean centerBean;
        ResolveResult result = context.resolveBindingExprToBean(expression);
        if (result == null || result.getDesignBean() == null) {
            return null;
        }
        if (MapPoint.class.isAssignableFrom((centerBean = result.getDesignBean()).getInstance().getClass())) {
            return centerBean;
        }
        return null;
    }
}

