/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: AutoCompleteHandler.java,v 1.3 2006/04/06 08:16:22 mattbohm Exp $
 */

package com.sun.j2ee.blueprints.ui.autocomplete;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.MethodBinding;
import javax.servlet.http.HttpServletResponse;
import org.apache.shale.remoting.faces.ResponseFactory;

/**
 * <p>AJAX event handler(s) for {@link AutoCompleteComponent}.</p>
 */
public class AutoCompleteHandler {
    

    // -------------------------------------------------------- Static Variables


    /**
     * <p>The parameter signature for the application completion method.</p>
     */
    private static Class completionSignature[] = {
        FacesContext.class,
        String.class,
        CompletionResult.class
    };


    /**
     * <p>Factory for response writers that we can use to construct the
     * outgoing response.</p>
     */
    private static ResponseFactory factory = new ResponseFactory();


    // -------------------------------------------------------------- Properties


    /**
     * <p>The method binding expression of the application method we
     * should delegate to.</p>
     */
    private String method = null;


    /**
     * <p>Return the method binding expression we should delegate to.</p>
     */
    public String getMethod() {
        return this.method;
    }


    /**
     * <p>Set the method binding expressino we should delegate to.</p>
     *
     * @param method The new method binding expression
     */
    public void setMethod(String method) {
        this.method = method;
    }


    /**
     * <p>The match prefix we should use for selection.</p>
     */
    private String prefix = null;


    /**
     * <p>Return the match prefix we should use for selection.</p>
     */
    public String getPrefix() {
        return this.prefix;
    }


    /**
     * <p>Set the match prefix we should use for selection.</p>
     *
     * @param prefix The new match prefix
     */
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }


    // ---------------------------------------------------------- Public Methods


    /**
     * <p>Respond to an asynchronous request for completions that
     * match the specified prefix.</p>
     */
    public void completions() throws IOException {

        // Extract request parameters we are interested in
        String method = getMethod();
        String prefix = getPrefix();

        // Construct and invoke method binding that will call the
        // application method
        FacesContext context = FacesContext.getCurrentInstance();
        MethodBinding mb = context.getApplication().
          createMethodBinding(method, completionSignature);
        CompletionResult result = new CompletionResult();
        mb.invoke(context, new Object[] { context, prefix, result });

        //temp fix until shale-remoting allows the no-cache setting
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        response.setHeader("Pragma", "No-Cache");
        response.setHeader("Cache-Control", "no-cache,no-store,max-age=0");
        response.setDateHeader("Expires", 1); 
        
        // Acquire a response containing these results
        ResponseWriter writer = factory.getResponseWriter(context, "text/xml");
        Iterator items = result.getItems().iterator();

        // Render the response
        writer.startDocument();
        writer.startElement("items", null);
        writer.write("\n");
        while (items.hasNext()) {
            String item = (String) items.next();
            if (item != null) {
                writer.startElement("item", null);
                writer.writeText(item, null);
                writer.endElement("item");
                writer.write("\n");
            }
        }
        writer.endElement("items");
        writer.write("\n");
        writer.endDocument();
        writer.flush();

    }


}
