/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: AutoCompleteTag.java,v 1.5 2006/01/19 20:01:35 craig_mcc Exp $
 */

package com.sun.j2ee.blueprints.ui.autocomplete;

import com.sun.j2ee.blueprints.ui.util.AbstractEditableValueHolderUIComponentTag;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.ValueChangeEvent;
import javax.faces.webapp.UIComponentTag;

/**
 * <p>This class is the tag handler class for a <code>AutoCompleteComponent</code>
 * component associated with a <code>AjaxTextFieldRenderer</code> renderer.</p>
 */
public class AutoCompleteTag extends AbstractEditableValueHolderUIComponentTag {


    // ---------------------------------------------------------- Tag Attributes


    private String accesskey;
    public void setAccesskey(String accesskey) {
        this.accesskey = accesskey;
    }

    private String alt;
    public void setAlt(String alt) {
        this.alt = alt;
    }

    private String completionMethod;
    public void setCompletionMethod(String completionMethod) {
        this.completionMethod = completionMethod;
    }
    
    private String dir;
    public void setDir(String dir) {
        this.dir = dir;
    }

    private String disabled;
    public void setDisabled(String disabled) {
        this.disabled = disabled;
    }

    private String lang;
    public void setLang(String lang) {
        this.lang = lang;
    }

    private String maxlength;
    public void setMaxlength(String maxlength) {
        this.maxlength = maxlength;
    }

    private String onblur;
    public void setOnblur(String onblur) {
        this.onblur = onblur;
    }

    private String onchange;
    public void setOnchange(String onchange) {
        this.onchange = onchange;
    }

    private String onchoose;
    public void setOnchoose(String onchoose) {
        this.onchoose = onchoose;
    }

    private String onclick;
    public void setOnclick(String onclick) {
        this.onclick = onclick;
    }

    private String ondblclick;
    public void setOndblclick(String ondblclick) {
        this.ondblclick = ondblclick;
    }

    private String ondisplay;
    public void setOndisplay(String ondisplay) {
        this.ondisplay = ondisplay;
    }
    
    private String onfocus;
    public void setOnfocus(String onfocus) {
        this.onfocus = onfocus;
    }

    private String onkeydown;
    public void setOnkeydown(String onkeydown) {
        this.onkeydown = onkeydown;
    }

    private String onkeypress;
    public void setOnkeypress(String onkeypress) {
        this.onkeypress = onkeypress;
    }

    private String onkeyup;
    public void setOnkeyup(String onkeyup) {
        this.onkeyup = onkeyup;
    }

    private String onmousedown;
    public void setOnmousedown(String onmousedown) {
        this.onmousedown = onmousedown;
    }

    private String onmousemove;
    public void setOnmousemove(String onmousemove) {
        this.onmousemove = onmousemove;
    }

    private String onmouseout;
    public void setOnmouseout(String onmouseout) {
        this.onmouseout = onmouseout;
    }

    private String onmouseover;
    public void setOnmouseover(String onmouseover) {
        this.onmouseover = onmouseover;
    }

    private String onmouseup;
    public void setOnmouseup(String onmouseup) {
        this.onmouseup = onmouseup;
    }

    private String onselect;
    public void setOnselect(String onselect) {
        this.onselect = onselect;
    }

    private String readonly;
    public void setReadonly(String readonly) {
        this.readonly = readonly;
    }

    private String size;
    public void setSize(String size) {
        this.size = size;
    }

    private String tabindex;
    public void setTabindex(String tabindex) {
        this.tabindex = tabindex;
    }


    // -------------------------------------------------- UIComponentTag Methods


    /**
     * Gets the type of the component associated wit hthe tag.
     * @return the name of the component type
     */
    public String getComponentType() {
        return "AutoComplete";
    }

    /**
     * Gets the type of the renderer that will render this tag.
     * @return the type of the renderer that renders this tag
     */
    public String getRendererType() {
        return "AutoComplete";
    }

    /**
     * Releases resources allocated during the execution of this tag handler.
     */
    public void release() {

        super.release();
        this.accesskey = null;
        this.alt = null;
        this.completionMethod = null;
        this.dir = null;
        this.disabled = null;
        this.lang = null;
        this.maxlength = null;
        this.onblur = null;
        this.onchange = null;
        this.onchoose = null;
        this.onclick = null;
        this.ondblclick = null;
        this.ondisplay = null;
        this.onfocus = null;
        this.onkeydown = null;
        this.onkeypress = null;
        this.onkeyup = null;
        this.onmousedown = null;
        this.onmousemove = null;
        this.onmouseout = null;
        this.onmouseover = null;
        this.onmouseup = null;
        this.onselect = null;
        this.readonly = null;
        this.size = null;
        this.tabindex = null;

    }

    /**
     * Sets the properties of the specified component.
     * @param component the component associated with this tag
     */
    protected void setProperties(UIComponent component) {

        super.setProperties(component);
        configureString(component, "accesskey", accesskey);
        configureString(component, "alt", alt);
        if (completionMethod != null) {
            if (isValueReference(completionMethod)) {
                MethodBinding mb = getFacesContext().getApplication().
                        createMethodBinding(completionMethod, completionMethodArgs);
                ((AutoCompleteComponent) component).setCompletionMethod(mb);
            } else {
                throw new IllegalArgumentException(completionMethod);
            }
        }
        configureString(component, "dir", dir);
        configureBoolean(component, "disabled", disabled);
        configureString(component, "lang", lang);
        configureInteger(component, "maxlength", maxlength);
        configureString(component, "onblur", onblur);
        configureString(component, "onchange", onchange);
        configureString(component, "onchoose", onchoose);
        configureString(component, "onclick", onclick);
        configureString(component, "ondblclick", ondblclick);
        configureString(component, "ondisplay", ondisplay);
        configureString(component, "onfocus", onfocus);
        configureString(component, "onkeydown", onkeydown);
        configureString(component, "onkeypress", onkeypress);
        configureString(component, "onkeyup", onkeyup);
        configureString(component, "onmousedown", onmousedown);
        configureString(component, "onmousemove", onmousemove);
        configureString(component, "onmouseout", onmouseout);
        configureString(component, "onmouseover", onmouseover);
        configureString(component, "onmouseup", onmouseup);
        configureString(component, "onselect", onselect);
        configureBoolean(component, "readonly", readonly);
        configureInteger(component, "size", size);
        configureInteger(component, "tabindex", tabindex);

    }


    /**
     * <p>The parameter signature for the completion method.</p>
     */
    private static Class[] completionMethodArgs =
    { FacesContext.class, String.class, CompletionResult.class };


}
