/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: Completable.java,v 1.3 2006/01/19 20:01:36 craig_mcc Exp $
 */

package com.sun.j2ee.blueprints.ui.autocomplete;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

/**
 * Interface implemented by classes which can provide completion results
 * for a given prefix.
 *
 * @author Tor Norbye
 */
public interface Completable {
    /** This method is called asynchronously from client javascript calls;
     * it should return a short list of possible matches for the given prefix
     * as an array of Strings. These are returned by adding them to the
     * result object.  These items will then be presented to the user in
     * an auto complete popup.
     *
     * @param context The faces context for the JSF application
     * @param prefix A string prefix to select matches from (note that the
     *   prefix may be empty in which case it may be natural to return the
     *   first N matches.
     * @param result A result object; call <code>addItem</code> or
     *   <code>addItems</code> methods on
     *   {@link CompletionResult} to populate the completion result
     *   returned to the browser.
     */
    public void complete(FacesContext context, String prefix, CompletionResult result); // throws CompletionException?

}
