/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: RichTextareaEditorComponent.java,v 1.1 2006/03/06 22:30:16 craig_mcc Exp $
 */

package com.sun.j2ee.blueprints.ui.editor;

import java.io.IOException;

import javax.faces.component.html.HtmlInputTextarea;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;


/**
 * <p>Textarea component that features "rich text editing" capabilities.
 * The resulting content will be HTML markup when the form containing this
 * component is submitted.</p>
*/
public class RichTextareaEditorComponent extends HtmlInputTextarea {

    public RichTextareaEditorComponent() {
        super();
        setRendererType("com.sun.j2ee.blueprints.ui.editor.RichTextareaEditor");
    }

    public String getFamily() {
        return "com.sun.j2ee.blueprints.ui.editor.RichTextareaEditor";
    }


    private String alt;

    public String getAlt() {
        if (this.alt != null) {
            return this.alt;
        }
        ValueBinding _vb = getValueBinding("alt");
        if (_vb != null) {
            return (String) _vb.getValue(getFacesContext());
        } else {
            return null;
        }
    }
    public void setAlt(String alt) {
        this.alt = alt;
    }


    private String items;

    public String getItems() {
        if (this.items != null) {
            return this.items;
        }
        ValueBinding _vb = getValueBinding("items");
        if (_vb != null) {
            return (String) _vb.getValue(getFacesContext());
        } else {
            return null;
        }
    }
    public void setItems(String items) {
        this.items = items;
    }


    public Object saveState(FacesContext context) {
        Object[] values = new Object[3];
        values[0] = super.saveState(context);
        values[1] = alt;
        values[2] = items;
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.alt = (String) values[1];
        this.items = (String) values[2];
    }

}
