/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: RichTextareaEditorTag.java,v 1.1 2006/03/06 22:30:16 craig_mcc Exp $
 */

package com.sun.j2ee.blueprints.ui.editor;

import com.sun.j2ee.blueprints.ui.util.AbstractEditableValueHolderUIComponentTag;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.ValueBinding;
import javax.faces.event.ValueChangeEvent;
import javax.faces.webapp.UIComponentTag;

/**
 * <p>This class is the tag handler class for a <code>RichTextareaEditorComponent</code>
 * component associated with a <code>RichTextareaEditorRenderer</code> renderer.</p>
 */
public class RichTextareaEditorTag extends AbstractEditableValueHolderUIComponentTag {


    // ---------------------------------------------------------- Tag Attributes


    private String accesskey;
    public void setAccesskey(String accesskey) {
        this.accesskey = accesskey;
    }

    private String alt;
    public void setAlt(String alt) {
        this.alt = alt;
    }

    private String cols;
    public void setCols(String cols) {
        this.cols = cols;
    }

    private String dir;
    public void setDir(String dir) {
        this.dir = dir;
    }

    private String disabled;
    public void setDisabled(String disabled) {
        this.disabled = disabled;
    }

    private String items;
    public void setItems(String items) {
        this.items = items;
    }

    private String lang;
    public void setLang(String lang) {
        this.lang = lang;
    }

    private String onblur;
    public void setOnblur(String onblur) {
        this.onblur = onblur;
    }

    private String onchange;
    public void setOnchange(String onchange) {
        this.onchange = onchange;
    }

    private String onclick;
    public void setOnclick(String onclick) {
        this.onclick = onclick;
    }

    private String ondblclick;
    public void setOndblclick(String ondblclick) {
        this.ondblclick = ondblclick;
    }

    private String onfocus;
    public void setOnfocus(String onfocus) {
        this.onfocus = onfocus;
    }

    private String onkeydown;
    public void setOnkeydown(String onkeydown) {
        this.onkeydown = onkeydown;
    }

    private String onkeypress;
    public void setOnkeypress(String onkeypress) {
        this.onkeypress = onkeypress;
    }

    private String onkeyup;
    public void setOnkeyup(String onkeyup) {
        this.onkeyup = onkeyup;
    }

    private String onmousedown;
    public void setOnmousedown(String onmousedown) {
        this.onmousedown = onmousedown;
    }

    private String onmousemove;
    public void setOnmousemove(String onmousemove) {
        this.onmousemove = onmousemove;
    }

    private String onmouseout;
    public void setOnmouseout(String onmouseout) {
        this.onmouseout = onmouseout;
    }

    private String onmouseover;
    public void setOnmouseover(String onmouseover) {
        this.onmouseover = onmouseover;
    }

    private String onmouseup;
    public void setOnmouseup(String onmouseup) {
        this.onmouseup = onmouseup;
    }

    private String onselect;
    public void setOnselect(String onselect) {
        this.onselect = onselect;
    }

    private String readonly;
    public void setReadonly(String readonly) {
        this.readonly = readonly;
    }

    private String rows;
    public void setRows(String rows) {
        this.rows = rows;
    }

    private String tabindex;
    public void setTabindex(String tabindex) {
        this.tabindex = tabindex;
    }


    private String text;
    public void setText(String text) {
        this.text = text;
    }


    // -------------------------------------------------- UIComponentTag Methods


    /**
     * Gets the type of the component associated wit hthe tag.
     * @return the name of the component type
     */
    public String getComponentType() {
        return "com.sun.j2ee.blueprints.ui.editor.RichTextareaEditor";
    }

    /**
     * Gets the type of the renderer that will render this tag.
     * @return the type of the renderer that renders this tag
     */
    public String getRendererType() {
        return "com.sun.j2ee.blueprints.ui.editor.RichTextareaEditor";
    }

    /**
     * Releases resources allocated during the execution of this tag handler.
     */
    public void release() {

        super.release();
        this.accesskey = null;
        this.alt = null;
        this.cols = null;
        this.dir = null;
        this.disabled = null;
        this.items = null;
        this.lang = null;
        this.onblur = null;
        this.onchange = null;
        this.onclick = null;
        this.ondblclick = null;
        this.onfocus = null;
        this.onkeydown = null;
        this.onkeypress = null;
        this.onkeyup = null;
        this.onmousedown = null;
        this.onmousemove = null;
        this.onmouseout = null;
        this.onmouseover = null;
        this.onmouseup = null;
        this.onselect = null;
        this.readonly = null;
        this.rows = null;
        this.tabindex = null;
        this.text = null;

    }

    /**
     * Sets the properties of the specified component.
     * @param component the component associated with this tag
     */
    protected void setProperties(UIComponent component) {

        super.setProperties(component);
        configureString(component, "accesskey", accesskey);
        configureString(component, "alt", alt);
        configureInteger(component, "cols", cols);
        configureString(component, "dir", dir);
        configureBoolean(component, "disabled", disabled);
        configureString(component, "items", items);
        configureString(component, "lang", lang);
        configureString(component, "onblur", onblur);
        configureString(component, "onchange", onchange);
        configureString(component, "onclick", onclick);
        configureString(component, "ondblclick", ondblclick);
        configureString(component, "onfocus", onfocus);
        configureString(component, "onkeydown", onkeydown);
        configureString(component, "onkeypress", onkeypress);
        configureString(component, "onkeyup", onkeyup);
        configureString(component, "onmousedown", onmousedown);
        configureString(component, "onmousemove", onmousemove);
        configureString(component, "onmouseout", onmouseout);
        configureString(component, "onmouseover", onmouseover);
        configureString(component, "onmouseup", onmouseup);
        configureString(component, "onselect", onselect);
        configureBoolean(component, "readonly", readonly);
        configureInteger(component, "rows", rows);
        configureInteger(component, "tabindex", tabindex);
        configureString(component, "text", text);

    }


}
