/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: GeoCoder.java,v 1.2 2006/01/19 20:01:37 craig_mcc Exp $
 */

package com.sun.j2ee.blueprints.ui.maplocator;

import java.net.*;
import java.io.*;

public class GeoCoder {

    /**
     * An identifier used to identofy an application using the geocoder service.
     */
    private String applicationId = null;

    private static String SERVICE_URL = "http://api.local.yahoo.com/MapsService/V1/geocode";
    private static String APPLICATION_ID = "jsf-geo-map";

    /**
     * <p>Query the geocoding service for one or more detailed coordinates given
     * an <code>applicationId</code> and <code>location</code>.  
     * The <code>applicationId</code> is a <code>String</code> that uniquely 
     * identifies your application to the geocoding service.  The <code>location</code>
     * is a <code>String</code> specifying the location to use for the service.
     * The text may be:</p>
     * <ul>
     *   <li>city, state</li>
     *   <li>city, state, zip</li>
     *   <li>zip</li>
     *   <li>street, city, state</li>
     *   <li>street, city, state, zip</li>
     *   <li>street, zip</li>
     * </ul>
     */
    public static String locate(String proxyHost, String proxyPort, String location)
        throws IOException {
        // Determine if we need to set a proxy based on web.xml..
        if ((proxyHost != null && proxyHost != "") && 
            (proxyPort != null && proxyPort != "")) {
            System.out.println("Contacting Geocoding service with proxy host:"+proxyHost+
                " proxy port:"+proxyPort);
            System.getProperties().put("http.proxyHost", proxyHost);
            System.getProperties().put("http.proxyPort", proxyPort);
        }
        if (location == null) {
            System.err.println(
                "Please provide a location to check");
            return null;
        } 

        try {
            location = URLEncoder.encode(location, "ISO-8859-1");
        } catch (UnsupportedEncodingException ee) {
            System.err.println("Unsupported Encoding");
            return null;
        }
        String urlString = SERVICE_URL + "?appid=" + APPLICATION_ID + "&location=" + location;
        StringBuffer sb = new StringBuffer();
        try {
            URL url = new URL(urlString);
            URLConnection connection = url.openConnection();
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                httpConnection.connect();
                int response = httpConnection.getResponseCode();
                if (response != 200) {
                    System.err.println("Problem contacting service.  Response Code:" + response);
                    return null;
                }
                BufferedReader in = new BufferedReader(new InputStreamReader(
                    httpConnection.getInputStream()));
                String inputLine;
                while ((inputLine = in.readLine()) != null) {
                    sb.append(inputLine);
                }
                in.close();
            }
        } catch (java.net.UnknownHostException uhe) {
            uhe.printStackTrace();
            throw new IOException("UnKnown Host: "+uhe.getMessage()+" -  Do you need to set a proxy?");
        } catch (IOException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        return sb.toString();
    }
}
