/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: MapLocatorComponent.java,v 1.5 2006/01/19 20:01:38 craig_mcc Exp $
 */

package com.sun.j2ee.blueprints.ui.maplocator;

import java.io.IOException;

import javax.faces.el.ValueBinding;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;

/**
 * Google Maps JSF Component.  
 *
 * FIXME add more properties
 */
public class MapLocatorComponent extends UIComponentBase {

    /**
     * <p>The standard component type for this component.</p>
     */
    public static final String COMPONENT_TYPE = "MapLocator";
                                                                                                                         
    /**
     * <p>The standard component family for this component.</p>
     */
    public static final String COMPONENT_FAMILY = "MapLocator";

    /**
     * <p>The standard renderer type for this component.</p>
     */
    public static final String RENDERER_TYPE = "MapLocator";

    private String key = null;
    private String width = null;
    private String height = null;
    private Object location = null;
    private String style = null;
    private String styleClass = null;

    public MapLocatorComponent() {
        super();
        setRendererType(RENDERER_TYPE);
    }

    /**
     * <p>Return the key of the mapLocator
     */
    public String getKey() {
       if (null != this.key) {
            return this.key;
        }
        ValueBinding _vb = getValueBinding("key");
        if (_vb != null) {
            return (java.lang.String) _vb.getValue(getFacesContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the key of the mapLocator
     *
     * @param key The new key of the mapLocator
     */
    public void setKey(String key) {
        this.key = key;
    }

    /**
     * <p>Return the width of the mapLocator
     */
    public String getWidth() {
        if (null != this.width) {
            return this.width;
        }
        ValueBinding _vb = getValueBinding("width");
        if (_vb != null) {
            return (java.lang.String) _vb.getValue(getFacesContext());
        } else {
            return null;
        }
    }
                                                                                                                         
    /**
     * <p>Set the width of the mapLocator
     *
     * @param width The new width of the mapLocator
     */
    public void setWidth(String width) {
        this.width = width;
    }

    public String getFamily() {
        return (COMPONENT_FAMILY);
    }
    
    /**
     * <p>Return the height of the mapLocator
     */
    public String getHeight() {
        if (null != this.height) {
            return this.height;
        }
        ValueBinding _vb = getValueBinding("height");
        if (_vb != null) {
            return (java.lang.String) _vb.getValue(getFacesContext());
        } else {
            return null;
        }
    }
                                                                                                                         
    /**
     * <p>Set the height of the mapLocator
     *
     * @param height The new height of the mapLocator
     */
    public void setHeight(String height) {
        this.height = height;
    }

    /**
     * <p>Returns the <code>location</code> property of the
     * <code>MapLocator</code>.</p>
     */
    public Object getLocation() {
        if (null != this.location) {
            return this.location;
        }
        ValueBinding _vb = getValueBinding("location");
        if (_vb != null) {
            return (_vb.getValue(getFacesContext()));
        } else {
            return null;
        }
    }
                                                                                                                
    /**
     * <p>Sets the <code>location</code> property
     *  of this <code>MapLocator</code>.
     *
     * @param location The new location 
     */
    public void setLocation(Object location) {
        this.location =  location;
    }


    /**
     * <p>Return the style of the mapLocator
     */
    public String getStyle() {
        if (null != this.style) {
            return this.style;
        }
        ValueBinding _vb = getValueBinding("style");
        if (_vb != null) {
            return (java.lang.String) _vb.getValue(getFacesContext());
        } else {
            return null;
        }
    }
                                                                                                                         
    /**
     * <p>Set the style of the mapLocator
     *
     * @param style The new style of the mapLocator
     */
    public void setStyle(String style) {
        this.style = style;
    }


    /**
     * <p>Return the styleClass of the mapLocator
     */
    public String getStyleClass() {
        if (null != this.styleClass) {
            return this.styleClass;
        }
        ValueBinding _vb = getValueBinding("styleClass");
        if (_vb != null) {
            return (java.lang.String) _vb.getValue(getFacesContext());
        } else {
            return null;
        }
    }
                                                                                                                         
    /**
     * <p>Set the styleClass of the mapLocator
     *
     * @param styleClass The new styleClass of the mapLocator
     */
    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }


    // ----------------------------------------------------- StateHolder Methods
    /**
     * <p>Return the state to be saved for this component.
     *
     * @param context <code>FacesContext</code> for the current request
     */
    public Object saveState(FacesContext context) {
        Object values[] = new Object[7];
        values[0] = super.saveState(context);
        values[1] = key;
        values[2] = width;
        values[3] = height;
        values[4] = location;
        values[5] = style;
        values[6] = styleClass;
        return (values);
    }
                                                                                                                         
    /**
     * <p>Restore the state for this component.
     *
     * @param context <code>FacesContext</code> for the current request
     * @param state   State to be restored
     */
    public void restoreState(FacesContext context, Object state) {
        Object values[] = (Object[]) state;
        super.restoreState(context, values[0]);
        key = (String)values[1];
        width = (String)values[2];
        height = (String)values[3];
        location = values[4];
        style = (String)values[5];
        styleClass = (String)values[6];
    }

}
