/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: MapLocatorPhaseListener.java,v 1.3 2006/01/19 20:01:38 craig_mcc Exp $
 */

package com.sun.j2ee.blueprints.ui.maplocator;

import java.io.*;
import java.net.*;
import java.util.*;
import javax.faces.context.*;
import javax.faces.event.*;
import javax.faces.el.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.*;
import javax.faces.context.FacesContext;

public class MapLocatorPhaseListener implements PhaseListener {
    
    private static final String SCRIPT_VIEW_ID = "ajax-maplocator-script.js";
    // For Geocoding service
    private static final String PROXY_HOST = "com.sun.faces.proxyHost";
    private static final String PROXY_PORT = "com.sun.faces.proxyPort";
    private static final String SCRIPT_LOCATION = "META-INF/maplocator/script.js";

    public MapLocatorPhaseListener() {
    }
    
    public void afterPhase(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        String rootId = context.getViewRoot().getViewId();
        if (rootId.endsWith(SCRIPT_VIEW_ID)) {
            handleResourceRequest(event, SCRIPT_LOCATION, "text/javascript");
        } else {
            String locationParam = (String)event.getFacesContext().getExternalContext().
                getRequestParameterMap().get("location");
            if (locationParam != null) {
                handleAjaxRequest(event, locationParam);
            }
        }
    }
     
    /**
     * The URL looks like a request for a resource, such as a JavaScript or CSS file. Write
     * the given resource to the response writer.
     */
    private void handleResourceRequest(PhaseEvent event, String resource, String contentType) {
    
        URL url = (getCurrentLoader(this)).getResource(resource);
        URLConnection conn = null;
        InputStream stream = null;
        BufferedReader bufReader = null;
        HttpServletResponse response =
            (HttpServletResponse)event.getFacesContext().getExternalContext().getResponse();
        OutputStreamWriter outWriter = null;
        String curLine = null;

        try {
            outWriter =
                new OutputStreamWriter(response.getOutputStream(), response.getCharacterEncoding());
            conn = url.openConnection();
            conn.setUseCaches(false);
            stream = conn.getInputStream();
            bufReader = new BufferedReader(new InputStreamReader(stream));
            response.setContentType(contentType);
            response.setStatus(200);

            while (null != (curLine = bufReader.readLine())) {
                outWriter.write(curLine + "\n");
            }

            outWriter.flush();
            outWriter.close();
            event.getFacesContext().responseComplete();
        } catch (Exception e) {
            String message = "Can't load resource:" + url.toExternalForm();
            System.err.println(message);
            e.printStackTrace();
        }
    }

    private void handleAjaxRequest(PhaseEvent event, String locationParam) {
        FacesContext context = event.getFacesContext();
        HttpServletResponse response =
            (HttpServletResponse)context.getExternalContext().getResponse();
        String proxyHost = context.getExternalContext().getInitParameter(PROXY_HOST);
        String proxyPort = context.getExternalContext().getInitParameter(PROXY_PORT);
        
        String result = null;
        try {
            result = GeoCoder.locate(proxyHost, proxyPort, locationParam);
            response.setContentType("text/xml");
            response.setHeader("Cache-Control", "no-cache");
            response.setStatus(200);
            if (result != null) {
                response.getWriter().write(result);
            }
            event.getFacesContext().responseComplete();
        } catch (Exception e) {
            response.setContentType("text/xml");
            response.setHeader("Cache-Control", "no-cache");
            String errorMsg = "<Error>"+e.getMessage()+"</Error>";
            response.setStatus(200);
            try {
                response.getWriter().write(errorMsg);
            } catch (IOException ioe) {
                System.err.println(ioe.getMessage());
                e.printStackTrace();
            }
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }
    
    public void beforePhase(PhaseEvent event) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }
    
    public static ClassLoader getCurrentLoader(Object fallbackClass) {
        ClassLoader loader =
            Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return loader;
    }
}
