/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: MapLocatorRenderer.java,v 1.3 2006/01/19 20:01:38 craig_mcc Exp $
 */

package com.sun.j2ee.blueprints.ui.maplocator;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import javax.faces.webapp.UIComponentTag;

/**
 * <p>This renderer generates HTML and minimal JavaScript for the AJAX 
 * MapLocator component.</p> 
 *
 * @author Roger Kitain 
 */
public class MapLocatorRenderer extends Renderer {

    static int nextId = 0;
    private static final String RENDERED_SCRIPT_KEY = "bpcatalog-ajax-script-maplocator";
    // For Geocoding service
    private static final String PROXY_HOST = "com.sun.faces.proxyHost";
    private static final String PROXY_PORT = "com.sun.faces.proxyPort";

    public MapLocatorRenderer() {
    }

    public void encodeBegin(FacesContext context, UIComponent component)
        throws IOException {
    }

    public void encodeChildren(FacesContext context, UIComponent component) {
    }

    public void encodeEnd(FacesContext context, UIComponent component)
        throws IOException {
        // For Geocoding service..
        String proxyHost = context.getExternalContext().getInitParameter(PROXY_HOST);
        String proxyPort = context.getExternalContext().getInitParameter(PROXY_PORT);

        String clientId = component.getClientId(context);
        MapLocatorComponent mapLocator = (MapLocatorComponent)component;

        ResponseWriter writer = context.getResponseWriter();

        // Start an outer div for the entire comopnent
        writer.startElement("div", component);
        String style = mapLocator.getStyle();
        if (null != style) {
            writer.writeAttribute("style", style, "style");
        }
        String styleClass = mapLocator.getStyleClass();
        if (null != styleClass) {
            writer.writeAttribute("class", styleClass, "styleClass");
        }

        // Render the main JavaScript file for this component once.
        renderScriptOnce(writer, component, context);

        // Render a script element that stores the map component client id,
        // and other control identifiers.
        writer.startElement("script", component);
        writer.writeAttribute("type", "text/javascript", null);
        String idScript = "g_map_id = " + "\"" + clientId + "\";";
        idScript +=  "g_search_id = \"searchId\";";
        idScript +=  "g_message_id = \"msgId\";";
        idScript +=  "g_select_id = \"selectId\";";
        writer.writeText(idScript, null);
        writer.endElement("script");
        writer.write("\n");

        // Render a script element that includes the key for the map service.
        writer.startElement("script", component);
        writer.writeAttribute("type", "text/javascript", null);
        String srcInfo = "http://maps.google.com/maps?file=api&v=1&key=" +
            mapLocator.getKey();
        writer.writeAttribute("src", srcInfo, null);
        writer.endElement("script");
        writer.write("\n");

        // Write out the div that gets replaced by the search conrol
        writer.startElement("div", component);
        writer.writeAttribute("id", "searchId", null);
        writer.endElement("div");
        writer.write("\n");

        // Write out the div that gets replaced by the message area 
        writer.startElement("div", component);
        writer.writeAttribute("id", "msgId", null);
        writer.endElement("div");
        writer.write("\n");

        // Write out the div that gets replaced by the select area 
        writer.startElement("div", component);
        writer.writeAttribute("id", "selectId", null);
        writer.writeAttribute("style", "display:none", null);
        writer.endElement("div");
        writer.write("\n");

        // Write out the div that gets replaced by the map component 
        writer.startElement("div", component);
        writer.writeAttribute("id", clientId, null);
        String styleInfo = "width: " + mapLocator.getWidth() + "px; height: " +
            mapLocator.getHeight() + "px"; 
        writer.writeAttribute("style", styleInfo, null);
        writer.endElement("div");
        writer.write("\n");

        // Get pre-specified locations
        Object location = mapLocator.getLocation();
        String locationStr = null;
        Object locationArray = null;
        String result = null;
        if (location != null) {
            if (location instanceof String) {
                locationStr = (String) location;
                if (locationStr != null) {
                    try {
                        result = GeoCoder.locate(proxyHost, proxyPort, locationStr);
                        writer.startElement("script", component);
                        writer.writeAttribute("type", "text/javascript", null);
                        String initialLocation = "g_initial_location = " + "'" + result + "';";
                        writer.writeText(initialLocation, null);
                        writer.endElement("script");
                        writer.write("\n");
                    } catch (IOException ioe) {
                        writer.startElement("script", component);
                        writer.writeAttribute("type", "text/javascript", null);
                        String msg = "g_message = " + "'" + ioe.getMessage() + "';";
                        writer.writeText(msg, null);
                        writer.endElement("script");
                        writer.write("\n");
                    }
                }
            } if (location instanceof List) {
                locationArray = ((List) location).toArray();
                String currentResult = null;
                for (int i = 0; i < Array.getLength(locationArray); i++) {
                    try {
                        currentResult = GeoCoder.locate(proxyHost, proxyPort, ((String)Array.get(locationArray, i)));
                    } catch (IOException ioe) {
                        writer.startElement("script", component);
                        writer.writeAttribute("type", "text/javascript", null);
                        String msg = "g_message = " + "'" + ioe.getMessage() + "';";
                        writer.writeText(msg, null);
                        writer.endElement("script");
                        writer.write("\n");
                        return;
                    }
                    if (i == 0) {
                        writer.startElement("script", component);
                        writer.writeAttribute("type", "text/javascript", null);
                    }
                    String initialLocations = "g_initial_locations[" + i + "] = " + "'" + currentResult + "';";
                    writer.writeText(initialLocations, null);
                    if (i == Array.getLength(locationArray) - 1) {
                        writer.endElement("script");
                        writer.write("\n");
                    }
                }
            }                
        }
        
        // Close the outer div element
        writer.endElement("div");
        writer.write("\n");

    }

    /** Render the &lt;script&gt; tag which contains supporting JavaScript
     */
    private void renderScriptOnce(ResponseWriter writer, UIComponent component, FacesContext context)
        throws IOException {
        // Store attribute in request map when we've rendered the script such
        // that we only do this once per page
        Map requestMap = context.getExternalContext().getRequestMap();
        Boolean scriptRendered = (Boolean)requestMap.get(RENDERED_SCRIPT_KEY);

        if (scriptRendered == Boolean.TRUE) {
            return;
        }

        requestMap.put(RENDERED_SCRIPT_KEY, Boolean.TRUE);

        // This must be done only once!

        writer.write("\n");
        
        writer.startElement("script", component);
        writer.writeAttribute("type", "text/javascript", null);
        String ssrc = "faces/ajax-maplocator-script.js";
        writer.writeAttribute("src", ssrc, null);
        writer.endElement("script");

        writer.write("\n");

        // Component Page JavaScript
        writer.startElement("body", component);
        writer.writeAttribute("onload","load()", null);
        writer.endElement("body");
        
        writer.write("\n");
                      
        writer.write("\n");
    }
}
