/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: MapLocatorTag.java,v 1.6 2006/01/19 20:01:39 craig_mcc Exp $
 */

package com.sun.j2ee.blueprints.ui.maplocator;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.webapp.UIComponentTag;


/**
 * <p><strong>MapLocatorTag</strong> is the tag handler that processes the 
 * <code>mapLocator</code> custom tag.</p>
 */

public class MapLocatorTag extends UIComponentTag {

    /**
     * <p>The CSS style(s) for this component.
     */
    private String style = null;
    /**
     * <p>Set the CSS style(s) for this component.
     */
    public void setStyle(String style) {
        this.style = style;
    }

    /**
     * <p>The CSS style class(es) for this component.
     */
    private String styleClass = null;
    /**
     * <p>Set the CSS style class(es) for this component.
     */
    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    /**
     * <p>The key used to enable the use of the map api. 
     */
    private String key = null;
    /**
     * <p>Set the key used to enable the use of the map api. 
     */
    public void setKey(String key) {
        this.key = key;
    }

    /**
     * <p>The width of the map 
     */
    private String width = null;
    /**
     * <p>Set the width of the map 
     */
    public void setWidth(String width) {
        this.width = width;
    }

    /**
     * <p>The height of the map 
     */
    private String height = null;
    /**
     * <p>Set the height of the map 
     */
    public void setHeight(String height) {
        this.height = height;
    }

    /**
     * <p>A location on this map 
     */
    private String location = null;
    /**
     * <p>Set the location on this map 
     */
    public void setLocation(String location) {
        this.location = location;
    }

    /**
     * <p>Return the type of the component.
     */
    public String getComponentType() {
        return ("MapLocator");
    }


    /**
     * <p>Return the renderer type (if any)
     */
    public String getRendererType() {
        return ("MapLocator");
    }


    /**
     * <p>Release any resources used by this tag handler
     */
    public void release() {
        super.release();
	key = null;
	width = null;
	height = null;
        location = null;
        style = null;
        styleClass = null;
    }


    /**
     * <p>Set the component properties
     */
    protected void setProperties(UIComponent component) {
        super.setProperties(component);
        MapLocatorComponent mapLocator = (MapLocatorComponent) component;

        if (style != null) {
            if (isValueReference(style)) {
                ValueBinding vb = FacesContext.getCurrentInstance()
                    .getApplication().createValueBinding(style);
                mapLocator.setValueBinding("style", vb);
            } else {
                mapLocator.setKey(style);
            }
        }

        if (styleClass != null) {
            if (isValueReference(styleClass)) {
                ValueBinding vb = FacesContext.getCurrentInstance()
                    .getApplication().createValueBinding(style);
                mapLocator.setValueBinding("styleClass", vb);
            } else {
                mapLocator.setKey(styleClass);
            }
        }

        if (key != null) {
            if (isValueReference(key)) {
                ValueBinding vb = FacesContext.getCurrentInstance()
                    .getApplication().createValueBinding(key);
                mapLocator.setValueBinding("key", vb);
            } else {
                mapLocator.setKey(key);
            }
        }

        if (width != null) {
            if (isValueReference(width)) {
                ValueBinding vb = FacesContext.getCurrentInstance()
                    .getApplication().createValueBinding(width);
                mapLocator.setValueBinding("width", vb);
            } else {
                mapLocator.setWidth(width);
            }
        }
        
        if (height != null) {
            if (isValueReference(height)) {
                ValueBinding vb = FacesContext.getCurrentInstance()
                    .getApplication().createValueBinding(height);
                mapLocator.setValueBinding("height", vb);
            } else {
                mapLocator.setHeight(height);
            }
        }

        if (location != null) {
            if (isValueReference(location)) {
                ValueBinding vb = FacesContext.getCurrentInstance()
                    .getApplication().createValueBinding(location);
                mapLocator.setValueBinding("location", vb);
            } else {
                mapLocator.setLocation(location);
            }
        }

    }
}
