/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: MapComponent.java,v 1.3 2006/01/19 20:01:39 craig_mcc Exp $
 */

package com.sun.j2ee.blueprints.ui.mapviewer;

import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

/**
 * <p>JavaServer Faces component that encapsulates a Google Map.</p>
 */
public class MapComponent extends UIComponentBase {


    // ------------------------------------------------------------ Constructors


    public MapComponent() {
        setRendererType("com.sun.j2ee.blueprints.ui.mapviewer.Map");
    }


    // ------------------------------------------------------ Instance Variables


    private MapPoint center = null;
    private boolean draggingEnabled = true;
    private boolean draggingEnabledSet = false;
    private MapMarker info = null;
    private String key = null;
    private boolean mapControls = false;
    private boolean mapControlsSet = false;
    private MapMarker markers[] = null;
    private String style = null;
    private String styleClass = null;
    private boolean typeControls = false;
    private boolean typeControlsSet = false;
    private int zoomLevel = 4;
    private boolean zoomLevelSet = false;


    // -------------------------------------------------------------- Properties


    public MapPoint getCenter() {
        if (this.center != null) {
            return this.center;
        }
        ValueBinding _vb = getValueBinding("center");
        if (_vb != null) {
            return (MapPoint) _vb.getValue(getFacesContext());
        } else {
            return null;
        }
    }
    public void setCenter(MapPoint center) {
        this.center = center;
    }


    public boolean isDraggingEnabled() {
        if (this.draggingEnabledSet) {
            return this.draggingEnabled;
        }
        ValueBinding _vb = getValueBinding("draggingEnabled");
        if (_vb != null) {
            Object _result = _vb.getValue(getFacesContext());
            if (_result == null) {
                return false;
            } else {
                return ((Boolean) _result).booleanValue();
            }
        }
        return true;
    }
    public void setDraggingEnabled(boolean draggingEnabled) {
        this.draggingEnabled = draggingEnabled;
        this.draggingEnabledSet = true;
    }


    public MapMarker getInfo() {
        if (this.info != null) {
            return this.info;
        }
        ValueBinding _vb = getValueBinding("info");
        if (_vb != null) {
            return (MapMarker) _vb.getValue(getFacesContext());
        } else {
            return null;
        }
    }
    public void setInfo(MapMarker info) {
        this.info = info;
    }


    public String getKey() {
        if (this.key != null) {
            return this.key;
        }
        ValueBinding _vb = getValueBinding("key");
        if (_vb != null) {
            return (String) _vb.getValue(getFacesContext());
        } else {
            return null;
        }
    }
    public void setKey(String key) {
        this.key = key;
    }


    public boolean isMapControls() {
        if (this.mapControlsSet) {
            return this.mapControls;
        }
        ValueBinding _vb = getValueBinding("mapControls");
        if (_vb != null) {
            Object _result = _vb.getValue(getFacesContext());
            if (_result == null) {
                return false;
            } else {
                return ((Boolean) _result).booleanValue();
            }
        }
        return true;
    }
    public void setMapControls(boolean mapControls) {
        this.mapControls = mapControls;
        this.mapControlsSet = true;
    }


    public MapMarker[] getMarkers() {
        if (this.markers != null) {
            return this.markers;
        }
        ValueBinding _vb = getValueBinding("markers");
        if (_vb != null) {
            return (MapMarker[]) _vb.getValue(getFacesContext());
        } else {
            return null;
        }
    }
    public void setMarkers(MapMarker markers[]) {
        this.markers = markers;
    }


    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueBinding _vb = getValueBinding("style");
        if (_vb != null) {
            return (String) _vb.getValue(getFacesContext());
        } else {
            return null;
        }
    }
    public void setStyle(String style) {
        this.style = style;
    }


    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        ValueBinding _vb = getValueBinding("styleClass");
        if (_vb != null) {
            return (String) _vb.getValue(getFacesContext());
        } else {
            return null;
        }
    }
    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }


    public boolean isTypeControls() {
        if (this.typeControlsSet) {
            return this.typeControls;
        }
        ValueBinding _vb = getValueBinding("typeControls");
        if (_vb != null) {
            Object _result = _vb.getValue(getFacesContext());
            if (_result == null) {
                return false;
            } else {
                return ((Boolean) _result).booleanValue();
            }
        }
        return true;
    }
    public void setTypeControls(boolean typeControls) {
        this.typeControls = typeControls;
        this.typeControlsSet = true;
    }


    public int getZoomLevel() {
        if (this.zoomLevelSet) {
            return this.zoomLevel;
        }
        ValueBinding _vb = getValueBinding("zoomLevel");
        if (_vb != null) {
            Object _result = _vb.getValue(getFacesContext());
            if (_result == null) {
                return 0;
            } else {
                return ((Integer) _result).intValue();
            }
        }
        return 0;
    }
    public void setZoomLevel(int zoomLevel) {
        this.zoomLevel = zoomLevel;
        this.zoomLevelSet = true;
    }


    // ----------------------------------------------------- UIComponent Methods


    public String getFamily() {
        return "com.sun.j2ee.blueprints.ui.mapviewer.Map";
    }


    // ---------------------------------------------------------- Public Methods


    // ---------------------------------------------------- StateManager Methods


    public void restoreState(FacesContext context, Object state) {

        Object values[] = (Object[]) state;
        super.restoreState(context, values[0]);
        this.center = (MapPoint) values[1];
        this.draggingEnabled = Boolean.TRUE.equals(values[2]);
        this.draggingEnabledSet = Boolean.TRUE.equals(values[3]);
        this.info = (MapMarker) values[4];
        this.key = (String) values[5];
        this.mapControls = Boolean.TRUE.equals(values[6]);
        this.mapControlsSet = Boolean.TRUE.equals(values[7]);
        this.markers = (MapMarker[]) values[8];
        this.style = (String) values[9];
        this.styleClass = (String) values[10];
        this.typeControls = Boolean.TRUE.equals(values[11]);
        this.typeControlsSet = Boolean.TRUE.equals(values[12]);
        this.zoomLevel = ((Integer) values[13]).intValue();
        this.zoomLevelSet = Boolean.TRUE.equals(values[14]);
    }


    public Object saveState(FacesContext context) {

        Object values[] = new Object[15];
        values[0] = super.saveState(context);
        values[1] = this.center;
        values[2] = this.draggingEnabled ? Boolean.TRUE : Boolean.FALSE;
        values[3] = this.draggingEnabledSet ? Boolean.TRUE : Boolean.FALSE;
        values[4] = this.info;
        values[5] = this.key;
        values[6] = this.mapControls ? Boolean.TRUE : Boolean.FALSE;
        values[7] = this.mapControlsSet ? Boolean.TRUE : Boolean.FALSE;
        values[8] = this.markers;
        values[9] = this.style;
        values[10] = this.styleClass;
        values[11] = this.typeControls ? Boolean.TRUE : Boolean.FALSE;
        values[12] = this.typeControlsSet ? Boolean.TRUE : Boolean.FALSE;
        values[13] = new Integer(this.zoomLevel);
        values[14] = this.zoomLevelSet ? Boolean.TRUE : Boolean.FALSE;
        return values;

    }


}
