/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: MapMarker.java,v 1.4 2006/01/19 20:01:40 craig_mcc Exp $
 */

package com.sun.j2ee.blueprints.ui.mapviewer;

/**
 * <p><code>MapMarker</code> is a {@link MapPoint} that also contains an
 * optional <code>markup</code> property containing the HTML markup to be
 * displayed for this point.</p>
 */
public class MapMarker extends MapPoint {
    

    // ------------------------------------------------------------ Constructors


    /**
     * <p>Construct an unconfigured MapMarker instance.</p>
     */
    public MapMarker() {
        this(0.0, 0.0, null);
    }


    /**
     * <p>Construct a MapMarker configured from the specified point.</p>
     *
     * @param point {@link MapPoint} from which to configure this marker
     */
    public MapMarker(MapPoint point) {
        this(point.getLatitude(), point.getLongitude(), null);
    }


    /**
     * <p>Construct a MapMarker configured from the specified point and
     * HTML markup.</p>
     *
     * @param point {@link MapPoint} from which to configure this marker
     * @param markup Optional HTML markup describing the point referenced
     *  by this marker
     */
    public MapMarker(MapPoint point, String markup) {
        this(point.getLatitude(), point.getLongitude(), markup);
    }


    /**
     * <p>Construct a configured MapMarker instance.</p>
     *
     * @param latitude Latitude of the point referenced by this marker
     * @param longitude Longitude of the point referenced by this marker
     * @param markup Optional HTML markup describing the point referenced
     *  by this marker
     */
    public MapMarker(double latitude, double longitude, String markup) {
        super(latitude, longitude);
        this.markup = markup;
    }


    // ------------------------------------------------------ Instance Variables


    /**
     * <p>The HTML markup (if any) associated with this marker.</p>
     */
    private String markup = null;


    // -------------------------------------------------------------- Properties


    /**
     * <p>Return the optional HTML markup associated with this marker.</p>
     */
    public String getMarkup() {
        return this.markup;
    }


    /**
     * <p>Set the optional HTML markup associated with this marker.</p>
     *
     * @param markup The optional HTML markup, or <code>null</code> if there
     *  is no such markup
     */
    public void setMarkup(String markup) {
        this.markup = markup;
    }


}
