/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: MapPoint.java,v 1.2 2006/01/19 20:01:40 craig_mcc Exp $
 */

package com.sun.j2ee.blueprints.ui.mapviewer;

import java.io.Serializable;

/**
 * <p>Non-visual component that represents an individual geographic point,
 * specified by latitude and longitude properties (measured in degrees).</p>
 */
public class MapPoint implements Serializable {
    

    // ------------------------------------------------------------ Constructors


    /**
     * <p>Construct an unconfigured MapPoint instance.</p>
     */
    public MapPoint() {
        this(0.0, 0.0);
    }


    /**
     * <p>Construct a MapPoint instance for the specified geographical
     * coordinates.</p>
     *
     * @param latitude Latitude (in degrees) for this point
     * @param longitude Longitude (in degrees) for this point
     */
    public MapPoint(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }


    // ------------------------------------------------------ Instance Variables


    /**
     * <p>The geographic latitude (in degrees) of this point.</p>
     */
    private double latitude = 0.0;


    /**
     * <p>The geographic longitude (in degrees) of this point.</p>
     */
    private double longitude = 0.0;


    // -------------------------------------------------------------- Properties


    /**
     * <p>Return the geographic latitude of this point.</p>
     */
    public double getLatitude() {
        return this.latitude;
    }


    /**
     * <p>Set the geographic latitude of this point.</p>
     *
     * @param latitude The new latitude
     */
    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }


    /**
     * <p>Return the geographic longitude of this point.</p>
     */
    public double getLongitude() {
        return this.longitude;
    }


    /**
     * <p>Set the geographic longitude of this point.</p>
     *
     * @param longitude The new latitude
     */
    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }


}
