/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: MapTag.java,v 1.3 2006/01/19 20:01:41 craig_mcc Exp $
 */

package com.sun.j2ee.blueprints.ui.mapviewer;

import com.sun.j2ee.blueprints.ui.util.AbstractUIComponentTag;
import javax.faces.component.UIComponent;
import javax.faces.el.ValueBinding;

/**
 * <p>Custom tag for the {@link MapComponent} component.</p>
 */
public class MapTag extends AbstractUIComponentTag {
    

    // ---------------------------------------------------------- Tag Attributes


    private String center;
    public void setCenter(String center) {
        this.center = center;
    }

    private String draggingEnabled;
    public void setDraggingEnabled(String draggingEnabled) {
        this.draggingEnabled = draggingEnabled;
    }

    private String info;
    public void setInfo(String info) {
        this.info = info;
    }

    private String key;
    public void setKey(String key) {
        this.key = key;
    }
    
    private String mapControls;
    public void setMapControls(String mapControls) {
        this.mapControls = mapControls;
    }

    private String markers;
    public void setMarkers(String markers) {
        this.markers = markers;
    }

    private String style;
    public void setStyle(String style) {
        this.style = style;
    }

    private String styleClass;
    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    private String typeControls;
    public void setTypeControls(String typeControls) {
        this.typeControls = typeControls;
    }

    private String zoomLevel;
    public void setZoomLevel(String zoomLevel) {
        this.zoomLevel = zoomLevel;
    }

    // -------------------------------------------------- UIComponentTag Methods


    /**
     * Gets the type of the component associated wit hthe tag.
     * @return the name of the component type
     */
    public String getComponentType() {
        return "com.sun.j2ee.blueprints.ui.mapviewer.Map";
    }

    /**
     * Gets the type of the renderer that will render this tag.
     * @return the type of the renderer that renders this tag
     */
    public String getRendererType() {
        return "com.sun.j2ee.blueprints.ui.mapviewer.Map";
    }

    /**
     * Releases resources allocated during the execution of this tag handler.
     */
    public void release() {

        super.release();
        this.center = null;
        this.draggingEnabled = null;
        this.info = null;
        this.key = null;
        this.mapControls = null;
        this.markers = null;
        this.style = null;
        this.styleClass = null;
        this.typeControls = null;
        this.zoomLevel = null;

    }

    /**
     * Sets the properties of the specified component.
     * @param component the component associated with this tag
     */
    protected void setProperties(UIComponent component) {

        super.setProperties(component);
        if (center != null) {
            if (isValueReference(center)) {
                ValueBinding vb = getFacesContext().getApplication().
                        createValueBinding(center);
                component.setValueBinding("center", vb);
            } else {
                throw new IllegalArgumentException(center);
            }
        }
        configureBoolean(component, "draggingEnabled", draggingEnabled);
        if (info != null) {
            if (isValueReference(center)) {
                ValueBinding vb = getFacesContext().getApplication().
                        createValueBinding(info);
                component.setValueBinding("info", vb);
            } else {
                throw new IllegalArgumentException(info);
            }
        }
        configureString(component, "key", key);
        configureBoolean(component, "mapControls", mapControls);
        if (markers != null) {
            if (isValueReference(markers)) {
                ValueBinding vb = getFacesContext().getApplication().
                        createValueBinding(markers);
                component.setValueBinding("markers", vb);
            } else {
                throw new IllegalArgumentException(markers);
            }
        }
        configureString(component, "style", style);
        configureString(component, "styleClass", styleClass);
        configureBoolean(component, "typeControls", typeControls);
        configureInteger(component, "zoomLevel", zoomLevel);

    }


}
