/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: SqlUtilDateConverter.java,v 1.2 2006/06/06 20:48:39 edwingo Exp $
 */

package com.sun.j2ee.blueprints.ui.popupcalendar;

import java.text.SimpleDateFormat;
import java.util.Date;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;

public class SqlUtilDateConverter implements Converter {
    /** ISO 8601 date format pattern */
    private static String isoDatePattern = "yyyy-MM-dd";

    /** DateFormat corresponding to ISO pattern */
    private static SimpleDateFormat isoDateFormat = new SimpleDateFormat(
            isoDatePattern);

    public SqlUtilDateConverter() {

    }

    public Object getAsObject(FacesContext context, UIComponent component,
            String value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }

        // If the specified value is null or zero-length, return null
        if (value == null) {
            return (null);
        }
        value = value.trim();
        if (value.length() < 1) {
            return (null);
        }

        try {
            // Normal return value of java.sql.Date which is a java.util.Date
            return java.sql.Date.valueOf(value);
        } catch (IllegalArgumentException e) {
            throw new ConverterException("Error parsing value '" + value + "'",
                    e);
        }
    }

    public String getAsString(FacesContext context, UIComponent component,
            Object value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }

        // If the specified value is null, return a zero-length String
        if (value == null) {
            return "";
        }

        // If the incoming value is still a string, play nice
        // and return the value unmodified
        if (value instanceof String) {
            return (String) value;
        }

        if (value instanceof Date) {
            // Handles both java.sql.Date and java.util.Date
            Date date = (Date) value;
            return isoDateFormat.format(date);
        }
        throw new ConverterException("Unexpected type: "
                + value.getClass().getName());
    }
}
