/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: ProgressBarHandler.java,v 1.7 2006/05/02 11:01:04 mattbohm Exp $
 */

package com.sun.j2ee.blueprints.ui.progressbar;

import org.apache.shale.remoting.faces.ResponseFactory;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import java.io.IOException;
import javax.faces.el.ValueBinding;
import javax.faces.el.MethodBinding;
import javax.servlet.http.HttpServletResponse;
/**
 *
 * @author Matthew Bohm
 */
public class ProgressBarHandler {
    
    /**
     * <p>Factory for response writers that we can use to construct the
     * outgoing response.</p>
     */
    private static ResponseFactory factory = new ResponseFactory();
    
    /**
     * <p>The parameter signature for the start, pause, resume, and stop operations.</p>
     */
    private static Class[] operationArgs = {FacesContext.class};

    
    /**
     * <p>The clientId of the progress bar.</p>
     */
    private String clientId = null;


    /**
     * <p>Return the clientId.</p>
     */
    public String getClientId() {
        return this.clientId;
    }
    
    /**
     * <p>Set the clientId.</p>
     *
     * @param clientId The new clientId
     */
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }
    
    /**
     * <p>The binding expression that was used on the percentage property of the progress bar.</p>
     */
    private String percentageBinding = null;


    /**
     * <p>Return the binding expression that was used on the percentage property of the progress bar.</p>
     */
    public String getPercentageBinding() {
        return this.percentageBinding;
    }

    /**
     * <p>Set the binding expression that was used on the percentage property of the progress bar.</p>
     *
     * @param percentageBinding The new binding expression
     */
    public void setPercentageBinding(String percentageBinding) {
        this.percentageBinding = percentageBinding;
    }
    
    /**
     * <p>The binding expression that was used on the percentageText property of the progress bar.</p>
     */
    private String percentageTextBinding = null;


    /**
     * <p>Return the binding expression that was used on the percentageText property of the progress bar.</p>
     */
    public String getPercentageTextBinding() {
        return this.percentageTextBinding;
    }

    /**
     * <p>Set the binding expression that was used on the percentageText property of the progress bar.</p>
     *
     * @param percentageTextBinding The new binding expression
     */
    public void setPercentageTextBinding(String percentageTextBinding) {
        this.percentageTextBinding = percentageTextBinding;
    }
    
    /**
     * <p>The binding expression that was used on the startOperation property of the progress bar.</p>
     */
    private String startOperationBinding = null;


    /**
     * <p>Return the binding expression that was used on the startOperation property of the progress bar.</p>
     */
    public String getStartOperationBinding() {
        return this.startOperationBinding;
    }

    /**
     * <p>Set the binding expression that was used on the startOperation property of the progress bar.</p>
     *
     * @param startOperationBinding The new binding expression
     */
    public void setStartOperationBinding(String startOperationBinding) {
        this.startOperationBinding = startOperationBinding;
    }
    
    /**
     * <p>The binding expression that was used on the pauseOperation property of the progress bar.</p>
     */
    private String pauseOperationBinding = null;


    /**
     * <p>Return the binding expression that was used on the pauseOperation property of the progress bar.</p>
     */
    public String getPauseOperationBinding() {
        return this.pauseOperationBinding;
    }

    /**
     * <p>Set the binding expression that was used on the pauseOperation property of the progress bar.</p>
     *
     * @param pauseOperationBinding The new binding expression
     */
    public void setPauseOperationBinding(String pauseOperationBinding) {
        this.pauseOperationBinding = pauseOperationBinding;
    }
    
    /**
     * <p>The binding expression that was used on the resumeOperation property of the progress bar.</p>
     */
    private String resumeOperationBinding = null;


    /**
     * <p>Return the binding expression that was used on the resumeOperation property of the progress bar.</p>
     */
    public String getResumeOperationBinding() {
        return this.resumeOperationBinding;
    }

    /**
     * <p>Set the binding expression that was used on the resumeOperation property of the progress bar.</p>
     *
     * @param resumeOperationBinding The new binding expression
     */
    public void setResumeOperationBinding(String resumeOperationBinding) {
        this.resumeOperationBinding = resumeOperationBinding;
    }
    
    /**
     * <p>The binding expression that was used on the stopOperation property of the progress bar.</p>
     */
    private String stopOperationBinding = null;


    /**
     * <p>Return the binding expression that was used on the stopOperation property of the progress bar.</p>
     */
    public String getStopOperationBinding() {
        return this.stopOperationBinding;
    }
    
    /**
     * <p>Set the binding expression that was used on the stopOperation property of the progress bar.</p>
     *
     * @param stopOperationBinding The new binding expression
     */
    public void setStopOperationBinding(String stopOperationBinding) {
        this.stopOperationBinding = stopOperationBinding;
    }
    
    /**
     * <p>The binding expression that was used on the failed property of the progress bar.</p>
     */
    private String failedBinding = null;


    /**
     * <p>Return the binding expression that was used on the failed property of the progress bar.</p>
     */
    public String getFailedBinding() {
        return this.failedBinding;
    }
    
    /**
     * <p>Set the binding expression that was used on the failed property of the progress bar.</p>
     *
     * @param failedBinding The new binding expression
     */
    public void setFailedBinding(String failedBinding) {
        this.failedBinding = failedBinding;
    }
    
    public void writeAjaxResponse() throws IOException {
        FacesContext context = FacesContext.getCurrentInstance();
        //UIComponent viewRoot = context.getViewRoot();
        //ProgressBarComponent comp = (ProgressBarComponent)viewRoot.findComponent(this.clientId);
        //int percentage = comp.getPercentage();
        
        //temp fix until shale-remoting allows the no-cache setting
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        response.setHeader("Pragma", "No-Cache");
        response.setHeader("Cache-Control", "no-cache,no-store,max-age=0");
        response.setDateHeader("Expires", 1); 
        
        if (this.startOperationBinding != null) {
            MethodBinding mb = context.getApplication().
              createMethodBinding(this.startOperationBinding, this.operationArgs);
            mb.invoke(context, new Object[]{context});
        }
        else if (this.pauseOperationBinding != null) {
            MethodBinding mb = context.getApplication().
              createMethodBinding(this.pauseOperationBinding, this.operationArgs);
            mb.invoke(context, new Object[]{context});
        }
        else if (this.resumeOperationBinding != null) {
            MethodBinding mb = context.getApplication().
              createMethodBinding(this.resumeOperationBinding, this.operationArgs);
            mb.invoke(context, new Object[]{context});
        } 
        else if (this.stopOperationBinding != null) {
            MethodBinding mb = context.getApplication().
              createMethodBinding(this.stopOperationBinding, this.operationArgs);
            mb.invoke(context, new Object[]{context});
        } 
        
        int percentage = -1;
        if (this.percentageBinding != null) {
            ValueBinding percentageVb = context.getApplication().createValueBinding(this.percentageBinding);
            Number percentageNumber = (Number)percentageVb.getValue(context);  //let ClassCastException be thrown
            percentage = percentageNumber.intValue();
        }
        
        String percentageText = null;
        if (this.percentageTextBinding != null) {
            ValueBinding percentageTextVb = context.getApplication().createValueBinding(this.percentageTextBinding);
            percentageText = (String)percentageTextVb.getValue(context);  //let ClassCastException be thrown
        }
        
        boolean failed = false;
        if (this.failedBinding != null) {
            ValueBinding failedVb = context.getApplication().createValueBinding(this.failedBinding);
            failed = ((Boolean)failedVb.getValue(context)).booleanValue();  //let ClassCastException be thrown
        }
        
        ResponseWriter writer = factory.getResponseWriter(context, "text/xml");
        // Render the response
        UIComponent comp = null;
        writer.startDocument();
        writer.startElement("message", null);  //NOI18N
        if (this.percentageBinding != null) {
            writer.startElement("percentage", null);  //NOI18N
            writer.writeText(String.valueOf(percentage), null);
            writer.endElement("percentage");  //NOI18N
        }
        if (this.percentageTextBinding != null && percentageText != null) {
            writer.startElement("percentageText", null);  //NOI18N
            writer.writeText(percentageText, null);     //use writeText instead of write because this is within XML
            writer.endElement("percentageText");  //NOI18N
        }
        if (failed) {
            writer.startElement("status", null);  //NOI18N
            writer.writeText("-1", null);     //use writeText instead of write because this is within XML
            writer.endElement("status");  //NOI18N
        }
        writer.startElement("clientId", null);  //NOI18N
        writer.writeText(this.clientId, null);
        writer.endElement("clientId");  //NOI18N
        writer.endElement("message");  //NOI18N
        writer.endDocument();
        writer.flush();
    }
    
}
