/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: ProgressBarRenderer.java,v 1.17 2006/05/02 11:01:04 mattbohm Exp $
 */

package com.sun.j2ee.blueprints.ui.progressbar;


import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

import java.io.IOException;
import java.util.Map;

import com.sun.j2ee.blueprints.ui.util.Util;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.servlet.http.HttpServletResponse;

import com.sun.j2ee.blueprints.ui.util.BaseRenderer;
import java.beans.Beans;
import java.net.URL;
import javax.faces.el.ValueBinding;
import javax.faces.el.MethodBinding;
import org.apache.shale.remoting.XhtmlHelper;
import org.apache.shale.remoting.Mechanism;

/**
 * <p>Render our associated {@link ProgressBarComponent}.
 * </p>
 */

public class ProgressBarRenderer extends BaseRenderer {
    
    
    private boolean logging = false;
    
    /**
     * <p>The static CSS resource for this component.</p>
     */
    private static final String CSS_RESOURCE =
            "/META-INF/progressbar/styles.css"; //NOI18N

    /**
     * <p>The static script resource for this component.</p>
     */
    private static final String SCRIPT_RESOURCE =
            "/META-INF/progressbar/script.js"; //NOI18N
    
    /**
     * <p>Request attribute to flag whether the rendering of once-only output has been performed.</p>
     */
    private static final String RENDER_ONCE = "com.sun.j2ee.blueprints.ui.progressbar.RENDER_ONCE"; //NOI18N
    
    /**
     * <p>Resource identifier for our AJAX response handler.</p>
     */
    private static final String RESPONSE_HANDLER =
            "/bpui_progressbar_handler/writeAjaxResponse"; //NOI18N
    
    public void decode(FacesContext context, UIComponent component) {
        getButtonRenderer(context).decode(context, component);
    }
    
    /**
     * <p>Stateless helper bean to manufacture resource linkages.</p>
     */
    private static XhtmlHelper helper = new XhtmlHelper();    
    
    public void encodeBegin(FacesContext context, UIComponent component)
    throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = component.getClientId(context);
        
        //interval, style and styleClass attributes
        int interval = 1500, percentage = 0, indeterminateSection = 0, indeterminateInterval = 0, indeterminateIncrement = 0;
        String style = null, styleClass = null, percentageText = null, onComplete = null, onFail = null, onUpdate = null, onPoll = null;
        ValueBinding percentageVb = null, percentageTextVb = null;
        Boolean autoStart = null;
        if (Beans.isDesignTime()) {
            //initialize to 67 for designtime
            percentage = 67;
        }
        
        ProgressBarComponent pbComponent = null;
        if (component instanceof ProgressBarComponent) {
            pbComponent = (ProgressBarComponent)component;
            style = pbComponent.getStyle();
            styleClass = pbComponent.getStyleClass();
            onComplete = pbComponent.getOnComplete();
            onFail = pbComponent.getOnFail();
            onUpdate = pbComponent.getOnUpdate();
            onPoll = pbComponent.getOnPoll();
            autoStart = Boolean.valueOf(pbComponent.isAutoStart());
            indeterminateSection = pbComponent.getIndeterminateSection();
            indeterminateInterval = pbComponent.getIndeterminateInterval();
            indeterminateIncrement = pbComponent.getIndeterminateIncrement();
            interval = pbComponent.getInterval();
            if (interval < 0) {
                interval = 0;
            }
            percentageVb = pbComponent.getValueBinding("percentage"); //NOI18N
            //for designtime:
            //if there is a value binding, let percentageText remain as initialized
            //if there is no value binding, let percentage equal the component's percentage
            //for runtime: let percentage equal the component's percentage
            if (!Beans.isDesignTime() || percentageVb == null) {
                percentage = pbComponent.getPercentage();
            }
            
            //initialize percentageText
            String defaultPercentageText = String.valueOf(percentage) + "%";  //NOI18N
            percentageText = defaultPercentageText;
            percentageTextVb = pbComponent.getValueBinding("percentageText"); //NOI18N
            //for designtime:
            //if there is a value binding, let percentageText remain as initialized
            //if there is no value binding, let percentageText equal the component's percentageText
            //for runtime:
            //if there is a value binding, let percentageText equal the component's percentageText
            //if there is no value binding, let percentageText remain as initialized
            if ( (Beans.isDesignTime() && percentageTextVb == null) || (!Beans.isDesignTime() && percentageTextVb != null) ) {
                percentageText = pbComponent.getPercentageText();
            }
            //null and empty string checking for percentageText
            if (Beans.isDesignTime()) {
                if (percentageText == null || percentageText.length() < 1) {
                    percentageText = defaultPercentageText;
                }
            }
            else {
                if (percentageText == null) {
                    percentageText = ""; //NOI18N
                }
            }
        } else {
            System.err.println("ProgressBarRenderer.encodeBegin: expected type " + ProgressBarComponent.class + " but found " + component.getClass());  //NOI18N
            System.err.println("ProgressBarRenderer.encodeBegin: class loader hierarchy, starting with ProgressBarComponent.class.getClassLoader():");  //NOI18N
            ClassLoader cl = ProgressBarComponent.class.getClassLoader();
            while(cl != null) {
                System.err.println(cl);
                cl = cl.getParent();
            }
            System.err.println();
            System.err.println("ProgressBarRenderer.encodeBegin: class loader hierarchy, starting with component.getClass().getClassLoader():");  //NOI18N
            cl = component.getClass().getClassLoader();
            while(cl != null) {
                System.err.println(cl);
                cl = cl.getParent();
            }
            System.err.println();
        }
        
        //render resources
        if(Beans.isDesignTime()) {
            // Retrieve our stylesheet
            URL cssURL = component.getClass().getResource(CSS_RESOURCE);
            writer.startElement("link", component); //NOI18N
            writer.writeAttribute("type", "text/css", null); //NOI18N
            writer.writeAttribute("rel", "stylesheet", null); //NOI18N
            writer.writeURIAttribute("href", cssURL, null); //NOI18N
            writer.endElement("link"); //NOI18N
        }
        else {
            helper.linkStylesheet(context, component, writer,
                                  Mechanism.CLASS_RESOURCE,
                                  CSS_RESOURCE);
            helper.linkJavascript(context, component, writer,
                                  Mechanism.CLASS_RESOURCE,
                                  Util.UI_COMMON_SCRIPT_RESOURCE);
            Util.renderDojoLoading(context, component, writer);
            helper.linkJavascript(context, component, writer,
                                  Mechanism.CLASS_RESOURCE,
                                  SCRIPT_RESOURCE);
        }
        
        //render the outer div, both for designtime and runtime
        writer.startElement("div", component);  //NOI18N
        writer.writeAttribute("id", clientId, null);  //NOI18N
        if (style != null) {
            writer.writeAttribute("style", style, "style");  //NOI18N
        }
        if (styleClass != null) {
            writer.writeAttribute("class", styleClass, "styleClass");  //NOI18N
        }
        writer.write("\n");  //NOI18N
        
        //write out bar table
        writer.startElement("table", component);  //NOI18N
        writer.writeAttribute("id", clientId + "_barAreaContainer", null);  //NOI18N
        writer.writeAttribute("class", "bpui_progressbar_barAreaContainer", null);  //NOI18N
        writer.writeAttribute("border", "0", null);  //NOI18N
        writer.writeAttribute("cellspacing", "0", null);  //NOI18N
        writer.writeAttribute("cellpadding", "0", null);  //NOI18N
        writer.writeAttribute("width", "100%", null);  //NOI18N
        writer.write("\n");  //NOI18N
        
        //write out bar row
        writer.startElement("tr", null);  //NOI18N
        writer.writeAttribute("id", clientId + "_barArea", null);  //NOI18N
        writer.writeAttribute("class", "bpui_progressbar_barArea", null);  //NOI18N
        writer.write("\n");  //NOI18N
        int sanePercentage = percentage;
        if (percentage > 100) {
            sanePercentage = 100;
        }
        if (percentage < 0) {
            sanePercentage = 0;
        }
        String portionCompleteStyleClass = "bpui_progressbar_portionComplete";  //NOI18N
        String portionRemainingStyleClass = "bpui_progressbar_portionRemaining";  //NOI18N
        //work around designer issue
        if (Beans.isDesignTime()) {
            if (sanePercentage == 0) {
                portionCompleteStyleClass = "bpui_progressbar_portionRemaining";  //NOI18N
            }
            if (sanePercentage == 100) {
                portionRemainingStyleClass = "bpui_progressbar_portionComplete";  //NOI18N
            }
        }
        writer.startElement("td", null);  //NOI18N
        writer.writeAttribute("id", clientId + "_portionIndeterminate", null);  //NOI18N
        writer.writeAttribute("class", portionRemainingStyleClass, null);  //NOI18N
        writer.writeAttribute("width", "0%", null);  //NOI18N
        writer.endElement("td");  //NOI18N
        writer.write("\n");  //NOI18N
        writer.startElement("td", null);  //NOI18N
        writer.writeAttribute("id", clientId + "_portionComplete", null);  //NOI18N
        writer.writeAttribute("class", portionCompleteStyleClass, null);  //NOI18N
        writer.writeAttribute("width", String.valueOf(sanePercentage) + "%", null);  //NOI18N
        writer.endElement("td");  //NOI18N
        writer.write("\n");  //NOI18N
        writer.startElement("td", null);  //NOI18N
        writer.writeAttribute("id", clientId + "_portionRemaining", null);  //NOI18N
        writer.writeAttribute("class", portionRemainingStyleClass, null);  //NOI18N
        writer.writeAttribute("width", String.valueOf(100 - sanePercentage) + "%", null);  //NOI18N
        writer.endElement("td");  //NOI18N
        writer.write("\n");  //NOI18N
        writer.endElement("tr");  //NOI18N
        writer.write("\n");  //NOI18N
        
        //end bar table
        writer.endElement("table");  //NOI18N
        writer.write("\n");  //NOI18N
        
        //write out percentText div
        writer.startElement("div", null); //NOI18N
        writer.writeAttribute("id", clientId + "_percentageText", null);  //NOI18N
        writer.writeAttribute("class", "bpui_progressbar_percentageText", null);  //NOI18N
        writer.write(percentageText);   //use write instead of writeText so that appdeveloper can include markup
        
        //end percentageText div
        writer.endElement("div"); //NOI18N
        writer.write("\n");  //NOI18N
        
        //end outer div
        writer.endElement("div");  //NOI18N
        writer.write("\n");  //NOI18N
        
        if (!Beans.isDesignTime()) {
            //write out a script element
            writer.startElement("script", component);  //NOI18N
            writer.writeAttribute("type", "text/javascript", null);  //NOI18N
            writer.write("\n");  //NOI18N
            
            if (!context.getExternalContext().getRequestMap().containsKey(RENDER_ONCE)) {
                context.getExternalContext().getRequestMap().put(RENDER_ONCE, Boolean.TRUE);
                //get the url that will be used to make ajax requests
                String callback = helper.mapResourceId(context,
                                                       Mechanism.DYNAMIC_RESOURCE,
                                                       RESPONSE_HANDLER);
                writer.write("bpui.progressbar.unparameterizedUrl = \"" + //NOI18N
                    callback + "\";"); //NOI18N
                writer.write("\n");  //NOI18N
                writer.write("bpui.progressbar.messages[\"bindError\"] = \"" +  //NOI18N
                             Util.getMessage("progressbar.bindError") + "\";");  //NOI18N
                writer.write("\n");  //NOI18N
                writer.write("bpui.progressbar.messages[\"unboundPercentage\"] = \"" +  //NOI18N
                             Util.getMessage("progressbar.unboundPercentage") + "\";");  //NOI18N
                writer.write("\n");  //NOI18N
            }
            
            //get the percentageBinding param we will pass into the 
            //JavaScript bpui_progressbar_ProgressBar constructor
            String percentageBindingParam = "null";  //NOI18N
            if (percentageVb != null) {
                String percentageBinding = percentageVb.getExpressionString();
                if (percentageBinding != null && percentageBinding.length() > 0) {
                    percentageBindingParam = "\"" + percentageBinding + "\""; //NOI18N
                }
            }

            writer.write("new bpui.progressbar.Instance(\"" + clientId + //NOI18N
                    "\", " + interval +  //NOI18N
                    ", " + percentage +  //NOI18N
                    ", " + percentageBindingParam + ");"); //NOI18N;
            writer.write("\n");  //NOI18N
            
            if (onComplete != null && onComplete.length() > 0) {
                    writer.write("bpui.progressbar.state[\""); //NOI18N
                    writer.write(clientId);
                    writer.write("\"].onComplete = "); //NOI18N
                    writer.writeText(onComplete, "onComplete"); //NOI18N
                    writer.write("\n");   //NOI18N
            }
            
            if (onFail != null && onFail.length() > 0) {
                    writer.write("bpui.progressbar.state[\""); //NOI18N
                    writer.write(clientId);
                    writer.write("\"].onFail = "); //NOI18N
                    writer.writeText(onFail, "onFail"); //NOI18N
                    writer.write("\n");   //NOI18N
            }
            
            if (onUpdate != null && onUpdate.length() > 0) {
                    writer.write("bpui.progressbar.state[\""); //NOI18N
                    writer.write(clientId);
                    writer.write("\"].onUpdate = "); //NOI18N
                    writer.writeText(onUpdate, "onUpdate"); //NOI18N
                    writer.write("\n");   //NOI18N
            }
            
            if (onPoll != null && onPoll.length() > 0) {
                    writer.write("bpui.progressbar.state[\""); //NOI18N
                    writer.write(clientId);
                    writer.write("\"].onPoll = "); //NOI18N
                    writer.writeText(onPoll, "onPoll"); //NOI18N
                    writer.write("\n");   //NOI18N
            }
            
            if (Boolean.TRUE.equals(autoStart)) {
                    writer.write("bpui.progressbar.state[\""); //NOI18N
                    writer.write(clientId);
                    writer.write("\"].autoStart = "); //NOI18N
                    writer.writeText(autoStart.toString(), "autoStart"); //NOI18N
                    writer.write("\n");   //NOI18N
            }
            
            if (indeterminateSection != ProgressBarComponent.INDETERMINATE_SECTION_DEFAULT) {
                    writer.write("bpui.progressbar.state[\""); //NOI18N
                    writer.write(clientId);
                    writer.write("\"].indeterminateSection = "); //NOI18N
                    writer.writeText(String.valueOf(indeterminateSection), "indeterminateSection"); //NOI18N
                    writer.write("\n");   //NOI18N
            }
            
            if (indeterminateInterval != ProgressBarComponent.INDETERMINATE_INTERVAL_DEFAULT) {
                    writer.write("bpui.progressbar.state[\""); //NOI18N
                    writer.write(clientId);
                    writer.write("\"].indeterminateInterval = "); //NOI18N
                    writer.writeText(String.valueOf(indeterminateInterval), "indeterminateInterval"); //NOI18N
                    writer.write("\n");   //NOI18N
            }
            
            if (indeterminateIncrement != ProgressBarComponent.INDETERMINATE_INCREMENT_DEFAULT) {
                    writer.write("bpui.progressbar.state[\""); //NOI18N
                    writer.write(clientId);
                    writer.write("\"].indeterminateIncrement = "); //NOI18N
                    writer.writeText(String.valueOf(indeterminateIncrement), "indeterminateIncrement"); //NOI18N
                    writer.write("\n");   //NOI18N
            }
            
            //other bindings
            String[] otherBindings = {"percentageText", "startOperation", "pauseOperation", "resumeOperation", "stopOperation", "failed"};
            boolean[] whichAreMethodBindings = {false, true, true, true, true, false};
            for (int i = 0; pbComponent != null && i < otherBindings.length; i++) {
                String expressionString = null;
                if (whichAreMethodBindings[i]) {    //otherBindings[i] is a MethodBinding
                    Map attributes = pbComponent.getAttributes();
                    Object propValue = attributes.get(otherBindings[i]);
                    if (propValue instanceof MethodBinding) {
                        MethodBinding mb = (MethodBinding)propValue;
                        expressionString = mb.getExpressionString();
                    }
                }
                else {  //otherBindings[i] may be a ValueBinding
                    ValueBinding binding = pbComponent.getValueBinding(otherBindings[i]);
                    if (binding != null) {
                        expressionString = binding.getExpressionString();
                    }
                }
                if (expressionString != null) {
                    writer.write("bpui.progressbar.state[\""); //NOI18N
                    writer.write(clientId);
                    writer.write("\"].bindings[\""); //NOI18N
                    writer.write(otherBindings[i]);
                    writer.write("\"] = \""); //NOI18N
                    writer.writeText(expressionString, null);
                    writer.write("\";\n");   //NOI18N
                }
            }

            writer.endElement("script");  //NOI18N
            writer.write("\n");  //NOI18N
        }
    }
    
    
    public void encodeChildren(FacesContext context, UIComponent component)
    throws IOException {
        
        if (logging) {
            log("encodeChildren(" + component.getId() + ")");  //NOI18N
        }
        
    }
    
    
    public void encodeEnd(FacesContext context, UIComponent component)
    throws IOException {
        
        if (logging) {
            log("encodeEnd(" + component.getId() + ")");  //NOI18N
        }
        
    }
    
    private void log(String message) {
        if (logging) {
            System.out.println(message);
        }
    }
    
    private Renderer commandButtonRenderer = null;
    
    public Renderer getButtonRenderer(FacesContext context) {
        if (null != commandButtonRenderer) {
            return commandButtonRenderer;
        }
        
        RenderKitFactory fact = (RenderKitFactory)
        FactoryFinder.getFactory(FactoryFinder.RENDER_KIT_FACTORY);
        RenderKit basic = fact.getRenderKit(context,
                RenderKitFactory.HTML_BASIC_RENDER_KIT);
        commandButtonRenderer = basic.getRenderer("javax.faces.Command",  //NOI18N
                "javax.faces.Button");  //NOI18N
        return commandButtonRenderer;
        
    }
    
    
    
}
