/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: ProgressBarTag.java,v 1.11 2006/05/02 11:01:05 mattbohm Exp $
 */

package com.sun.j2ee.blueprints.ui.progressbar;

import com.sun.j2ee.blueprints.ui.util.Util;
import com.sun.j2ee.blueprints.ui.util.AbstractActionSourceUIComponentTag;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

import javax.faces.el.ValueBinding;
import javax.faces.el.MethodBinding;
import javax.faces.webapp.UIComponentTag;


/**
 * <p><strong>ProgressBarTag</strong> is the tag handler that processes the
 * <code>progressbar</code> custom tag.</p>
 */

public class ProgressBarTag extends AbstractActionSourceUIComponentTag {
    
    /**
     * <p>Return the type of the component.
     */
    public String getComponentType() {
        return ("com.sun.j2ee.blueprints.ui.progressbar.ProgressBar"); //NOI18N
    }
    
    
    /**
     * <p>Return the renderer type (if any)
     */
    public String getRendererType() {
        return ("com.sun.j2ee.blueprints.ui.progressbar.ProgressBar"); //NOI18N
    }
    
    /**
     * <p>Release any resources used by this tag handler
     */
    public void release() {
        super.release();
        this.interval = null;
        this.percentage = null;
        this.percentageText = null;
        this.startOperation = null;
        this.pauseOperation = null;
        this.resumeOperation = null;
        this.stopOperation = null;
        this.onComplete = null;
        this.onFail = null;
        this.onUpdate = null;
        this.onPoll = null;
        this.autoStart = null;
    }
    
    /**
     * <p>Set the component properties
     */
    protected void setProperties(UIComponent component) {
        super.setProperties(component);
        ProgressBarComponent progressBar = (ProgressBarComponent) component;

        configureInteger(component, "interval", interval); //NOI18N
        configureInteger(component, "percentage", percentage);  //NOI18N
        configureString(component, "percentageText", percentageText); //NOI18N
        
        if (startOperation != null) {
            if (isValueReference(startOperation)) {
                MethodBinding mb = getFacesContext().getApplication().
                        createMethodBinding(startOperation, operationArgs);
                progressBar.setStartOperation(mb);
            } else {
                throw new IllegalArgumentException(startOperation);
            }
        }
        
        if (pauseOperation != null) {
            if (isValueReference(pauseOperation)) {
                MethodBinding mb = getFacesContext().getApplication().
                        createMethodBinding(pauseOperation, operationArgs);
                progressBar.setPauseOperation(mb);
            } else {
                throw new IllegalArgumentException(pauseOperation);
            }
        }
        
        if (resumeOperation != null) {
            if (isValueReference(resumeOperation)) {
                MethodBinding mb = getFacesContext().getApplication().
                        createMethodBinding(resumeOperation, operationArgs);
                progressBar.setResumeOperation(mb);
            } else {
                throw new IllegalArgumentException(resumeOperation);
            }
        }
        
        if (stopOperation != null) {
            if (isValueReference(stopOperation)) {
                MethodBinding mb = getFacesContext().getApplication().
                        createMethodBinding(stopOperation, operationArgs);
                progressBar.setStopOperation(mb);
            } else {
                throw new IllegalArgumentException(stopOperation);
            }
        }
        
        configureString(component, "onComplete", onComplete);
        configureString(component, "onFail", onFail);
        configureString(component, "onUpdate", onUpdate);
        configureString(component, "onPoll", onPoll);
        configureBoolean(component, "autoStart", autoStart);
        configureBoolean(component, "failed", failed);
        configureInteger(component, "indeterminateSection", indeterminateSection); //NOI18N
        configureInteger(component, "indeterminateInterval", indeterminateInterval); //NOI18N
        configureInteger(component, "indeterminateIncrement", indeterminateIncrement); //NOI18N
    }
    
    //interval
    private String interval;
    public void setInterval(String newInterval) {
        interval = newInterval;
    }
    
    //percentage
    private String percentage;
    public void setPercentage(String percentage) {
        this.percentage = percentage;
    }
    
    //percentageText
    private String percentageText;
    public void setPercentageText(String percentageText) {
        this.percentageText = percentageText;
    }
    
    //startOperation
    private String startOperation;
    public void setStartOperation(String startOperation) {
        this.startOperation = startOperation;
    }
    
    //pauseOperation
    private String pauseOperation;
    public void setPauseOperation(String pauseOperation) {
        this.pauseOperation = pauseOperation;
    }
    
    //resumeOperation
    private String resumeOperation;
    public void setResumeOperation(String resumeOperation) {
        this.resumeOperation = resumeOperation;
    }
    
    //stopOperation
    private String stopOperation;
    public void setStopOperation(String stopOperation) {
        this.stopOperation = stopOperation;
    }
    
    //onComplete
    private String onComplete;
    public void setOnComplete(String onComplete) {
        this.onComplete = onComplete;
    }
    
    //onFail
    private String onFail;
    public void setOnFail(String onFail) {
        this.onFail = onFail;
    }
    
    //onUpdate
    private String onUpdate;
    public void setOnUpdate(String onUpdate) {
        this.onUpdate = onUpdate;
    }
    
    //onPoll
    private String onPoll;
    public void setOnPoll(String onPoll) {
        this.onPoll = onPoll;
    }
    
    //autoStart
    private String autoStart;
    public void setAutoStart(String autoStart) {
        this.autoStart = autoStart;
    }
    
    //failed
    private String failed;
    public void setFailed(String failed) {
        this.failed = failed;
    }
    
    //indeterminateSection
    private String indeterminateSection;
    public void setIndeterminateSection(String indeterminateSection) {
        this.indeterminateSection = indeterminateSection;
    }
    
    //indeterminateInterval
    private String indeterminateInterval;
    public void setIndeterminateInterval(String indeterminateInterval) {
        this.indeterminateInterval = indeterminateInterval;
    }
    
    //indeterminateIncrement
    private String indeterminateIncrement;
    public void setIndeterminateIncrement(String indeterminateIncrement) {
        this.indeterminateIncrement = indeterminateIncrement;
    }
    
    /**
     * <p>The parameter signature for the start, pause, resume, and stop operations.</p>
     */
    private static Class[] operationArgs = {FacesContext.class};
}
