/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: RatingComponent.java,v 1.5 2006/04/01 10:00:35 mattbohm Exp $
 */

package com.sun.j2ee.blueprints.ui.rating;

import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.el.MethodBinding;

/**
 * <p>Component that displays the rating ("grade") for an item.</p>
 **/
public class RatingComponent extends UIComponentBase {
    
    /**
     * <p>The standard component family for this component.</p>
     */
    public static final String COMPONENT_FAMILY = "com.sun.j2ee.blueprints.ui.rating.Rating";  //NOI18N
    
    /**
     * <p>The standard renderer type for this component.</p>
     */
    public static final String RENDERER_TYPE = "com.sun.j2ee.blueprints.ui.rating.Rating";  //NOI18N
    
    /**
     * <p>A "not interested" grade.</p>
     */
    public static final int NOT_INTERESTED_GRADE = -1;
    
    /**
     * <p>A "clear" grade.</p>
     */
    public static final int CLEAR_GRADE = 0;
    
    
    // --------------------------------------------------------------Constructors
    
    public RatingComponent() {
        super();
        setRendererType(RENDERER_TYPE);
    }
    
    
    // -------------------------------------------------------------- Properties
    
    /**
     * <p>Return the component family for this component.</p>
     */
    public String getFamily() {
        return (COMPONENT_FAMILY);
    }
    
    /**
     * <p>Return the <code>ValueBinding</code> stored for the
     * specified name (if any), respecting any property aliases.</p>
     *
     * @param name Name of value binding to retrieve
     */
    public ValueBinding getValueBinding(String name) {
        return super.getValueBinding(name);
    }
    
    /**
     * <p>Set the <code>ValueBinding</code> stored for the
     * specified name (if any), respecting any property
     * aliases.</p>
     *
     * @param name Name of value binding to set
     * @param binding ValueBinding to set, or null to remove
     */
    public void setValueBinding(String name,ValueBinding binding) {
        super.setValueBinding(name, binding);
    }
    
    
    private int maxGrade = 5;
    
    /*
     * <p>Get the maximum grade (number of "stars") this rating instance
     allows.</p>
     **/
    public int getMaxGrade() {
        ValueBinding vb = getValueBinding("maxGrade"); //NOI18N
        if (vb != null) {
            Integer value = (Integer)vb.getValue(getFacesContext());
            if (value != null) {
                return value.intValue();
            }
        }
        return maxGrade;
    }
    
    /*
     * <p>Set the maximum grade (number of "stars") this rating instance
     allows.</p>
     **/
    public void setMaxGrade(int maxGrade) {
        this.maxGrade = maxGrade;
    }
    
    private int grade = 1;
    
    /*
     * <p>Get the grade (number of "stars") the user has assigned the
     item. Use <code>RatingComponent.NOT_INTERESTED_GRADE</code> for
     "not interested" and <code>RatingComponent.CLEAR_GRADE</code> for
     a "clear" grade. This property must be bound. This property is sent to
     the server via AJAX.
     </p>
     **/
    public int getGrade() {
        ValueBinding vb = getValueBinding("grade"); //NOI18N
        if (vb != null) {
            Integer value = (Integer)vb.getValue(getFacesContext());
            if (value != null) {
                return value.intValue();
            }
        }
        return grade;
    }
    
    /*
     * <p>Set the grade (number of "stars") the user has assigned the
     item. Use <code>RatingComponent.NOT_INTERESTED_GRADE</code> for
     "not interested" and <code>RatingComponent.CLEAR_GRADE</code> for
     a "clear" grade. This property must be bound. This property is sent to
     the server via AJAX.
     </p>
     **/
    public void setGrade(int grade) {
        this.grade = grade;      
    }
    
    private double averageGrade = 0.5;
    
    /*
     * <p>Get the average grade the general user population has assigned 
     to the item. Must be between <code>0.0</code> and maxGrade.
     This property must be bound. This property is sent to the client via
     AJAX.</p>
     **/
    public double getAverageGrade() {
        ValueBinding vb = getValueBinding("averageGrade"); //NOI18N
        if (vb != null) {
            Double value = (Double)vb.getValue(getFacesContext());
            if (value != null) {
                return value.doubleValue();
            }
        }
        return averageGrade;
    }
    
    /*
     * <p>Set the average grade the general user population has assigned 
     to the item. Must be between <code>0.0</code> and maxGrade.
     This property must be bound. This property is sent to the client via
     AJAX.</p>
     **/
    public void setAverageGrade(double averageGrade) {
        this.averageGrade = averageGrade;
    }
    
    private boolean inAverageMode;
    
    /*
     * <p>Get whether the component will be initially rendered displaying 
     the average grade. If <code>false</code>, then the component will be
     initially rendered displaying the user's grade (normal mode).</p>
     **/
    public boolean isInAverageMode() {
        ValueBinding vb = getValueBinding("inAverageMode"); //NOI18N
        if (vb != null) {
            Boolean value = (Boolean)vb.getValue(getFacesContext());
            if (value != null) {
                return value.booleanValue();
            }
        }
        return inAverageMode;
    }
    
    /*
     * <p>Set whether the component will be initially rendered displaying 
     the average grade. If <code>false</code>, then the component will be
     initially rendered displaying the user's grade (normal mode).</p>
     **/
    public void setInAverageMode(boolean inAverageMode) {
        this.inAverageMode = inAverageMode;
    }
    
    private boolean includeNotInterested;
    
    /*
     * <p>Get whether a "not interested" control should be rendered.</p>
     **/
    public boolean isIncludeNotInterested() {
        ValueBinding vb = getValueBinding("includeNotInterested"); //NOI18N
        if (vb != null) {
            Boolean value = (Boolean)vb.getValue(getFacesContext());
            if (value != null) {
                return value.booleanValue();
            }
        }
        return includeNotInterested;
    }
    
    /*
     * <p>Set whether a "not interested" control should be rendered.</p>
     **/
    public void setIncludeNotInterested(boolean includeNotInterested) {
        this.includeNotInterested = includeNotInterested;
    }
    
    private boolean includeClear;
    
    /*
     * <p>Get whether a control to clear the user's rating should be 
     rendered.</p>
     **/
    public boolean isIncludeClear() {
        ValueBinding vb = getValueBinding("includeClear"); //NOI18N
        if (vb != null) {
            Boolean value = (Boolean)vb.getValue(getFacesContext());
            if (value != null) {
                return value.booleanValue();
            }
        }
        return includeClear;
    }
    
    /*
     * <p>Set whether a control to clear the user's rating should be 
     rendered.</p>
     **/
    public void setIncludeClear(boolean includeClear) {
        this.includeClear = includeClear;
    }
    
    private boolean includeModeToggle;
    
    /*
     * <p>Get whether a control to toggle the mode (to show the average
     rating or the user's rating) should be rendered.</p>
     **/
    public boolean isIncludeModeToggle() {
        ValueBinding vb = getValueBinding("includeModeToggle"); //NOI18N
        if (vb != null) {
            Boolean value = (Boolean)vb.getValue(getFacesContext());
            if (value != null) {
                return value.booleanValue();
            }
        }
        return includeModeToggle;
    }
    
    /*
     * <p>Set whether a control to toggle the mode (to show the average
     rating or the user's rating) should be rendered.</p>
     **/
    public void setIncludeModeToggle(boolean includeModeToggle) {
        this.includeModeToggle = includeModeToggle;
    }
    
    private boolean includeText = true;
    
    /*
     * <p>Get whether an area for text should be rendered.</p>
     **/
    public boolean isIncludeText() {
        ValueBinding vb = getValueBinding("includeText"); //NOI18N
        if (vb != null) {
            Boolean value = (Boolean)vb.getValue(getFacesContext());
            if (value != null) {
                return value.booleanValue();
            }
        }
        return includeText;
    }
    
    /*
     * <p>Set whether an area for text should be rendered.</p>
     **/
    public void setIncludeText(boolean includeText) {
        this.includeText = includeText;
    }
    
    private String[] hoverTexts;
    
    /*
     * <p>Get an array of custom hover texts that will be used for the
     "star" controls. If <code>null</code> is specified as a member of
     the array, the default hover text will be used for that "star."</p>
     **/
    public String[] getHoverTexts() {
        ValueBinding vb = getValueBinding("hoverTexts"); //NOI18N
        if (vb != null) {
            return (String[])vb.getValue(getFacesContext());
        }
        return hoverTexts;
    }
    
    /*
     * <p>Set an array of custom hover texts that will be used for the
     "star" controls. If <code>null</code> is specified as a member of
     the array, the default hover text will be used for that "star."</p>
     **/
    public void setHoverTexts(String[] hoverTexts) {
        this.hoverTexts = hoverTexts;
    }
    
    private String notInterestedHoverText;
    
    /*
     * <p>Get a custom hover text that will be used for the "not 
     interested" control.</p>
     **/
    public String getNotInterestedHoverText() {
        ValueBinding vb = getValueBinding("notInterestedHoverText"); //NOI18N
        if (vb != null) {
            return (String)vb.getValue(getFacesContext());
        }
        return notInterestedHoverText;
    }
    
    /*
     * <p>Set a custom hover text that will be used for the "not 
     interested" control.</p>
     **/
    public void setNotInterestedHoverText(String notInterestedHoverText) {
        this.notInterestedHoverText = notInterestedHoverText;
    }
    
    private String clearHoverText;
    
    /*
     * <p>Get a custom hover text that will be used for the "clear"
     control.</p>
     **/
    public String getClearHoverText() {
        ValueBinding vb = getValueBinding("clearHoverText"); //NOI18N
        if (vb != null) {
            return (String)vb.getValue(getFacesContext());
        }
        return clearHoverText;
    }
    
    /*
     * <p>Set a custom hover text that will be used for the "clear"
     control.</p>
     **/
    public void setClearHoverText(String clearHoverText) {
        this.clearHoverText = clearHoverText;
    }
    
    private String normalModeHoverText;
    
    /*
     * <p>Get a custom hover text that will be used for the mode 
     toggle control, offering the user to switch to normal mode.</p>
     **/
    public String getNormalModeHoverText() {
        ValueBinding vb = getValueBinding("normalModeHoverText"); //NOI18N
        if (vb != null) {
            return (String)vb.getValue(getFacesContext());
        }
        return normalModeHoverText;
    }
    
    /*
     * <p>Set a custom hover text that will be used for the mode 
     toggle control, offering the user to switch to normal mode.</p>
     **/
    public void setNormalModeHoverText(String normalModeHoverText) {
        this.normalModeHoverText = normalModeHoverText;
    }
    
    private String averageModeHoverText;
    
    /*
     * <p>Get a custom hover text that will be used for the mode 
     toggle control, offering the user to switch to average mode.</p>
     **/
    public String getAverageModeHoverText() {
        ValueBinding vb = getValueBinding("averageModeHoverText"); //NOI18N
        if (vb != null) {
            return (String)vb.getValue(getFacesContext());
        }
        return averageModeHoverText;
    }
    
    /*
     * <p>Set a custom hover text that will be used for the mode 
     toggle control, offering the user to switch to average mode.</p>
     **/
    public void setAverageModeHoverText(String averageModeHoverText) {
        this.averageModeHoverText = averageModeHoverText;
    }
    
    private String gradeAcknowledgedText;
    
    /*
     * <p>Get text that appears when the user assigns a grade to the
     item (i.e., when the user clicks a control other than the mode toggle).
     If bound, this property is sent to the client via AJAX.</p>
     **/
    public String getGradeAcknowledgedText() {
        ValueBinding vb = getValueBinding("gradeAcknowledgedText"); //NOI18N
        if (vb != null) {
            return (String)vb.getValue(getFacesContext());
        }
        return gradeAcknowledgedText;
    }
    
    /*
     * <p>Set text that appears when the user assigns a grade to the
     item (i.e., when the user clicks a control other than the mode toggle).
     If bound, this property is sent to the client via AJAX.</p>
     **/
    public void setGradeAcknowledgedText(String gradeAcknowledgedText) {
        this.gradeAcknowledgedText = gradeAcknowledgedText;
    }
    
    private String normalModeAcknowledgedText;
    
    /*
     * <p>Get text that appears when the user clicks the mode toggle
     control to switch to normal mode.</p>
     **/
    public String getNormalModeAcknowledgedText() {
        ValueBinding vb = getValueBinding("normalModeAcknowledgedText"); //NOI18N
        if (vb != null) {
            return (String)vb.getValue(getFacesContext());
        }
        return normalModeAcknowledgedText;
    }
    
    /*
     * <p>Set text that appears when the user clicks the mode toggle
     control to switch to normal mode.</p>
     **/
    public void setNormalModeAcknowledgedText(String normalModeAcknowledgedText) {
        this.normalModeAcknowledgedText = normalModeAcknowledgedText;
    }
    
    private String averageModeAcknowledgedText;
    
    /*
     * <p>Get text that appears when the user clicks the modeToggle control
     to switch to average mode.</p>
     **/
    public String getAverageModeAcknowledgedText() {
        ValueBinding vb = getValueBinding("averageModeAcknowledgedText"); //NOI18N
        if (vb != null) {
            return (String)vb.getValue(getFacesContext());
        }
        return averageModeAcknowledgedText;
    }
    
    /*
     * <p>Set text that appears when the user clicks the modeToggle control
     to switch to average mode.</p>
     **/
    public void setAverageModeAcknowledgedText(String averageModeAcknowledgedText) {
        this.averageModeAcknowledgedText = averageModeAcknowledgedText;
    }
    
    private String normalModeText;
    
    /*
     * <p>Get text that appears when the mouse is not hovering and the
     component is in normal mode. If bound, this property is sent to the
     client via AJAX.</p>
     **/
    public String getNormalModeText() {
        ValueBinding vb = getValueBinding("normalModeText"); //NOI18N
        if (vb != null) {
            return (String)vb.getValue(getFacesContext());
        }
        return normalModeText;
    }
    
    /*
     * <p>Set text that appears when the mouse is not hovering and the
     component is in normal mode. If bound, this property is sent to the
     client via AJAX.</p>
     **/
    public void setNormalModeText(String normalModeText) {
        this.normalModeText = normalModeText;
    }
    
    private String averageModeText;
    
    /*
     * <p>Get text that appears when the mouse is not hovering and the
     component is in average mode. If bound, this property is sent to the
     client via AJAX.</p>
     **/
    public String getAverageModeText() {
        ValueBinding vb = getValueBinding("averageModeText"); //NOI18N
        if (vb != null) {
            return (String)vb.getValue(getFacesContext());
        }
        return averageModeText;
    }
    
    /*
     * <p>Set text that appears when the mouse is not hovering and the
     component is in average mode. If bound, this property is sent to the
     client via AJAX.</p>
     **/
    public void setAverageModeText(String averageModeText) {
        this.averageModeText = averageModeText;
    }
    
    private boolean gradeReadOnly;
    
    /*
     * <p>Get whether the grade of this rating instance can be changed 
     by the user.</p>
     **/
    public boolean isGradeReadOnly() {
        ValueBinding vb = getValueBinding("gradeReadOnly"); //NOI18N
        if (vb != null) {
            Boolean value = (Boolean)vb.getValue(getFacesContext());
            if (value != null) {
                return value.booleanValue();
            }
        }
        return gradeReadOnly;
    }
    
    /*
     * <p>Set whether the grade of this rating instance can be changed 
     by the user.</p>
     **/
    public void setGradeReadOnly(boolean gradeReadOnly) {
        this.gradeReadOnly = gradeReadOnly;
    }
    
    private boolean modeReadOnly;
    
    /*
     * <p>Get whether the mode of this rating instance can be changed 
     by the user via the mode toggle control.</p>
     **/
    public boolean isModeReadOnly() {
        ValueBinding vb = getValueBinding("modeReadOnly"); //NOI18N
        if (vb != null) {
            Boolean value = (Boolean)vb.getValue(getFacesContext());
            if (value != null) {
                return value.booleanValue();
            }
        }
        return modeReadOnly;
    }
    
    /*
     * <p>Set whether the mode of this rating instance can be changed 
     by the user via the mode toggle control.</p>
     **/
    public void setModeReadOnly(boolean modeReadOnly) {
        this.modeReadOnly = modeReadOnly;
    }
    
    private String onGrade;
    
    /*
     * <p>Get a scripting function that will be called when the
     user assigns a grade (including "not interested" or "clear").</p>
     **/
    public String getOnGrade() {
        ValueBinding vb = getValueBinding("onGrade"); //NOI18N
        if (vb != null) {
            return (String)vb.getValue(getFacesContext());
        }
        return onGrade;
    }
    
    /*
     * <p>Set a scripting function that will be called when the
     user assigns a grade (including "not interested" or "clear").</p>
     **/
    public void setOnGrade(String onGrade) {
        this.onGrade = onGrade;
    }
    
    private String onModeToggle;
    
    /*
     * <p>Get a scripting function that will be called when the
     user toggles the mode.</p>
     **/
    public String getOnModeToggle() {
        ValueBinding vb = getValueBinding("onModeToggle"); //NOI18N
        if (vb != null) {
            return (String)vb.getValue(getFacesContext());
        }
        return onModeToggle;
    }
    
    /*
     * <p>Set a scripting function that will be called when the
     user toggles the mode.</p>
     **/
    public void setOnModeToggle(String onModeToggle) {
        this.onModeToggle = onModeToggle;
    }
    
    private String onMouse;
    
    /*
     * <p>Get a scripting function that will be called when the
     user mouses over or out.</p>
     **/
    public String getOnMouse() {
        ValueBinding vb = getValueBinding("onMouse"); //NOI18N
        if (vb != null) {
            return (String)vb.getValue(getFacesContext());
        }
        return onMouse;
    }
    
    /*
     * <p>Set a scripting function that will be called when the
     user mouses over or out.</p>
     **/
    public void setOnMouse(String onMouse) {
        this.onMouse = onMouse;
    }
    
    // style
    private String style = null;
    
    /**
     * <p>CSS style(s) to be applied when this component is rendered.</p>
     */
    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueBinding vb = getValueBinding("style"); //NOI18N
        if (vb != null) {
            return (String) vb.getValue(getFacesContext());
        }
        return null;
    }
    
    /**
     * <p>CSS style(s) to be applied when this component is rendered.</p>
     * @see #getStyle()
     */
    public void setStyle(String style) {
        this.style = style;
    }
    
    // styleClass
    private String styleClass = null;
    
    /**
     * <p>CSS style class(es) to be applied when this component is rendered.</p>
     */
    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        ValueBinding vb = getValueBinding("styleClass");  //NOI18N
        if (vb != null) {
            return (String) vb.getValue(getFacesContext());
        }
        return null;
    }
    
    /**
     * <p>CSS style class(es) to be applied when this component is rendered.</p>
     * @see #getStyleClass()
     */
    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }
    
    // ----------------------------------------------------- StateHolder Methods
    /**
     * <p>Return the state to be saved for this component.
     *
     * @param context <code>FacesContext</code> for the current request
     */
    public Object saveState(FacesContext context) {
        Object values[] = new Object[26];
        values[0] = super.saveState(context);
        values[1] = this.style;
        values[2] = this.styleClass;
        values[3] = new Integer(this.maxGrade);
        values[4] = new Integer(this.grade);
        values[5] = new Double(this.averageGrade);
        values[6] = new Boolean(this.inAverageMode);
        values[7] = new Boolean(this.includeNotInterested);
        values[8] = new Boolean(this.includeClear);
        values[9] = new Boolean(this.includeModeToggle);
        values[10] = new Boolean(this.includeText);
        values[11] = this.hoverTexts;
        values[12] = this.notInterestedHoverText;
        values[13] = this.clearHoverText;
        values[14] = this.normalModeHoverText;
        values[15] = this.averageModeHoverText;
        values[16] = this.gradeAcknowledgedText;
        values[17] = this.normalModeAcknowledgedText;
        values[18] = this.averageModeAcknowledgedText;
        values[19] = this.normalModeText;
        values[20] = this.averageModeText;
        values[21] = new Boolean(this.gradeReadOnly);
        values[22] = new Boolean(this.modeReadOnly);
        values[23] = this.onGrade;
        values[24] = this.onModeToggle;
        values[25] = this.onMouse;
        return (values);
    }
    
    public void restoreState(FacesContext context, Object state) {
        Object values[] = (Object[]) state;
        super.restoreState(context, values[0]);
        this.style = (String)values[1];
        this.styleClass = (String)values[2];
        this.maxGrade = ((Integer)values[3]).intValue();
        this.grade = ((Integer)values[4]).intValue();
        this.averageGrade = ((Double)values[5]).doubleValue();
        this.inAverageMode = ((Boolean)values[6]).booleanValue();
        this.includeNotInterested = ((Boolean)values[7]).booleanValue();
        this.includeClear = ((Boolean)values[8]).booleanValue();
        this.includeModeToggle = ((Boolean)values[9]).booleanValue();
        this.includeText = ((Boolean)values[10]).booleanValue();
        this.hoverTexts = (String[])values[11];
        this.notInterestedHoverText = (String)values[12];
        this.clearHoverText = (String)values[13];
        this.normalModeHoverText = (String)values[14];
        this.averageModeHoverText = (String)values[15];
        this.gradeAcknowledgedText = (String)values[16];
        this.normalModeAcknowledgedText = (String)values[17];
        this.averageModeAcknowledgedText = (String)values[18];
        this.normalModeText = (String)values[19];
        this.averageModeText = (String)values[20];
        this.gradeReadOnly = ((Boolean)values[21]).booleanValue();
        this.modeReadOnly = ((Boolean)values[22]).booleanValue();
        this.onGrade = (String)values[23];
        this.onModeToggle = (String)values[24];
        this.onMouse = (String)values[25];
    }
}
