/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: RatingHandler.java,v 1.5 2006/04/06 08:16:23 mattbohm Exp $
 */

package com.sun.j2ee.blueprints.ui.rating;

import org.apache.shale.remoting.faces.ResponseFactory;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import java.io.IOException;
import javax.faces.el.ValueBinding;
import javax.servlet.http.HttpServletResponse;

/**
 *
 * @author Matthew Bohm
 */
public class RatingHandler {
    
    /**
     * <p>Factory for response writers that we can use to construct the
     * outgoing response.</p>
     */
    private static ResponseFactory factory = new ResponseFactory();
    
    /**
     * <p>The clientId of the rating component.</p>
     */
    private String clientId = null;


    /**
     * <p>Return the clientId.</p>
     */
    public String getClientId() {
        return this.clientId;
    }
    
    /**
     * <p>Set the clientId.</p>
     *
     * @param clientId The new clientId
     */
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }
    
    /**
     * <p>The grade of the rating component.</p>
     */
    private String grade = null;


    /**
     * <p>Return the grade.</p>
     */
    public String getGrade() {
        return this.grade;
    }
    
    /**
     * <p>Set the grade.</p>
     *
     * @param grade The new grade
     */
    public void setGrade(String grade) {
        this.grade = grade;
    }
    
    /**
     * <p>The inAverageMode state of the rating component.</p>
     */
    private String inAverageMode = null;


    /**
     * <p>Return the inAverageMode state.</p>
     */
    public String getInAverageMode() {
        return this.inAverageMode;
    }
    
    /**
     * <p>Set the inAverageMode state.</p>
     *
     * @param inAverageMode The new inAverageMode state
     */
    public void setInAverageMode(String inAverageMode) {
        this.inAverageMode = inAverageMode;
    }
    
    /**
     * <p>The binding expression that was used on the grade property of the rating component.</p>
     */
    private String gradeBinding = null;


    /**
     * <p>Return the binding expression that was used on the grade property of the rating component.</p>
     */
    public String getGradeBinding() {
        return this.gradeBinding;
    }

    /**
     * <p>Set the binding expression that was used on the grade property of the rating component.</p>
     *
     * @param gradeBinding The new binding expression
     */
    public void setGradeBinding(String gradeBinding) {
        this.gradeBinding = gradeBinding;
    }
    
    /**
     * <p>The binding expression that was used on the averageGrade property of the rating component.</p>
     */
    private String averageGradeBinding = null;


    /**
     * <p>Return the binding expression that was used on the averageGrade property of the rating component.</p>
     */
    public String getAverageGradeBinding() {
        return this.averageGradeBinding;
    }

    /**
     * <p>Set the binding expression that was used on the averageGrade property of the rating component.</p>
     *
     * @param averageGradeBinding The new binding expression
     */
    public void setAverageGradeBinding(String averageGradeBinding) {
        this.averageGradeBinding = averageGradeBinding;
    }
    
    /**
     * <p>The binding expression that was used on the normalModeText property of the rating component.</p>
     */
    private String normalModeTextBinding = null;


    /**
     * <p>Return the binding expression that was used on the normalModeText property of the rating component.</p>
     */
    public String getNormalModeTextBinding() {
        return this.normalModeTextBinding;
    }

    /**
     * <p>Set the binding expression that was used on the normalModeText property of the rating component.</p>
     *
     * @param normalModeTextBinding The new binding expression
     */
    public void setNormalModeTextBinding(String normalModeTextBinding) {
        this.normalModeTextBinding = normalModeTextBinding;
    }
    
    /**
     * <p>The binding expression that was used on the averageModeText property of the rating component.</p>
     */
    private String averageModeTextBinding = null;


    /**
     * <p>Return the binding expression that was used on the averageModeText property of the rating component.</p>
     */
    public String getAverageModeTextBinding() {
        return this.averageModeTextBinding;
    }

    /**
     * <p>Set the binding expression that was used on the averageModeText property of the rating component.</p>
     *
     * @param averageModeTextBinding The new binding expression
     */
    public void setAverageModeTextBinding(String averageModeTextBinding) {
        this.averageModeTextBinding = averageModeTextBinding;
    }
    
    /**
     * <p>The binding expression that was used on the gradeReadOnly property of the rating component.</p>
     */
    private String gradeReadOnlyBinding = null;


    /**
     * <p>Return the binding expression that was used on the gradeReadOnly property of the rating component.</p>
     */
    public String getGradeReadOnlyBinding() {
        return this.gradeReadOnlyBinding;
    }

    /**
     * <p>Set the binding expression that was used on the gradeReadOnly property of the rating component.</p>
     *
     * @param gradeReadOnlyBinding The new binding expression
     */
    public void setGradeReadOnlyBinding(String gradeReadOnlyBinding) {
        this.gradeReadOnlyBinding = gradeReadOnlyBinding;
    }
    
    /**
     * <p>The binding expression that was used on the inAverageMode property of the rating component.</p>
     */
    private String inAverageModeBinding = null;


    /**
     * <p>Return the binding expression that was used on the inAverageMode property of the rating component.</p>
     */
    public String getInAverageModeBinding() {
        return this.inAverageModeBinding;
    }

    /**
     * <p>Set the binding expression that was used on the inAverageMode property of the rating component.</p>
     *
     * @param inAverageModeBinding The new binding expression
     */
    public void setInAverageModeBinding(String inAverageModeBinding) {
        this.inAverageModeBinding = inAverageModeBinding;
    }

    public void writeAjaxResponse() throws IOException {
        FacesContext context = FacesContext.getCurrentInstance();
        //UIComponent viewRoot = context.getViewRoot();
        //RatingComponent comp = (RatingComponent)viewRoot.findComponent(this.clientId);
        
        //temp fix until shale-remoting allows the no-cache setting
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        response.setHeader("Pragma", "No-Cache");
        response.setHeader("Cache-Control", "no-cache,no-store,max-age=0");
        response.setDateHeader("Expires", 1); 
        
        //set the grade
        if (this.grade != null && this.gradeBinding != null) {
            ValueBinding gradeVb = context.getApplication().createValueBinding(this.gradeBinding);
            Integer gradeNumber = Integer.valueOf(this.grade);  //let exception be thrown
            gradeVb.setValue(context, gradeNumber);  //let exception be thrown
        }
        
        //set the inAverageMode
        if (this.inAverageMode != null && this.inAverageModeBinding != null) {
            ValueBinding inAverageModeVb = context.getApplication().createValueBinding(this.inAverageModeBinding);
            Boolean inAverageModeBoolean = Boolean.valueOf(this.inAverageMode);
            inAverageModeVb.setValue(context, inAverageModeBoolean);  //let exception be thrown
        }
        
        //retrieve the averageGrade
        Double averageGrade = null;
        if (this.averageGradeBinding != null) {
            ValueBinding averageGradeVb = context.getApplication().createValueBinding(this.averageGradeBinding);
            if (averageGradeVb != null) {
                averageGrade = (Double)averageGradeVb.getValue(context);  //let ClassCastException be thrown
            }
        }

        //retrieve the normalModeText
        String normalModeText = null;
        boolean normalModeTextSet = false;
        if (this.normalModeTextBinding != null) {
            ValueBinding normalModeTextVb = context.getApplication().createValueBinding(this.normalModeTextBinding);
            if (normalModeTextVb != null) {
                normalModeText = (String)normalModeTextVb.getValue(context);  //let ClassCastException be thrown
                if (normalModeText == null) {
                    normalModeText = "";    //NOI18N
                }
                normalModeTextSet = true;
            }
        }
        
        //retrieve the averageModeText
        String averageModeText = null;
        boolean averageModeTextSet = false;
        if (this.averageModeTextBinding != null) {
            ValueBinding averageModeTextVb = context.getApplication().createValueBinding(this.averageModeTextBinding);
            if (averageModeTextVb != null) {
                averageModeText = (String)averageModeTextVb.getValue(context);  //let ClassCastException be thrown
                if (averageModeText == null) {
                    averageModeText = "";    //NOI18N
                }
                averageModeTextSet = true;
            }
        }
        
        //retrieve gradeReadOnly
        Boolean gradeReadOnly = null;
        if (this.gradeReadOnlyBinding != null) {
            ValueBinding gradeReadOnlyVb = context.getApplication().createValueBinding(this.gradeReadOnlyBinding);
            if (gradeReadOnlyVb != null) {
                gradeReadOnly = (Boolean)gradeReadOnlyVb.getValue(context);  //let ClassCastException be thrown
            }
        }
        
        ResponseWriter writer = factory.getResponseWriter(context, "text/xml");
        // Render the response
        UIComponent comp = null;
        writer.startDocument();
        writer.startElement("message", comp);  //NOI18N
        writer.startElement("clientId", comp);  //NOI18N
        writer.writeText(this.clientId, null);
        writer.endElement("clientId");  //NOI18N
        if (averageGrade != null) {
            writer.startElement("averageGrade", comp);  //NOI18N
            writer.writeText(averageGrade.toString(), null);
            writer.endElement("averageGrade");  //NOI18N   
        }
        if (normalModeTextSet) {
            writer.startElement("normalModeText", comp);  //NOI18N
            writer.writeText(normalModeText, null);     //use writeText instead of write because this is within XML
            writer.endElement("normalModeText");  //NOI18N   
        }
        if (averageModeTextSet) {
            writer.startElement("averageModeText", comp);  //NOI18N
            writer.writeText(averageModeText, null);     //use writeText instead of write because this is within XML
            writer.endElement("averageModeText");  //NOI18N   
        }
        if (gradeReadOnly != null) {
            writer.startElement("gradeReadOnly", comp);  //NOI18N
            writer.writeText(gradeReadOnly.toString(), null);
            writer.endElement("gradeReadOnly");  //NOI18N   
        }
        writer.endElement("message");  //NOI18N
        writer.endDocument();
        writer.flush();
    }
    
}
