/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: RatingRenderer.java,v 1.8 2006/04/26 04:03:03 craig_mcc Exp $
 */

package com.sun.j2ee.blueprints.ui.rating;


import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

import java.io.IOException;

import com.sun.j2ee.blueprints.ui.util.Util;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.servlet.http.HttpServletResponse;

import com.sun.j2ee.blueprints.ui.util.BaseRenderer;
import java.beans.Beans;
import java.net.URL;
import javax.faces.el.ValueBinding;
import javax.faces.component.NamingContainer;
import org.apache.shale.remoting.XhtmlHelper;
import org.apache.shale.remoting.Mechanism;

/**
 * <p>Render our associated {@link RatingComponent}.
 * </p>
 */

public class RatingRenderer extends BaseRenderer {
    
    /**
     * <p>A pseudo-grade for the mode toggle control.</p>
     */
    private static final int MODE_TOGGLE_CODE = -2;
    
    /**
     * <p>Resource name of the not interested "off" image.</p>
     */
    private static final String NOT_INTERESTED_OFF_IMAGE =
            "/META-INF/rating/images/notInterestedOff.gif";
    
    /**
     * <p>Resource name of the not interested "on" image.</p>
     */
    private static final String NOT_INTERESTED_ON_IMAGE =
            "/META-INF/rating/images/notInterestedOn.gif";
    
    /**
     * <p>Resource name of the normal full star image.</p>
     */
    private static final String STAR_FULL_IMAGE =
            "/META-INF/rating/images/starFull.gif";
    
    /**
     * <p>Resource name of the average full star image.</p>
     */
    private static final String AVERAGE_STAR_FULL_IMAGE =
            "/META-INF/rating/images/avgStarFull.gif";
    
    /**
     * <p>Resource name of the average half star image.</p>
     */
    private static final String AVERAGE_STAR_HALF_IMAGE =
            "/META-INF/rating/images/avgStarHalf.gif";
    
    /**
     * <p>Resource name of the empty star image.</p>
     */
    private static final String STAR_EMPTY_IMAGE =
            "/META-INF/rating/images/starEmpty.gif";
    
    
    /**
     * <p>Resource name of the clear "off" image.</p>
     */
    private static final String CLEAR_OFF_IMAGE =
            "/META-INF/rating/images/clearOff.gif";
    
    /**
     * <p>Resource name of the clear "on" image.</p>
     */
    private static final String CLEAR_ON_IMAGE =
            "/META-INF/rating/images/clearOn.gif";
    
    /**
     * <p>Resource name of the normal mode image.</p>
     */
    private static final String MODE_NORMAL_IMAGE =
            "/META-INF/rating/images/whoMe.gif";
    
    /**
     * <p>Resource name of the normal mode image.</p>
     */
    private static final String MODE_AVERAGE_IMAGE =
            "/META-INF/rating/images/whoAvg.gif";
    
    /**
     * <p>The static CSS resource for this component.</p>
     */
    private static final String CSS_RESOURCE =
            "/META-INF/rating/styles.css"; //NOI18N

    /**
     * <p>The static script resource for this component.</p>
     */
    private static final String SCRIPT_RESOURCE =
            "/META-INF/rating/script.js"; //NOI18N
    
    /**
     * <p>Request attribute to flag whether the rendering of once-only output has been performed.</p>
     */
    private static final String RENDER_ONCE = "com.sun.j2ee.blueprints.ui.rating.RENDER_ONCE"; //NOI18N
    
    /**
     * <p>Resource identifier for our AJAX response handler.</p>
     */
    private static final String RESPONSE_HANDLER =
            "/bpui_rating_handler/writeAjaxResponse"; //NOI18N
    
    /*
    public void decode(FacesContext context, UIComponent component) {
    }
     **/
    
    /**
     * <p>Stateless helper bean to manufacture resource linkages.</p>
     */
    private static XhtmlHelper helper = new XhtmlHelper();
    
    private void appendDefaultImageInfo(FacesContext context, UIComponent component, StringBuffer sb, String imageInfosKey, String[] jarPaths, String width, String height) {
        sb.append("bpui.rating.defaults.imageInfos["); //NOI18N
        sb.append("\""); //NOI18N
        sb.append(imageInfosKey);
        sb.append("\""); //NOI18N
        sb.append("] = new bpui.rating.ImageInfo(null, new Array("); //NOI18N

        for (int i = 0; i < jarPaths.length; i++) {
            String imageUrl = getImageUrl(context, component, jarPaths[i]);
            sb.append("\""); //NOI18N
            sb.append(imageUrl);
            sb.append("\""); //NOI18N
            if (i < jarPaths.length - 1) {
                sb.append(", "); //NOI18N
            }
        }
        sb.append("), "); //NOI18N
        sb.append(width);
        sb.append(", "); //NOI18N
        sb.append(height);
        sb.append(");");   //NOI18N
        sb.append("\n"); //NOI18N
    }
    
    public void encodeEnd(FacesContext context, UIComponent component)
    throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = component.getClientId(context);
        RatingComponent rating = null;
        if (component instanceof RatingComponent) {
            rating = (RatingComponent)component;
        } else {
            System.err.println("RatingRenderer.encodeBegin: expected type " + RatingComponent.class + " but found " + component.getClass());  //NOI18N
            System.err.println("RatingRenderer.encodeBegin: class loader hierarchy, starting with RatingComponent.class.getClassLoader():");  //NOI18N
            ClassLoader cl = RatingComponent.class.getClassLoader();
            while(cl != null) {
                System.err.println(cl);
                cl = cl.getParent();
            }
            System.err.println();
            System.err.println("RatingRenderer.encodeBegin: class loader hierarchy, starting with component.getClass().getClassLoader():");  //NOI18N
            cl = component.getClass().getClassLoader();
            while(cl != null) {
                System.err.println(cl);
                cl = cl.getParent();
            }
            System.err.println();
        }
        
        //render resources
        if(Beans.isDesignTime()) {
            // Retrieve our stylesheet
            URL cssURL = component.getClass().getResource(CSS_RESOURCE);
            writer.startElement("link", component); //NOI18N
            writer.writeAttribute("type", "text/css", null); //NOI18N
            writer.writeAttribute("rel", "stylesheet", null); //NOI18N
            writer.writeURIAttribute("href", cssURL, null); //NOI18N
            writer.endElement("link"); //NOI18N
        }
        else {
            helper.linkStylesheet(context, component, writer,
                                  Mechanism.CLASS_RESOURCE,
                                  CSS_RESOURCE);
            helper.linkJavascript(context, component, writer,
                                  Mechanism.CLASS_RESOURCE,
                                  Util.UI_COMMON_SCRIPT_RESOURCE);
            Util.renderDojoLoading(context, component, writer);
            helper.linkJavascript(context, component, writer,
                                  Mechanism.CLASS_RESOURCE,
                                  SCRIPT_RESOURCE);
            
            writer.startElement("script", null); //NOI18N
            
            StringBuffer sb = new StringBuffer();
            
            if (!context.getExternalContext().getRequestMap().containsKey(RENDER_ONCE)) {
                context.getExternalContext().getRequestMap().put(RENDER_ONCE, Boolean.TRUE);
                
                //render DefaultInfo creation
                sb.append("bpui.rating.defaults = new bpui.rating.DefaultInfo();"); //NOI18N
                sb.append("\n"); //NOI18N
                
                //"star" defaults
                String imageInfosKey = "star"; //NOI18N
                String[] jarPaths = {STAR_FULL_IMAGE, AVERAGE_STAR_FULL_IMAGE, AVERAGE_STAR_HALF_IMAGE, STAR_EMPTY_IMAGE};
                String width = "19", height = "15";    //NOI18N
                appendDefaultImageInfo(context, component, sb, imageInfosKey, jarPaths, width, height);
                
                //"notInterested" defaults
                imageInfosKey = "notInterested"; //NOI18N
                jarPaths = new String[]{NOT_INTERESTED_OFF_IMAGE, NOT_INTERESTED_ON_IMAGE};
                width = "17";    //NOI18N
                appendDefaultImageInfo(context, component, sb, imageInfosKey, jarPaths, width, height);
                
                //"clear" defaults
                imageInfosKey = "clear"; //NOI18N
                jarPaths = new String[]{CLEAR_OFF_IMAGE, CLEAR_ON_IMAGE};
                width = "19";    //NOI18N
                appendDefaultImageInfo(context, component, sb, imageInfosKey, jarPaths, width, height);
                
                //"modeToggle" defaults
                imageInfosKey = "modeToggle"; //NOI18N
                jarPaths = new String[]{MODE_NORMAL_IMAGE, MODE_AVERAGE_IMAGE};
                width = "30";    //NOI18N
                appendDefaultImageInfo(context, component, sb, imageInfosKey, jarPaths, width, height);
                
                sb.append("bpui.rating.preloadDefaultImages(bpui.rating.defaults);"); //NOI18N
                sb.append("\n"); //NOI18N
                
                writer.write(sb.toString());
                sb.setLength(0);
                
                //get the url that will be used to make ajax requests
                String callback = helper.mapResourceId(context,
                                                       Mechanism.DYNAMIC_RESOURCE,
                                                       RESPONSE_HANDLER);
                sb.append("bpui.rating.unparameterizedUrl = \""); //NOI18N
                sb.append(callback);
                sb.append("\";"); //NOI18N
                sb.append("\n");  //NOI18N
                sb.append("bpui.rating.messages[\"bindError\"] = \""); //NOI18N
                sb.append(Util.getMessage("rating.bindError")); //NOI18N
                sb.append("\";");  //NOI18N
                sb.append("\n");  //NOI18N
                sb.append("bpui.rating.messages[\"unboundGrade\"] = \"");  //NOI18N
                sb.append(Util.getMessage("rating.unboundGrade"));  //NOI18N
                sb.append("\";");  //NOI18N
                sb.append("\n");  //NOI18N
                sb.append("bpui.rating.messages[\"unboundInAverageMode\"] = \"");  //NOI18N
                sb.append(Util.getMessage("rating.unboundInAverageMode")); //NOI18N
                sb.append("\";");  //NOI18N
                sb.append("\n");  //NOI18N
                writer.write(sb.toString());
                sb.setLength(0);
            }
            
            //create an Instance for this Rating instance
            ValueBinding gradeBinding = rating.getValueBinding("grade"); //NOI18N
            ValueBinding averageGradeBinding = rating.getValueBinding("averageGrade"); //NOI18N
            sb.append("new bpui.rating.Instance("); //NOI18N
            sb.append("\"");    //NOI18N
            sb.append(clientId);
            sb.append("\"");    //NOI18N
            sb.append(", ");    //NOI18N
            sb.append(rating.getMaxGrade());
            sb.append(", ");    //NOI18N
            sb.append(rating.isInAverageMode());
            sb.append(", ");    //NOI18N
            sb.append(rating.getGrade());
            sb.append(", ");    //NOI18N
            sb.append(rating.getAverageGrade());
            sb.append(", ");    //NOI18N
            if (gradeBinding != null && gradeBinding.getExpressionString() != null) {
                sb.append("\"");    //NOI18N
                sb.append(gradeBinding.getExpressionString());
                sb.append("\"");    //NOI18N
            }
            else {
                sb.append("null");  //NOI18N
            }
            sb.append(", ");    //NOI18N
            if (averageGradeBinding != null && averageGradeBinding.getExpressionString() != null) {
                sb.append("\"");    //NOI18N
                sb.append(averageGradeBinding.getExpressionString());
                sb.append("\"");    //NOI18N
            }
            else {
                sb.append("null");  //NOI18N
            }
            sb.append(");"); //NOI18N
            sb.append("\n"); //NOI18N
            writer.write(sb.toString());
            //sb.setLength(0);
            sb = null;
            
            //custom hover texts
            String[] whichs = {null, "notInterested", "clear", "modeToggle"};
            
            String[][] customHoverTextArrays = {
                rating.getHoverTexts(),
                (rating.getNotInterestedHoverText() == null ? null : new String[]{rating.getNotInterestedHoverText()}), 
                (rating.getClearHoverText() == null ? null : new String[]{rating.getClearHoverText()}), 
                ( (rating.getNormalModeHoverText() != null || rating.getAverageModeHoverText() != null)  ? 
                            new String[]{rating.getNormalModeHoverText(), rating.getAverageModeHoverText()} : 
                            null )
            };
            
            for (int i = 0; i < whichs.length; i++) {
                if (customHoverTextArrays[i] != null) {
                    writer.write("bpui.rating.state[\""); //NOI18N
                    writer.write(clientId);
                    if (whichs[i] == null) {
                        writer.write("\"].setStarCustomHoverTexts(new Array("); //NOI18N
                    }
                    else {
                        writer.write("\"].setCustomHoverTexts(\"");
                        writer.write(whichs[i]);
                        writer.write("\", new Array("); //NOI18N
                    }
                    
                    String[] customHoverTexts = customHoverTextArrays[i];
                    for (int j = 0; j < customHoverTexts.length; j++) {
                        if (customHoverTexts[j] == null) {
                            writer.write("null");
                        }
                        else {
                            writer.write("\"");   //NOI18N
                            writer.writeText(customHoverTexts[j], null);
                            writer.write("\"");   //NOI18N
                        }
                        if (j < customHoverTexts.length - 1) {
                            writer.write(", "); //NOI18N
                        }
                    }
                    writer.write("));\n"); //NOI18N
                }
            }
            
            //other text properties
            String[] otherTextProperties = {
                "gradeAcknowledgedText", 
                "normalModeAcknowledgedText", 
                "averageModeAcknowledgedText", 
                "normalModeText",
                "averageModeText"
            };
            
            String[] otherTexts = {
                rating.getGradeAcknowledgedText(),
                rating.getNormalModeAcknowledgedText(),
                rating.getAverageModeAcknowledgedText(),
                rating.getNormalModeText(),
                rating.getAverageModeText()
            };
            
            for (int i = 0; i < otherTexts.length; i++) {
                if (otherTexts[i] != null) {
                    writer.write("bpui.rating.state[\""); //NOI18N
                    writer.write(clientId);
                    writer.write("\"]."); //NOI18N
                    writer.write(otherTextProperties[i]);
                    writer.write(" = \""); //NOI18N
                    writer.writeText(otherTexts[i], null);
                    writer.write("\";\n");   //NOI18N
                }
            }
            
            if (rating.isGradeReadOnly()) {
                    writer.write("bpui.rating.state[\""); //NOI18N
                    writer.write(clientId);
                    writer.write("\"].gradeReadOnly = true;\n"); //NOI18N
            }
            
            if (rating.isModeReadOnly()) {
                    writer.write("bpui.rating.state[\""); //NOI18N
                    writer.write(clientId);
                    writer.write("\"].modeReadOnly = true;\n"); //NOI18N
            }
            
            if (rating.getOnGrade() != null && rating.getOnGrade().length() > 0) {
                    writer.write("bpui.rating.state[\""); //NOI18N
                    writer.write(clientId);
                    writer.write("\"].onGrade = "); //NOI18N
                    writer.writeText(rating.getOnGrade(), "onGrade"); //NOI18N
                    writer.write("\n");   //NOI18N
            }
            
            if (rating.getOnModeToggle() != null && rating.getOnModeToggle().length() > 0) {
                    writer.write("bpui.rating.state[\""); //NOI18N
                    writer.write(clientId);
                    writer.write("\"].onModeToggle = "); //NOI18N
                    writer.writeText(rating.getOnModeToggle(), "onModeToggle"); //NOI18N
                    writer.write("\n");   //NOI18N
            }
            
            if (rating.getOnMouse() != null && rating.getOnMouse().length() > 0) {
                    writer.write("bpui.rating.state[\""); //NOI18N
                    writer.write(clientId);
                    writer.write("\"].onMouse = "); //NOI18N
                    writer.writeText(rating.getOnMouse(), "onMouse"); //NOI18N
                    writer.write("\n");   //NOI18N
            }
            
            //other bindings
            String[] otherBindings = {"normalModeText", "averageModeText", "gradeReadOnly", "inAverageMode"};
            for (int i = 0; i < otherBindings.length; i++) {
                ValueBinding binding = rating.getValueBinding(otherBindings[i]);
                if (binding != null && binding.getExpressionString() != null) {
                    writer.write("bpui.rating.state[\""); //NOI18N
                    writer.write(clientId);
                    writer.write("\"].bindings[\""); //NOI18N
                    writer.write(otherBindings[i]);
                    writer.write("\"] = \""); //NOI18N
                    writer.writeText(binding.getExpressionString(), null);
                    writer.write("\";\n");   //NOI18N
                }
            }
            
            writer.endElement("script"); //NOI18N
            writer.write("\n");   //NOI18N
        }
        
        //render outer div, both for designtime and runtime
        writer.startElement("div", component);  //NOI18N
        writer.writeAttribute("id", clientId, null);  //NOI18N
        String style = rating.getStyle();
        String styleClass = rating.getStyleClass();
        if (style != null) {
            writer.writeAttribute("style", style, "style");  //NOI18N
        }
        if (styleClass != null) {
            writer.writeAttribute("class", styleClass, "styleClass");  //NOI18N
        }
        writer.write("\n"); //NOI18N
        
        //write out the "text" div
        if (rating.isIncludeText()) {
            writer.startElement("div", null);  //NOI18N
            writer.writeAttribute("id", clientId + "_text", null);  //NOI18N
            writer.writeAttribute("class", "bpui_rating_text", null);  //NOI18N

            String text = null;
            //String textProperty = null;
            if (rating.isInAverageMode() && rating.getAverageModeText() != null) {
                text = rating.getAverageModeText();
                //textProperty = "averageModeText";    //NOI18N
            }
            else if (!rating.isInAverageMode() && rating.getNormalModeText() != null) {
                text = rating.getNormalModeText();
                //textProperty = "normalModeText";    //NOI18N 
            }

            if (text == null) {
                writer.write("&nbsp;"); //NOI18N
            }
            else {
                writer.write(text); //use write instead of writeText so that appdeveloper can include markup
            }
            writer.endElement("div");    //NOI18N
            writer.write("\n"); //NOI18N
        }
        
        //write out the "control" table and row
        writer.startElement("table", component);  //NOI18N
        writer.writeAttribute("id", clientId + "_controlArea", null);  //NOI18N
        writer.writeAttribute("class", "bpui_rating_controlArea", null);  //NOI18N
        writer.writeAttribute("border", "0", null);  //NOI18N
        writer.writeAttribute("cellspacing", "0", null);  //NOI18N
        writer.writeAttribute("cellpadding", "0", null);  //NOI18N
        writer.write("\n"); //NOI18N
        writer.startElement("tr", null);  //NOI18N
        writer.write("\n"); //NOI18N
        
        String doMousePrefix = "bpui.rating.doMouse(\""; //NOI18N
        String doJoiner = "\", ";    //NOI18N
        String doMouseCompositePrefix = doMousePrefix + clientId + doJoiner;
        String doClickPrefix = "bpui.rating.doClick(\""; //NOI18N
        String doClickCompositePrefix = doClickPrefix + clientId + doJoiner;
        String doMouseOverSuffix = ", true)"; //NOI18N
        String doMouseOutSuffix = ", false)"; //NOI18N
        String doClickSuffix = ")"; //NOI18N
        
        //not interested image
        if (rating.isIncludeNotInterested()) {
            writer.startElement("td", null);  //NOI18N
            writer.writeAttribute("id", clientId + "_notInterestedArea", null);  //NOI18N
            writer.writeAttribute("class", "bpui_rating_notInterestedArea", null);  //NOI18N
            writer.writeAttribute("width", "17", null);  //NOI18N
            writer.writeAttribute("height", "15", null);  //NOI18N
            writer.startElement("img", null);   //NOI18N
            writer.writeAttribute("id", clientId + "_notInterestedImage", null); //NOI18N
            String jarPath = rating.getGrade() == -1 && !rating.isInAverageMode() ? NOT_INTERESTED_ON_IMAGE : NOT_INTERESTED_OFF_IMAGE;
            String imageUrl = getImageUrl(context, component, jarPath);
            writer.writeAttribute("src", imageUrl, null); //NOI18N
            writer.writeAttribute("width", "17", null);  //NOI18N
            writer.writeAttribute("height", "15", null);  //NOI18N
            writer.writeAttribute("border", "0", null); //NOI18N
            writer.writeAttribute("onmouseover", doMouseCompositePrefix + RatingComponent.NOT_INTERESTED_GRADE + doMouseOverSuffix, null);  //NOI18N
            writer.writeAttribute("onclick", doClickCompositePrefix + RatingComponent.NOT_INTERESTED_GRADE + doClickSuffix, null);  //NOI18N
            writer.writeAttribute("onmouseout", doMouseCompositePrefix + RatingComponent.NOT_INTERESTED_GRADE + doMouseOutSuffix, null);  //NOI18N
            writer.endElement("img"); //NOI18N
            writer.endElement("td"); //NOI18N
            writer.write("\n"); //NOI18N
        }
        
        //star images
        for (int i = 1; i <= rating.getMaxGrade(); i++) {
            writer.startElement("td", null);  //NOI18N
            writer.writeAttribute("id", clientId + "_starArea" + i, null);  //NOI18N
            writer.writeAttribute("class", "bpui_rating_starArea", null);  //NOI18N
            writer.writeAttribute("width", "19", null);  //NOI18N
            writer.writeAttribute("height", "15", null);  //NOI18N
            writer.startElement("img", null);   //NOI18N
            writer.writeAttribute("id", clientId + "_starImage" + i, null); //NOI18N
            double diff = (rating.isInAverageMode() ? (rating.getAverageGrade() - i) : (rating.getGrade() - i));
            String jarPath = null;
            //show correct image based on diff
            if (diff < (0 -.5)) {  //diff is -0.6 and lower
                jarPath = STAR_EMPTY_IMAGE;  //show empty star
            }
            else if (diff < 0) {  //diff is between -0.5 and -0.1
              if (rating.isInAverageMode()) {
                jarPath = AVERAGE_STAR_HALF_IMAGE;  //show avg half star
              }
              else {
                jarPath = STAR_EMPTY_IMAGE;  //show empty star
              }
            }
            //diff is 0 and higher
            else if (rating.isInAverageMode()) {
                jarPath = AVERAGE_STAR_FULL_IMAGE;  //show avg full star
            }
            else {
                jarPath = STAR_FULL_IMAGE; //show me full star
            }
            String imageUrl = getImageUrl(context, component, jarPath);
            writer.writeAttribute("src", imageUrl, null); //NOI18N
            writer.writeAttribute("width", "19", null);  //NOI18N
            writer.writeAttribute("height", "15", null);  //NOI18N
            writer.writeAttribute("border", "0", null); //NOI18N
            writer.writeAttribute("onmouseover", doMouseCompositePrefix + i + doMouseOverSuffix, null);  //NOI18N
            writer.writeAttribute("onclick", doClickCompositePrefix + i + doClickSuffix, null);  //NOI18N
            writer.writeAttribute("onmouseout", doMouseCompositePrefix + i + doMouseOutSuffix, null);  //NOI18N
            writer.endElement("img"); //NOI18N
            writer.endElement("td"); //NOI18N
            writer.write("\n"); //NOI18N
        }
        
        if (rating.isIncludeClear() || rating.isIncludeModeToggle()) {
            writer.startElement("td", null);  //NOI18N
            writer.writeAttribute("id", clientId + "_spacerArea", null);  //NOI18N
            writer.writeAttribute("class", "bpui_rating_spacerArea", null);  //NOI18N
            writer.writeAttribute("width", "10", null);  //NOI18N
            writer.writeAttribute("height", "15", null);  //NOI18N
            writer.endElement("td"); //NOI18N
            writer.write("\n"); //NOI18N
        }
        
        //clear image
        if (rating.isIncludeClear()) {
            writer.startElement("td", null);  //NOI18N
            writer.writeAttribute("id", clientId + "_clearArea", null);  //NOI18N
            writer.writeAttribute("class", "bpui_rating_clearArea", null);  //NOI18N
            writer.writeAttribute("width", "19", null);  //NOI18N
            writer.writeAttribute("height", "15", null);  //NOI18N
            writer.startElement("img", null);   //NOI18N
            writer.writeAttribute("id", clientId + "_clearImage", null); //NOI18N
            String jarPath = CLEAR_OFF_IMAGE;
            String imageUrl = getImageUrl(context, component, jarPath);
            writer.writeAttribute("src", imageUrl, null); //NOI18N
            writer.writeAttribute("width", "19", null);  //NOI18N
            writer.writeAttribute("height", "15", null);  //NOI18N
            writer.writeAttribute("border", "0", null); //NOI18N
            writer.writeAttribute("onmouseover", doMouseCompositePrefix + RatingComponent.CLEAR_GRADE + doMouseOverSuffix, null);  //NOI18N
            writer.writeAttribute("onclick", doClickCompositePrefix + RatingComponent.CLEAR_GRADE + doClickSuffix, null);  //NOI18N
            writer.writeAttribute("onmouseout", doMouseCompositePrefix + RatingComponent.CLEAR_GRADE + doMouseOutSuffix, null);  //NOI18N
            writer.endElement("img"); //NOI18N
            writer.endElement("td"); //NOI18N
            writer.write("\n"); //NOI18N
        }
        
        //mode toggle image
        if (rating.isIncludeModeToggle()) {
            writer.startElement("td", null);  //NOI18N
            writer.writeAttribute("id", clientId + "_modeToggleArea", null);  //NOI18N
            writer.writeAttribute("class", "bpui_rating_modeToggleArea", null);  //NOI18N
            writer.writeAttribute("width", "30", null);  //NOI18N
            writer.writeAttribute("height", "15", null);  //NOI18N
            writer.startElement("img", null);   //NOI18N
            writer.writeAttribute("id", clientId + "_modeToggleImage", null); //NOI18N
            String jarPath = rating.isInAverageMode() ? MODE_AVERAGE_IMAGE : MODE_NORMAL_IMAGE;
            String imageUrl = getImageUrl(context, component, jarPath);
            writer.writeAttribute("src", imageUrl, null); //NOI18N
            writer.writeAttribute("width", "30", null);  //NOI18N
            writer.writeAttribute("height", "15", null);  //NOI18N
            writer.writeAttribute("border", "0", null); //NOI18N
            writer.writeAttribute("onmouseover", doMouseCompositePrefix + MODE_TOGGLE_CODE + doMouseOverSuffix, null);  //NOI18N
            writer.writeAttribute("onclick", doClickCompositePrefix + MODE_TOGGLE_CODE + doClickSuffix, null);  //NOI18N
            writer.writeAttribute("onmouseout", doMouseCompositePrefix + MODE_TOGGLE_CODE + doMouseOutSuffix, null);  //NOI18N
            writer.endElement("img"); //NOI18N
            writer.endElement("td"); //NOI18N
            writer.write("\n"); //NOI18N
        }
        
        writer.endElement("tr"); //control row NOI18N
        writer.write("\n"); //NOI18N
        writer.endElement("table"); //control table NOI18N
        writer.write("\n"); //NOI18N
        
        writer.endElement("div"); //outer table NOI18N
        writer.write("\n"); //NOI18N
    }
    
    private String getImageUrl(FacesContext context, UIComponent component, String jarPath) {
        if (Beans.isDesignTime()) {
            return component.getClass().getResource(jarPath).toString();
        }
        else {
            return helper.mapResourceId(context, Mechanism.CLASS_RESOURCE, jarPath);
        }
    }
}
