/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: RatingTag.java,v 1.4 2006/04/01 10:00:35 mattbohm Exp $
 */

package com.sun.j2ee.blueprints.ui.rating;

import com.sun.j2ee.blueprints.ui.util.Util;
import com.sun.j2ee.blueprints.ui.util.AbstractUIComponentTag;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

import javax.faces.el.ValueBinding;
import javax.faces.el.MethodBinding;
import javax.faces.webapp.UIComponentTag;


/**
 * <p><strong>RatingTag</strong> is the tag handler that processes the
 * <code>rating</code> custom tag.</p>
 */

public class RatingTag extends AbstractUIComponentTag {
    
    /**
     * <p>Return the type of the component.
     */
    public String getComponentType() {
        return ("com.sun.j2ee.blueprints.ui.rating.Rating"); //NOI18N
    }
    
    
    /**
     * <p>Return the renderer type (if any)
     */
    public String getRendererType() {
        return ("com.sun.j2ee.blueprints.ui.rating.Rating"); //NOI18N
    }
    
    /**
     * <p>Release any resources used by this tag handler
     */
    public void release() {
        super.release();
        this.maxGrade = null;
        this.grade = null;
        this.averageGrade = null;
        this.inAverageMode = null;
        this.includeNotInterested = null;
        this.includeClear = null;
        this.includeModeToggle = null;
        this.includeText = null;
        this.hoverTexts = null;
        this.notInterestedHoverText = null;
        this.clearHoverText = null;
        this.normalModeHoverText = null;
        this.averageModeHoverText = null;
        this.gradeAcknowledgedText = null;
        this.normalModeAcknowledgedText = null;
        this.averageModeAcknowledgedText = null;
        this.normalModeText = null;
        this.averageModeText = null;
        this.gradeReadOnly = null;
        this.modeReadOnly = null;
        this.onGrade = null;
        this.onModeToggle = null;
        this.onMouse = null;
    }
    
    /**
     * <p>Set the component properties
     */
    protected void setProperties(UIComponent component) {
        super.setProperties(component);
        RatingComponent rating = (RatingComponent)component;

        configureInteger(component, "maxGrade", maxGrade);  //NOI18N
        configureInteger(component, "grade", grade);    //NOI18N
        
        if (averageGrade != null) {
            if (isValueReference(averageGrade)) {
                ValueBinding vb = FacesContext.getCurrentInstance()
                .getApplication().createValueBinding(averageGrade);
                rating.setValueBinding("averageGrade", vb); //NOI18N
            } else {
                double aDouble = Integer.parseInt(averageGrade);
                rating.setAverageGrade(aDouble);
            }
        }

        configureBoolean(component, "inAverageMode", inAverageMode);    //NOI18N
        configureBoolean(component, "includeNotInterested", includeNotInterested);  //NOI18N
        configureBoolean(component, "includeClear", includeClear);  //NOI18N
        configureBoolean(component, "includeModeToggle", includeModeToggle);
        configureBoolean(component, "includeText", includeText);    //NOI18N
        
        if (hoverTexts != null) {
            if (isValueReference(hoverTexts)) {
                ValueBinding vb = FacesContext.getCurrentInstance()
                .getApplication().createValueBinding(hoverTexts);
                rating.setValueBinding("hoverTexts", vb); //NOI18N
            } else {
                String[] arr = hoverTexts.split("\\|"); //NOI18N    assume pipe-delimited
                rating.setHoverTexts(arr);
            }
        }
        
        configureString(component, "notInterestedHoverText", notInterestedHoverText);   //NOI18N
        configureString(component, "clearHoverText", clearHoverText);   //NOI18N
        configureString(component, "normalModeHoverText", normalModeHoverText); //NOI18N
        configureString(component, "averageModeHoverText", averageModeHoverText);   //NOI18N
        configureString(component, "gradeAcknowledgedText", gradeAcknowledgedText); //NOI18N
        configureString(component, "normalModeAcknowledgedText", normalModeAcknowledgedText);   //NOI18N
        configureString(component, "averageModeAcknowledgedText", averageModeAcknowledgedText); //NOI18N
        configureString(component, "normalModeText", normalModeText);   //NOI18N
        configureString(component, "averageModeText", averageModeText); //NOI18N
        configureBoolean(component, "gradeReadOnly", gradeReadOnly);    //NOI18N
        configureBoolean(component, "modeReadOnly", modeReadOnly);  //NOI18N
        configureString(component, "onGrade", onGrade); //NOI18N
        configureString(component, "onModeToggle", onModeToggle);   //NOI18N
        configureString(component, "onMouse", onMouse); //NOI18N
    }
    

    private String maxGrade;
    public void setMaxGrade(String maxGrade) {
        this.maxGrade = maxGrade;
    }
    
    private String grade;
    public void setGrade(String grade) {
        this.grade = grade;
    }
    
    private String averageGrade;
    public void setAverageGrade(String averageGrade) {
        this.averageGrade = averageGrade;
    }
    
    private String inAverageMode;
    public void setInAverageMode(String inAverageMode) {
        this.inAverageMode = inAverageMode;
    }
    
    private String includeNotInterested;
    public void setIncludeNotInterested(String includeNotInterested) {
        this.includeNotInterested = includeNotInterested;
    }
    
    private String includeClear;
    public void setIncludeClear(String includeClear) {
        this.includeClear = includeClear;
    }
    
    private String includeModeToggle;
    public void setIncludeModeToggle(String includeModeToggle) {
        this.includeModeToggle = includeModeToggle;
    }
    
    private String includeText;
    public void setIncludeText(String includeText) {
        this.includeText = includeText;
    }
    
    private String hoverTexts;
    public void setHoverTexts(String hoverTexts) {
        this.hoverTexts = hoverTexts;
    }
    
    private String notInterestedHoverText;
    public void setNotInterestedHoverText(String notInterestedHoverText) {
        this.notInterestedHoverText = notInterestedHoverText;
    }
    
    private String clearHoverText;
    public void setClearHoverText(String clearHoverText) {
        this.clearHoverText = clearHoverText;
    }
    
    private String normalModeHoverText;
    public void setNormalModeHoverText(String normalModeHoverText) {
        this.normalModeHoverText = normalModeHoverText;
    }
    
    private String averageModeHoverText;
    public void setAverageModeHoverText(String averageModeHoverText) {
        this.averageModeHoverText = averageModeHoverText;
    }
    
    private String gradeAcknowledgedText;
    public void setGradeAcknowledgedText(String gradeAcknowledgedText) {
        this.gradeAcknowledgedText = gradeAcknowledgedText;
    }
    
    private String normalModeAcknowledgedText;
    public void setNormalModeAcknowledgedText(String normalModeAcknowledgedText) {
        this.normalModeAcknowledgedText = normalModeAcknowledgedText;
    }
    
    private String averageModeAcknowledgedText;
    public void setAverageModeAcknowledgedText(String averageModeAcknowledgedText) {
        this.averageModeAcknowledgedText = averageModeAcknowledgedText;
    }
    
    private String normalModeText;
    public void setNormalModeText(String normalModeText) {
        this.normalModeText = normalModeText;
    }
    
    private String averageModeText;
    public void setAverageModeText(String averageModeText) {
        this.averageModeText = averageModeText;
    }
    
    private String gradeReadOnly;
    public void setGradeReadOnly(String gradeReadOnly) {
        this.gradeReadOnly = gradeReadOnly;
    }
    
    private String modeReadOnly;
    public void setModeReadOnly(String modeReadOnly) {
        this.modeReadOnly = modeReadOnly;
    }
    
    private String onGrade;
    public void setOnGrade(String onGrade) {
        this.onGrade = onGrade;
    }
    
    private String onModeToggle;
    public void setOnModeToggle(String onModeToggle) {
        this.onModeToggle = onModeToggle;
    }
    
    private String onMouse;
    public void setOnMouse(String onMouse) {
        this.onMouse = onMouse;
    }
}
