/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: SelectValueComponent.java,v 1.4 2006/01/19 20:01:43 craig_mcc Exp $
 */

package com.sun.j2ee.blueprints.ui.selectvalue;

import java.io.IOException;
import java.util.ArrayList;

import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;


/**
 * <p>
 * SelectValue Component is a TextField that asynchronously displays a drop down 
 * with valid values (such as addresses) that match what you typed based on a 
 * method look up on the server side. 
 * Component can be initialized to previous value and would typically be 
 * bound to model data,(like a standard <h:inputText>). Component defines a  
 * method binding <code>itemsMethod</code> that resolves to a method (on the model 
 * bean) that takes <code>FacesContext</code>, String as parameters and returns 
 * an array of <code>javax.faces.model.SelectItem</code> instances. Client side 
 * JavaScript renders the results of this search as a drop down.
 * list.
 * </p>
 * @author Jayashri Visvanathan
*/
public class SelectValueComponent extends HtmlInputText {
    
    /* 
     * A valid MethodBinding that points to a method in the
     * backing bean that takes FacesContext, String as parameters and
     * returns an array of javax.faces.model.SelectItem.
     */
    private MethodBinding itemsMethod;
    
    public SelectValueComponent() {
        super();
        setRendererType("com.sun.j2ee.blueprints.ui.selectvalue.SelectValue");
    }

    public String getFamily() {
        return "com.sun.j2ee.blueprints.ui.selectvalue.SelectValue";
    }
    

    public Object saveState(FacesContext context) {
        Object[] values = new Object[4];
        values[0] = super.saveState(context);
        values[1] = saveAttachedState(context, itemsMethod);

        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.itemsMethod = (MethodBinding) restoreAttachedState(context, 
                values[1]);
    }

    public void setItemsMethod(MethodBinding itemsMethod) {
        this.itemsMethod = itemsMethod;
    }

    public MethodBinding getItemsMethod() {
        return itemsMethod;
    }

}
