/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: SelectValueHandler.java,v 1.4 2006/04/06 08:16:24 mattbohm Exp $
 */

package com.sun.j2ee.blueprints.ui.selectvalue;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.MethodBinding;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpServletResponse;
import org.apache.shale.remoting.faces.ResponseFactory;

/**
 * <p>AJAX event handler(s) for {@link SelectValueComponent}.</p>
 */
public class SelectValueHandler {
    
    public SelectValueHandler() {
        super();
    }

    // -------------------------------------------------------- Static Variables

    /**
     * <p>Factory for response writers that we can use to construct the
     * outgoing response.</p>
     */
    private static ResponseFactory factory = new ResponseFactory();


    // -------------------------------------------------------------- Properties


    /**
     * <p>The method binding expression of the application method we
     * should delegate to.</p>
     */
    private String method = null;


    /**
     * <p>Return the method binding expression we should delegate to.</p>
     */
    public String getMethod() {
        return this.method;
    }


    /**
     * <p>Set the method binding expressino we should delegate to.</p>
     *
     * @param method The new method binding expression
     */
    public void setMethod(String method) {
        this.method = method;
    }


    /**
     * <p>value of the SelectValue TextField.</p>
     */
    private String value = null;


    /**
     * <p>Return the value of the SelectValue TextField.</p>
     */
    public String getValue() {
        return this.value;
    }


    /**
     * <p>Set the value of the SelectValue TextField.</p>
     *
     * @param value value to be matched
     */
    public void setValue(String value) {
        this.value = value;
    }


    // ---------------------------------------------------------- Public Methods


    /**
     * <p>Respond to an asynchronous request for completions that
     * match the specified prefix.</p>
     */
    public void matchValue() throws IOException {

        // Extract request parameters we are interested in
        String methodExpr = getMethod();
        String selectValue = getValue();
        // Construct and invoke method binding that will call the
        // application method
        FacesContext context = FacesContext.getCurrentInstance();
            
        Class[] argTypes = { FacesContext.class, String.class};
        MethodBinding vb = context.getApplication().
                createMethodBinding(methodExpr, argTypes);         
        Object[] args = { context, selectValue};
        SelectItem[] results = (SelectItem[])vb.invoke(context, args);
        
         //temp fix until shale-remoting allows the no-cache setting
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        response.setHeader("Pragma", "No-Cache");
        response.setHeader("Cache-Control", "no-cache,no-store,max-age=0");
        response.setDateHeader("Expires", 1);

        // Acquire a response containing these results
        ResponseWriter writer = factory.getResponseWriter(context, "text/xml");
       
        // PENDING (jayashri) make max results returned configurable.
        // Default is unlimited.
        writer.startDocument();
        writer.startElement("items", null);
        if ( results != null) {
            int i = 0;
            while (i < results.length) {
                SelectItem item = results[i];
                if (item != null) {
                    writer.startElement("item", null);


                    if (item.getValue() != null) {
                        writer.startElement("value", null);
                        writer.writeText(item.getValue().toString(), null);
                        writer.endElement("value");
                    }

                    if ( item.getLabel() != null ) {
                        writer.startElement("label", null);
                        writer.writeText(item.getLabel(), null);
                        writer.endElement("label");
                    }

                    if ( item.getDescription() != null ) {
                        writer.startElement("description", null);
                        writer.writeText(item.getDescription(), null);
                        writer.endElement("description");
                    } 
                    writer.endElement("item");
                }
                ++i;
            }
        }
        writer.endElement("items");
        writer.write("\n");
        writer.endDocument();
        writer.flush();
    }


}
