/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: SelectValuePhaseListener.java,v 1.6 2006/01/19 20:01:43 craig_mcc Exp $
 */

package com.sun.j2ee.blueprints.ui.selectvalue;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.faces.model.SelectItem;


public class SelectValuePhaseListener implements PhaseListener {
    
    private static final String SELECTVALUE_VIEW_ID = "ajax-selectvalue";
  
    public SelectValuePhaseListener() {
    }
    
    public void afterPhase(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        String rootId = context.getViewRoot().getViewId();
        if (rootId.indexOf(SELECTVALUE_VIEW_ID) != -1) {
            handleAjaxRequest(event);           
        } 
    }
     
    private void handleAjaxRequest(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        HttpServletResponse response =
            (HttpServletResponse)context.getExternalContext().getResponse();

        Object object = context.getExternalContext().getRequest();

        if (!(object instanceof HttpServletRequest)) {
            // PortletRequest? Handle that here?
            return;
        }
        
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String method = (String) requestMap.get("itemsmethod");
        String value = (String) requestMap.get("selectvalue");
        
        StringBuffer sb = new StringBuffer();
        try {
            SelectItem[] results = getItems(context, method, value);
            if ( results == null) {
                // do we need to return anything if size is 0 ?
                response.setStatus(HttpServletResponse.SC_NO_CONTENT);
                return;
            }
            
            // PENDING (jayashri) make max results returned configurable.
            // Default is unlimited.
            sb.append("<items>");
            int i = 0;
            while (i < results.length) {
                sb.append("<item>");
                SelectItem item = results[i];
                
                sb.append("<value>");
                if (item.getValue() != null) {
                    sb.append(item.getValue().toString());
                }
                sb.append("</value>");
                
                sb.append("<label>");
                sb.append(item.getLabel());
                sb.append("</label>");
                
                sb.append("<description>");
                sb.append(item.getDescription());
                sb.append("</description>");
                
                sb.append("</item>");
                ++i;
            }
            sb.append("</items>");

            response.setContentType("text/xml");
            response.setHeader("Cache-Control", "no-cache");
            response.getWriter().write(sb.toString());
            event.getFacesContext().responseComplete();
            return;
        } catch (EvaluationException ee) {
            // log(ee.toString());
            ee.printStackTrace();
        } catch (IOException ioe) {
            // log(ioe.toString());
            ioe.printStackTrace();
        }
    }
    
    /**
     * Executes the user/component-specified method in the backing bean and
     * returns the results.
     */
    private SelectItem[] getItems(FacesContext context, String methodExpr,
        String selectValue) {
        // Find the user/component-specified method and invoke it. That
        // method should return an array of SelectItem instances
        if (methodExpr == null) {
            return null;
        }
        if (UIComponentTag.isValueReference(methodExpr)) {
            Class[] argTypes = { FacesContext.class, String.class};
            MethodBinding vb = context.getApplication().createMethodBinding(methodExpr, argTypes);         
            Object[] args = { context, selectValue};
            SelectItem[] result = (SelectItem[])vb.invoke(context, args);
            return result;
        } else {
            // FIXME - localize this
            throw new FacesException("Method binding expression '" + methodExpr +
                    "' is not an expression");
        }
    }
    
    public void beforePhase(PhaseEvent event) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }
    
    public static ClassLoader getCurrentLoader(Object fallbackClass) {
        ClassLoader loader =
            Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return loader;
    }
}