/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: SelectValueTag.java,v 1.4 2006/01/19 20:01:44 craig_mcc Exp $
 */

package com.sun.j2ee.blueprints.ui.selectvalue;

import com.sun.j2ee.blueprints.ui.util.AbstractEditableValueHolderUIComponentTag;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.ValueChangeEvent;
import javax.faces.webapp.UIComponentTag;

public class SelectValueTag extends AbstractEditableValueHolderUIComponentTag {
    
    /**
     * <p>The parameter signature for the completion method.</p>
     */
    private static Class[] itemsMethodArgs = { 
       FacesContext.class, String.class 
    };

    private String accesskey;
    public void setAccesskey(String accesskey) {
        this.accesskey = accesskey;
    }

    private String alt;
    public void setAlt(String alt) {
        this.alt = alt;
    }

    private String itemsMethod;
    public void setitemsMethod(String itemsMethod) {
        this.itemsMethod = itemsMethod;
    }
    
    private String dir;
    public void setDir(String dir) {
        this.dir = dir;
    }

    private String disabled;
    public void setDisabled(String disabled) {
        this.disabled = disabled;
    }

    private String lang;
    public void setLang(String lang) {
        this.lang = lang;
    }

    private String maxlength;
    public void setMaxlength(String maxlength) {
        this.maxlength = maxlength;
    }

    private String onblur;
    public void setOnblur(String onblur) {
        this.onblur = onblur;
    }

    private String onchange;
    public void setOnchange(String onchange) {
        this.onchange = onchange;
    }

    private String onclick;
    public void setOnclick(String onclick) {
        this.onclick = onclick;
    }

    private String ondblclick;
    public void setOndblclick(String ondblclick) {
        this.ondblclick = ondblclick;
    }

    private String onfocus;
    public void setOnfocus(String onfocus) {
        this.onfocus = onfocus;
    }

    private String onkeydown;
    public void setOnkeydown(String onkeydown) {
        this.onkeydown = onkeydown;
    }

    private String onkeypress;
    public void setOnkeypress(String onkeypress) {
        this.onkeypress = onkeypress;
    }

    private String onkeyup;
    public void setOnkeyup(String onkeyup) {
        this.onkeyup = onkeyup;
    }

    private String onmousedown;
    public void setOnmousedown(String onmousedown) {
        this.onmousedown = onmousedown;
    }

    private String onmousemove;
    public void setOnmousemove(String onmousemove) {
        this.onmousemove = onmousemove;
    }

    private String onmouseout;
    public void setOnmouseout(String onmouseout) {
        this.onmouseout = onmouseout;
    }

    private String onmouseover;
    public void setOnmouseover(String onmouseover) {
        this.onmouseover = onmouseover;
    }

    private String onmouseup;
    public void setOnmouseup(String onmouseup) {
        this.onmouseup = onmouseup;
    }

    private String onselect;
    public void setOnselect(String onselect) {
        this.onselect = onselect;
    }

    private String readonly;
    public void setReadonly(String readonly) {
        this.readonly = readonly;
    }

    private String size;
    public void setSize(String size) {
        this.size = size;
    }

    private String tabindex;
    public void setTabindex(String tabindex) {
        this.tabindex = tabindex;
    }
 
    // -------------------------------------------------- UIComponentTag Methods


    /**
     * Gets the type of the component associated wit hthe tag.
     * @return the name of the component type
     */
    public String getComponentType() {
        return "com.sun.j2ee.blueprints.ui.selectvalue.SelectValue";
    }

    /**
     * Gets the type of the renderer that will render this tag.
     * @return the type of the renderer that renders this tag
     */
    public String getRendererType() {
        return "com.sun.j2ee.blueprints.ui.selectvalue.SelectValue";
    }

    /**
     * Releases resources allocated during the execution of this tag handler.
     */
    public void release() {

        super.release();
        this.accesskey = null;
        this.alt = null;
        this.itemsMethod = null;
        this.dir = null;
        this.disabled = null;
        this.lang = null;
        this.maxlength = null;
        this.onblur = null;
        this.onchange = null;
        this.onclick = null;
        this.ondblclick = null;
        this.onfocus = null;
        this.onkeydown = null;
        this.onkeypress = null;
        this.onkeyup = null;
        this.onmousedown = null;
        this.onmousemove = null;
        this.onmouseout = null;
        this.onmouseover = null;
        this.onmouseup = null;
        this.onselect = null;
        this.readonly = null;
        this.size = null;
        this.tabindex = null;

    }

    /**
     * Sets the properties of the specified component.
     * @param component the component associated with this tag
     */
    protected void setProperties(UIComponent component) {

        super.setProperties(component);
        configureString(component, "accesskey", accesskey);
        configureString(component, "alt", alt);      
        configureString(component, "dir", dir);
        configureBoolean(component, "disabled", disabled);
        configureString(component, "lang", lang);
        configureInteger(component, "maxlength", maxlength);
        configureString(component, "onblur", onblur);
        configureString(component, "onchange", onchange);
        configureString(component, "onclick", onclick);
        configureString(component, "ondblclick", ondblclick);
        configureString(component, "onfocus", onfocus);
        configureString(component, "onkeydown", onkeydown);
        configureString(component, "onkeypress", onkeypress);
        configureString(component, "onkeyup", onkeyup);
        configureString(component, "onmousedown", onmousedown);
        configureString(component, "onmousemove", onmousemove);
        configureString(component, "onmouseout", onmouseout);
        configureString(component, "onmouseover", onmouseover);
        configureString(component, "onmouseup", onmouseup);
        configureString(component, "onselect", onselect);
        configureBoolean(component, "readonly", readonly);
        configureInteger(component, "size", size);
        configureInteger(component, "tabindex", tabindex);

        if (itemsMethod != null) {
            if (isValueReference(itemsMethod)) {
                MethodBinding mb = getFacesContext().getApplication().
                        createMethodBinding(itemsMethod, itemsMethodArgs);
                ((SelectValueComponent) component).setItemsMethod(mb);
            } else {
                throw new IllegalArgumentException(itemsMethod);
            }
        }

    }
}
