/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: SelectValueUtil.java,v 1.2 2006/01/19 20:01:44 craig_mcc Exp $
 */

package com.sun.j2ee.blueprints.ui.selectvalue;

import javax.faces.model.SelectItem;
import javax.faces.context.FacesContext;

/**
 * Interface implemented by classes that look up a service and return an array
 * an array of SelectItem based on the result.
 */
public interface SelectValueUtil {
    /** This method is called asynchronously from client javascript calls;
     *
     * @param context The faces context for the JSF application
     * @param value value to look up
     * @return array of SelectItem based on look up.
     */
    public SelectItem[] matchValue(FacesContext context, String value); 

}
