/*
 * $Id: BuyNowComponent.java,v 1.8 2006/03/25 01:21:38 jayashri Exp $
 */

/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: BuyNowComponent.java,v 1.8 2006/03/25 01:21:38 jayashri Exp $
 */

package com.sun.j2ee.blueprints.ui.shopping;

import javax.faces.component.html.HtmlCommandButton;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.el.MethodBinding;
import java.math.BigDecimal;

/**
 * <p>BuyNowComponent allows you to sell individual items through PayPal.This 
 * component supports all the attributes that are commonly posted to PayPal
 * to complete a transaction as properties on the component.Rest of the attributes
 * can be specified through postData which is a value binding expression that
 * resolves to a BuyNowPostData bean.
 * </p>
 **/
public class BuyNowComponent extends HtmlCommandButton {
    
    /**
     * <p>The standard component family for this component.</p>
     */
    public static final String COMPONENT_FAMILY = "com.sun.j2ee.blueprints.ui.shopping.BuyNow";  //NOI18N
    
    /**
     * <p>The standard renderer type for this component.</p>
     */
    public static final String RENDERER_TYPE = "com.sun.j2ee.blueprints.ui.shopping.BuyNow";  //NOI18N
    private boolean itemQtySet = false;
    
    // --------------------------------------------------------------Constructors
    
    public BuyNowComponent() {
        super();
        setRendererType(RENDERER_TYPE);
    }
    
    
    // -------------------------------------------------------------- Properties
    
    /**
     * <p>Return the component family for this component.</p>
     */
    public String getFamily() {
        return (COMPONENT_FAMILY);
    }
    
    private String style = null;
    
    /**
     * <p>CSS style(s) to be applied when this component is rendered.</p>
     */
    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueBinding vb = getValueBinding("style"); //NOI18N
        if (vb != null) {
            return (String) vb.getValue(getFacesContext());
        }
        return null;
    }
    
    /**
     * <p>CSS style(s) to be applied when this component is rendered.</p>
     * @see #getStyle()
     */
    public void setStyle(String style) {
        this.style = style;
    }
    
    private String styleClass = null;
    
    /**
     * <p>CSS style class(es) to be applied when this component is rendered.</p>
     */
    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        ValueBinding vb = getValueBinding("styleClass");  //NOI18N
        if (vb != null) {
            return (String) vb.getValue(getFacesContext());
        }
        return null;
    }
    
    /**
     * <p>CSS style class(es) to be applied when this component is rendered.</p>
     * @see #getStyleClass()
     */
    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }
    
    private String business = null;
    
    /**
     * Returns the email address of the Seller's PayPal account
     * PayPal Attribute Name: business
     */
    public String getBusiness() {
        if (this.business != null) {
            return this.business;
        }
        ValueBinding vb = getValueBinding("business");  //NOI18N
        if (vb != null) {
            return (String) vb.getValue(getFacesContext());
        }
        return null;
    }
    
    /**
     * Sets the email address of the Seller's PayPal account
     * PayPal Attribute Name: business
     */
    public void setBusiness(String business) {
        this.business = business;
    }
    
    private String postBackUrl = null;
    /**
     * Returns the value of url to which PayPal posts information about the 
     * transaction.
     * PayPal Attribute Name: notify_url
     */
    public String getPostBackUrl() {
        if (this.postBackUrl != null) {
            return this.postBackUrl;
        }
        ValueBinding vb = getValueBinding("postBackUrl");  //NOI18N
        if (vb != null) {
            return (String) vb.getValue(getFacesContext());
        }
        return null;
    }
    
    /**
     * Sets the value of url to which PayPal posts information about the 
     * transaction.
     * PayPal Attribute Name: notify_url
     */
    public void setPostBackUrl(String postBackUrl) {
        this.postBackUrl = postBackUrl;
    }
    
    private BigDecimal amount = null;
    /*
     * Returns the price of the item.
     * PayPal Attribute Name: amount
     **/
    public BigDecimal getAmount() {
        if (this.amount != null ) {
            return this.amount;
        }
        ValueBinding vb = getValueBinding("amount"); //NOI18N
        if (vb != null) {
            return ((BigDecimal)vb.getValue(getFacesContext()));
        }
        return amount;
    }
    
    /*
     * Sets the price of the item.
     * PayPal Attribute Name: amount
     **/
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }
    
    private String itemName = null;
    /**
     * Returns the name of the item
     * PayPal Attribute Name: item_name
     */
    public String getItemName() {
        if (this.itemName != null) {
            return this.itemName;
        }
        ValueBinding vb = getValueBinding("itemName");  //NOI18N
        if (vb != null) {
            return (String) vb.getValue(getFacesContext());
        }
        return null;
    }
    
    /**
     * Sets the name of the item
     * PayPal Attribute Name: item_name
     */
    public void setItemName(String itemName) {
        this.itemName = itemName;
    }
    
    private int quantity = Integer.MIN_VALUE;
    /**
     * Returns the number of items.
     * PayPal Attribute Name: quantity
     */
    public int getQuantity() {
        if (this.itemQtySet) {
            return this.quantity;
        }
        ValueBinding vb = getValueBinding("quantity"); //NOI18N
        if (vb != null) {
            return ((Integer)vb.getValue(getFacesContext())).intValue();
        }
        return quantity;
    }
    
    /**
     * Sets the number of items.
     * PayPal Attribute Name: quantity
     */
    public void setQuantity(int itemQuantity) {
        quantity = itemQuantity;
        this.itemQtySet = true;
    }
    
    private String paymentCancelledUrl = null;
    
    /**
     * Returns the URL to which customer's browser is returned if payment is 
     * cancelled.
     * PayPal Attribute Name: cancel_return
     */
    public String getPaymentCancelledUrl() {
        if (this.paymentCancelledUrl != null) {
            return this.paymentCancelledUrl;
        }
        ValueBinding vb = getValueBinding("paymentCancelledUrl");  //NOI18N
        if (vb != null) {
            return (String) vb.getValue(getFacesContext());
        }
        return null;
    }
    
   /**
     * Sets the URL to which customer's browser is returned if payment is 
     * cancelled.
     * PayPal Attribute Name: cancel_return
     */
    public void setPaymentCancelledUrl(String paymentCancelledUrl) {
        this.paymentCancelledUrl = paymentCancelledUrl;
    }
    
     private String imageUrl = null;
     
    
    /**
     * Returns the value of URL of the 150x50-pixel image displayed as your 
     * logo in PayPal Page.
     * PayPal Attribute Name: image_url
     */
     public String getImageUrl() {
        if (this.imageUrl != null) {
            return this.imageUrl;
        }
        ValueBinding vb = getValueBinding("imageUrl");  //NOI18N
        if (vb != null) {
            return (String) vb.getValue(getFacesContext());
        }
        return null;
    }
    
    /**
     * Sets the value of URL of the 150x50-pixel image displayed as your 
     * logo in PayPal Page.
     * PayPal Attribute Name: image_url
     */
    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }
    
    private String returnUrl = null;
     
   /**
     * Returns the URL to which customer's browser will be returned after c
     * completing payment.
     * PayPal Attribute Name: return_url
     */
     public String getReturnUrl() {
        if (this.returnUrl != null) {
            return this.returnUrl;
        }
        ValueBinding vb = getValueBinding("returnUrl");  //NOI18N
        if (vb != null) {
            return (String) vb.getValue(getFacesContext());
        }
        return null;
    }
    
    /**
     * Sets the value of URL to which customer's browser will be returned 
     * after completing payment..
     * PayPal Attribute Name: return_url
     */
    public void setReturnUrl(String return_url) {
        this.returnUrl = return_url;
    }
    
    private String image = null;
     
    /**
     * <p>Sets the image that will be displayed instead of the default PayPal
     * BuyNow button Image.
     */
     public String getImage() {
        if (this.image != null) {
            return this.image;
        }
        ValueBinding vb = getValueBinding("image");  //NOI18N
        if (vb != null) {
            return (String) vb.getValue(getFacesContext());
        }
        return null;
    }
    
    /**
     * <p>Sets the image that will be displayed instead of the default PayPal
     * BuyNow button Image.
     */
    public void setImage(String image) {
        this.image = image;
    }
    
    private BuyNowPostData postData = null;
    /**
     * <p>Returns the value of postData support bean through additional attributes
     * for a particular transaction can be posted..
     */
    public BuyNowPostData getPostData() {
        if (this.postData != null) {
            return this.postData;
        }
        ValueBinding _vb = getValueBinding("postData");
        if (_vb != null) {
            return (BuyNowPostData) _vb.getValue(getFacesContext());
        } else {
            return null;
        }
    }
    
    /**
     * <p>Sets the value of postData support bean through additional attributes
     * for a particular transaction can be posted..
     */
    public void setPostData(BuyNowPostData postData) {
        this.postData = postData;
    }
    
    private String target = null;
     
    /**
     * <p>Returns the target window for the transaction.
     * Possible values are: <code>_self</code>, <code>_top</code>, 
     * <code>_blank</code>, <code>_parent</code>
     */
     public String getTarget() {
        if (this.target != null) {
            return this.target;
        }
        ValueBinding vb = getValueBinding("target");  //NOI18N
        if (vb != null) {
            return (String) vb.getValue(getFacesContext());
        }
        return null;
    }
    
    /**
     * <p>Sets the target window for the transaction.
     * Possible values are: <code>_self</code>, <code>_top</code>, 
     * <code>_blank</code>, <code>_parent</code>
     */
    public void setTarget(String target) {
        this.target = target;
    }
    
    private String type = null;
     
   /**
     * <p>Returns the type of PayPal button.
     * Possible values are: <code>BuyNow</code>, <code>Donation</code>. 
     * Not case sensitive.
     */
     public String getType() {
        if (this.type != null) {
            return this.type;
        }
        ValueBinding vb = getValueBinding("type");  //NOI18N
        if (vb != null) {
            return (String) vb.getValue(getFacesContext());
        }
        return null;
    }
    
    /**
     * <p>Sets the target window for the transaction.
     * Possible values are: <code>_self</code>, <code>_top</code>, 
     * <code>_blank</code>, <code>_parent</code>
     */
    public void setType(String type) {
        this.type = type;
    }
    
    private boolean testMode;
    private boolean testModeSet;
    
    /**
     * Returns the mode under which the transaction of being performed.
     * By default the transaction will be posted to sandbox.
     */
    public boolean isTestMode() {
        if (this.testModeSet) {
            return this.testMode;
        }
        ValueBinding _vb = getValueBinding("testMode");
        if (_vb != null) {
            Object _result = _vb.getValue(getFacesContext());
            if (_result == null) {
                return false;
            } else {
                return ((Boolean) _result).booleanValue();
            }
        }
        return true;
    }
    
    /**
     * Sets the mode under which the transaction of being performed.
     * By default the transaction will be posted to sandbox.
     */
    public void setTestMode(boolean mode) {
        this.testMode = mode;
        this.testModeSet = true;
    }
    
    
    // ----------------------------------------------------- StateHolder Methods
    /**
     * <p>Saves the state of this component.
     */
    public Object saveState(FacesContext context) {
        Object values[] = new Object[13];
        values[0] = super.saveState(context);
        values[1] = this.amount;
        values[2] = this.business;
        values[3] = this.paymentCancelledUrl;
        values[4] = this.imageUrl;
        values[5] = this.itemName;
        values[6] = new Integer(quantity);
        values[7] = this.postBackUrl;
        values[8] = this.style;
        values[9] = this.styleClass;
        values[10] = this.itemQtySet ? Boolean.TRUE : Boolean.FALSE;
        values[11] = this.target;
        values[12] = this.type;
        
        return (values);
    }
    
    /**
     * <p>Return the state to be saved for this component.
     */
    public void restoreState(FacesContext context, Object state) {
        Object values[] = (Object[]) state;
        super.restoreState(context, values[0]);
        this.amount = (BigDecimal)values[1];
        this.business = (String) values[2];
        this.paymentCancelledUrl = (String)values[3];
        this.imageUrl = (String)values[4];
        this.itemName = (String)values[5];
        this.quantity = ((Integer)values[6]).intValue();
        this.postBackUrl = (String)values[7];
        this.style = (String)values[8];
        this.styleClass = (String)values[9];
        this.itemQtySet = Boolean.TRUE.equals(values[10]);
        this.target = (String)values[11];
        this.type = (String)values[12];
    }
}
