/*
 * $Id: BuyNowLinkRenderer.java,v 1.1 2006/04/20 01:20:27 jayashri Exp $
 */

/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: BuyNowLinkRenderer.java,v 1.1 2006/04/20 01:20:27 jayashri Exp $
 */

package com.sun.j2ee.blueprints.ui.shopping;


import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.FacesException;

import java.io.IOException;

import com.sun.j2ee.blueprints.ui.util.Util;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.servlet.http.HttpServletResponse;

import java.util.HashMap;

import com.sun.j2ee.blueprints.ui.util.BaseRenderer;
import java.beans.Beans;
import java.beans.PropertyDescriptor;
import java.beans.Introspector;
import java.beans.IntrospectionException;
import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;
import javax.faces.el.ValueBinding;


/**
 * This renderer generates the appropriate markup to render BuyNowComponent
 * as a HyperLink.
 */

public class BuyNowLinkRenderer extends BuyNowRenderer {
  

    public void encodeEnd(FacesContext context, UIComponent component)
    throws IOException {
        
        ResponseWriter writer = context.getResponseWriter();  
        
        BuyNowComponent comp = (BuyNowComponent) component;
        // during design time, just render the image.
        if (Beans.isDesignTime()) {
            renderImage(context, comp);
            return;
        }
                
        writer.startElement("a", comp);        
        String id = component.getClientId(context);
        writer.writeAttribute("id", id, "id");
        writer.writeAttribute("name", id, "id");
        
      
        // gather post data for the transaction.
        StringBuffer sb = new StringBuffer();       
        // if running in the test mode, direct the post to sandbox.
        if (comp.isTestMode()) {
            sb.append("https://www.sandbox.paypal.com/cgi-bin/webscr?");
        } else {
           sb.append("https://www.paypal.com/cgi-bin/webscr?");
        }
        
        sb = renderPostAttributes(context, comp, sb);        
       
        // Post attributes to PayPal as url parameters
        writer.writeAttribute("href", (sb.toString()), "href");
        
        // render style class if set
        String styleClass = (String)component.getAttributes().get("styleClass");
        if (null != styleClass) {
            writer.writeAttribute("class", styleClass, "styleClass");
        }
        
        String style = (String)component.getAttributes().get("style");
        if (style != null) {
            writer.writeAttribute("style", style, "style");
        }
        
        renderBooleanPassThruAttributes(writer, comp);  
        renderPassThruAttributes(writer, component);
         
        renderImage(context, comp);
        writer.endElement("a");
    }
        
    /**
     * Renders attributes that need to be posted to Pay Pal as a url parameter.
     * This method handles all the attributes that are specified on the component
     * as well as BuyNowPostData bean.
     * @param context <code>FacesContext</code> for the current request
     * @param comp BuyNowComponent thats bring rendered by this renderer.
     */
    private StringBuffer renderPostAttributes(FacesContext context, 
            BuyNowComponent comp, StringBuffer sb) throws IOException {
        Object attr_obj = null;
        String attr_value = "";
       
        sb.append("cmd=_xclick");     
        for (int i = 0; i < buyNowCompAttrs.length; ++i) {
            attr_obj = comp.getAttributes().get(buyNowCompAttrs[i][0]);            
            if (attr_obj != null) {
                attr_value = attr_obj.toString();
                // URL encode attribute values if needed.
                String result = urlEncodeIfNecessary(buyNowCompAttrs[i][1], 
                        attr_value, context);
                if ( result != null) {
                    sb.append("&"); 
                    sb.append(buyNowCompAttrs[i][1]);
                    sb.append("="); 
                    sb.append(result);
                } else {
                    if (this.shouldRenderAttribute(attr_obj)) {
                        sb.append("&"); 
                        sb.append(buyNowCompAttrs[i][1]);
                        sb.append("="); 
                        sb.append(attr_value);
                    }
                }
            }
        }        
       
        // render data specified as part of BuyNowPostData Bean.        
        BuyNowPostData postData = comp.getPostData();
        if (postData != null) {
            PropertyDescriptor pd[] = this.getPropertyDescriptors();
            if (pd != null && pd.length > 0) {
                for (int i = 0; i < pd.length; i++) {
                    attr_value = getPostAttributeValue(postData, pd[i]);  
                    if (attr_value != null) {
                        String payPalName = (String)
                                this.buyNowBeanAttrs.get(pd[i].getName());
                        sb.append("&"); 
                        sb.append(payPalName);
                        sb.append("="); 
                        sb.append(attr_value);
                    }
                }
            }
        }
        return sb;       
    } 
        
    /**
     * Renders the image for the hyperlink.
     * @param context <code>FacesContext</code> for the current request
     * @param comp BuyNowComponent thats bring rendered by this renderer.
     */
    private void renderImage(FacesContext context, BuyNowComponent comp) 
        throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String button_image = (String)comp.getAttributes().get("image");
        
        // during design time, render style and style class on the image because
        // we don't render a link during design time.
        writer.startElement("img", comp);    
        if (Beans.isDesignTime()) {
            String styleClass = (String)comp.getAttributes().get("styleClass");
            if (null != styleClass) {
                writer.writeAttribute("class", styleClass, "styleClass");
            }

            String style = (String)comp.getAttributes().get("style");
            if (style != null) {
               writer.writeAttribute("style", style, "style");
            }   
        }
        
        String type = comp.getType();
        if (button_image == null || button_image.length() == 0) {            
            if ( type != null && type.equalsIgnoreCase("Donation")) {
                if (Beans.isDesignTime()) {
                    button_image = BuyNowRenderer.class.getResource(DONATION_IMAGE_DESIGN_TIME).toString();
                } else {
                     button_image = DONATION_IMAGE_RUN_TIME;
                }
            } else {
                if (Beans.isDesignTime()) {
                    button_image = BuyNowRenderer.class.getResource(BUYNOW_IMAGE_DESIGN_TIME).toString();
                } else {
                    button_image = BUYNOW_IMAGE_RUN_TIME;
                }
            }
            writer.writeURIAttribute("src", button_image, "src");
        } else {
            writer.writeURIAttribute("src", src(context, button_image), "src");       
        }
        
        // if "alt" is not specified, render type as alt.
        String alt = (String)comp.getAttributes().get("alt");
        if (alt == null) {
           writer.writeAttribute("alt", type, "alt");
        }
        writer.endElement("img");
       
    } 
}
