/*
 * $Id: BuyNowPostData.java,v 1.5 2006/08/11 21:37:38 jayashri Exp $
 */

/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: BuyNowPostData.java,v 1.5 2006/08/11 21:37:38 jayashri Exp $
 */

package com.sun.j2ee.blueprints.ui.shopping;

import java.io.Serializable;
import java.math.BigDecimal;

public class BuyNowPostData implements Serializable{
    
    /** Creates a new instance of BuyNowPostData */
    public BuyNowPostData() {
    }
    
    private String itemNumber = null;
    private String undefinedQuantity = null;
    private String firstOptionFieldName = null;
    private String secondOptionFieldName = null;
    private String continueLabel = null;
    private String noteFieldLabel = null;
    private String paymentPageHeaderImage = null;
    private String headerBgColor = null;
    private String headerBorderColor = null;
    private String headerPayFlowColor = null;
    private String paymentPageBgColor = null;
    private String promptPaymentNote = null;
    private String promptShippingAddress = null;
    private String pageStyle = null;
    private String submissionMethod = null;
    private String currencyCode = null;
    private BigDecimal handlingCost = null;
    private String invoiceNumber = null;
    private BigDecimal shippingCost = null;
    private BigDecimal additionalItemShippingCost =null;
    private BigDecimal tax = null;
    
    private String firstOptionFieldValue = null;
    private String secondOptionFieldValue = null;

    /**
     * Returns the value of itemNumber. This is a passthrough variable for you
     * to track purchases or donations,passed back to you at payment completion.
     */
    public String getItemNumber() {
        return itemNumber;
    }

    /**
     * Sets the value of itemNumber. This is a passthrough variable for you
     * to track purchases or donations,passed back to you at payment completion.
     * Passing a non null value to this method will cause the field to be posted
     * to PayPal.
     * This property is an alias for Pay Pal attribute <code>item_number</code>.
     */
    public void setItemNumber(String itemNumber) {
        this.itemNumber = itemNumber;
    }

    /**
     * Returns whether to allows buyer to specify the quantity. 
     * This property is an alias for Pay Pal attribute <code>undefined_quantity</code>.
     */
    public String getUndefinedQuantity() {
        return undefinedQuantity;
    }

    /**
     * Sets whether to allows buyer to specify the quantity. 
     * This property is an alias for Pay Pal attribute <code>undefined_quantity</code>.
     * Passing a non null value to this method will cause the field to be posted
     * to PayPal.
     */
    public void setUndefinedQuantity(String undefinedQuantity) {
        this.undefinedQuantity = undefinedQuantity;
    }

    /**
     * Returns first option field name. If omitted, no variable is passed back to you. 
     * This property is an alias for Pay Pal attribute <code>on0</code>.
     */
    public String getFirstOptionFieldName() {
        return firstOptionFieldName;
    }

    /**
     * Sets the first option field name. If omitted, no variable is passed back to you. 
     * This property is an alias for Pay Pal attribute <code>on0</code>.
     */
    public void setFirstOptionFieldName(String firstOptionFieldName) {
        this.firstOptionFieldName = firstOptionFieldName;
    }

    /**
     * Returns second option field name. If omitted, no variable is passed back to you. 
     * This property is an alias for Pay Pal attribute <code>on1</code>.
     */
    public String getSecondOptionFieldName() {
        return secondOptionFieldName;
    }

    /**
     * Sets second option field name. If omitted, no variable is passed back to you. 
     * This property is an alias for Pay Pal attribute <code>on1</code>.
     */
    public void setSecondOptionFieldName(String secondOptionFieldName) {
        this.secondOptionFieldName = secondOptionFieldName;
    }

    /**
     * Returns first option field value.  This is only rendered if <code>on0</code> is set.
     * This property is an alias for Pay Pal attribute <code>os0</code>.
     */
    public String getFirstOptionFieldValue() {
        return firstOptionFieldValue;
    }

    /**
     * Sets the first option field value. This is only rendered if <code>on0</code> is set.
     * This property is an alias for Pay Pal attribute <code>os0</code>.
     */
    public void setFirstOptionFieldValue(String firstOptionFieldValue) {
        this.firstOptionFieldValue = firstOptionFieldValue;
    }

    /**
     * Returns second option field value. This is only rendered if <code>on1</code> is set.
     * This property is an alias for Pay Pal attribute <code>os1</code>.
     */
    public String getSecondOptionFieldValue() {
        return secondOptionFieldValue;
    }

    /**
     * Sets second option field value. This is only rendered if <code>on0</code> is set.
     * This property is an alias for Pay Pal attribute <code>os1</code>.
     */
    public void setSecondOptionFieldValue(String secondOptionFieldValue) {
        this.secondOptionFieldValue = secondOptionFieldValue;
    }
    /**
     * Returns the text for the Continue button on the PayPal Payment Complete page
     * This property is an alias for Pay Pal attribute <code>cbt</code>.
     */
    public String getContinueLabel() {
        return continueLabel;
    }

    /**
     * Sets the text for the Continue button on the PayPal Payment Complete page
     * This property is an alias for Pay Pal attribute <code>cbt</code>.
     */
    public void setContinueLabel(String continueLabel) {
        this.continueLabel = continueLabel;
    }

    /**
     * Returns the label above the note field.
     * This property is an alias for Pay Pal attribute <code>cn<c/ode>.
     */
    public String getNoteFieldLabel() {
        return noteFieldLabel;
    }
    
    /**
     * Sets the label above the note field.
     * This property is an alias for Pay Pal attribute <code>cn<c/ode>.
     */
    public void setNoteFieldLabel(String noteFieldLabel) {
        this.noteFieldLabel = noteFieldLabel;
    }

    /**
     * Returns the image at the top left of the payment page. 
     * Maximum size 750 pixels wide by 90 pixels high.
     * This property is an alias for Pay Pal attribute <code>cpp_header_image</code>.
     */
    public String getPaymentPageHeaderImage() {
        return paymentPageHeaderImage;
    }

    /**
     * Sets the image at the top left of the payment page. 
     * Maximum size 750 pixels wide by 90 pixels high.
     * This property is an alias for Pay Pal attribute <code>cpp_header_image</code>.
     */
    public void setPaymentPageHeaderImage(String paymentPageHeaderImage) {
        this.paymentPageHeaderImage = paymentPageHeaderImage;
    }

    /**
     * Returns the background color for the header of the payment page.
     * This property is an alias for Pay Pal attribute <code>cpp_headerback_color</code>.
     */
    public String getHeaderBgColor() {
        return headerBgColor;
    }

    /**
     * Sets the background color for the header of the payment page.
     * This property is an alias for Pay Pal attribute <code>cpp_headerback_color</code>.
     */
    public void setHeaderBgColor(String headerBgColor) {
        this.headerBgColor = headerBgColor;
    }

    /**
     * Returns the border color around the header of the payment page. 
     * This property is an alias for Pay Pal attribute <code>cpp_headerback_color</code>.
     */
    public String getHeaderBorderColor() {
        return headerBorderColor;
    }

    /**
     * Sets the border color around the header of the payment page. 
     * This property is an alias for Pay Pal attribute <code>cpp_headerborder_color</code>.
     */
    public void setHeaderBorderColor(String headerBorderColor) {
        this.headerBorderColor = headerBorderColor;
    }

    /**
     * Returns  the background color for the payment page below the header. 
     * This property is an alias for Pay Pal attribute <code>cpp_payflow_color</code>.
     */
    public String getHeaderPayFlowColor() {
        return headerPayFlowColor;
    }

    /**
     * Sets the background color for the payment page below the header. 
     * This property is an alias for Pay Pal attribute <code>cpp_payflow_color</code>.
     */
    public void setHeaderPayFlowColor(String headerPayFlowColor) {
        this.headerPayFlowColor = headerPayFlowColor;
    }

    /**
     * Returns the background color of your payment pages.
     * This property is an alias for Pay Pal attribute <code>cs<c/ode>.
     */
    public String getPaymentPageBgColor() {
        return paymentPageBgColor;
    }

    /**
     * Sets the background color of your payment pages.
     * This property is an alias for Pay Pal attribute <code>cs<c/ode>.
     */
    public void setPaymentPageBgColor(String paymentPageBgColor) {
        this.paymentPageBgColor = paymentPageBgColor;
    }

    /**
     * Returns whether to prompt customer to include a note with payment
     * This property is an alias for Pay Pal attribute <code>no_note</code>.
     */
    public String getPromptPaymentNote() {
        return promptPaymentNote;
    }

    /**
     * Sets whether to prompt customer to include a note with payment
     * This property is an alias for Pay Pal attribute <code>no_note</code>.
     * Passing a non null value to this method will cause the field to be posted
     * to PayPal.
     */
    public void setPromptPaymentNote(String promptPaymentNote) {
        this.promptPaymentNote = promptPaymentNote;
    }

    /**
     * Returns whether to prompt customer for shipping address.
     * This property is an alias for Pay Pal attribute <code>no_shipping</code>
     */
    public String getPromptShippingAddress() {
        return promptShippingAddress;
    }

    /**
     * Sets whether to prompt customer for shipping address.
     * This property is an alias for Pay Pal attribute <code>no_shipping</code>
     * Passing a non null value to this method will cause the field to be posted
     * to PayPal.
     */
    public void setPromptShippingAddress(String promptShippingAddress) {
        this.promptShippingAddress = promptShippingAddress;
    }

    /**
     * Returns the Custom Payment Page Style for payment pages associated with 
     * the BuyNow button.
     * This property is an alias for Pay Pal attribute <code>page_style</code>
     */
    public String getPageStyle() {
        return pageStyle;
    }

    /**
     * Sets the Custom Payment Page Style for payment pages associated with 
     * the BuyNow button.
     * This property is an alias for Pay Pal attribute <code>page_style</code>
     */
    public void setPageStyle(String pageStyle) {
        this.pageStyle = pageStyle;
    }

    /**
     * Returns the return method GET or POST
     * This property is an alias for Pay Pal attribute <code>rm</code>
     */
    public String getSubmissionMethod() {
        return submissionMethod;
    }

    /**
     * Sets the return method GET or POST
     * This property is an alias for Pay Pal attribute <code>rm</code>
     */
    public void setSubmissionMethod(String submissionMethod) {
        this.submissionMethod = submissionMethod;
    }

    /**
     * Returns the currency in which the monetary variables are denoted
     * This property is an alias for Pay Pal attribute <code>currency_code</code>
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /**
     * Sets the currency in which the monetary variables are denoted
     * This property is an alias for Pay Pal attribute <code>currency_code</code>
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /**
     * Returns the handling charges. This is not quantity-specific 
     * This property is an alias for Pay Pal attribute <code>handling</code>
     */
    public BigDecimal getHandlingCost() {
        return handlingCost;
    }

    /**
     * Sets the handling charges. This is not quantity-specific 
     * This property is an alias for Pay Pal attribute <code>handling</code>
     */
    public void setHandlingCost(BigDecimal handlingCost) {
        this.handlingCost = handlingCost;
    }

    /**
     * Returns the passthrough variable you can use to identify your invoice number 
     * for this purchase.
     * This property is an alias for Pay Pal attribute <code>invoice</code>
     */
    public String getInvoiceNumber() {
        return invoiceNumber;
    }

    /**
     * Sets the passthrough variable you can use to identify your invoice number 
     * for this purchase.
     * This property is an alias for Pay Pal attribute <code>invoice</code>
     */
    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    /**
     * Returns the cost of shipping an item if you have enabled item-specific 
     * shipping costs.
     * This property is an alias for Pay Pal attribute <code>shipping</code>
     */
    public BigDecimal getShippingCost() {
        return shippingCost;
    }

    /**
     * Sets the cost of shipping an item if you have enabled item-specific 
     * shipping costs.
     * This property is an alias for Pay Pal attribute <code>shipping</code>
     */
    public void setShippingCost(BigDecimal shippingCost) {
        this.shippingCost = shippingCost;
    }

    /**
     * Returns the cost of shipping each additional item.
     * This property is an alias for Pay Pal attribute <code>shipping2</code>
     */
    public BigDecimal getAdditionalItemShippingCost() {
        return additionalItemShippingCost;
    }

   /**
     * Sets the cost of shipping each additional item.
     * This property is an alias for Pay Pal attribute <code>shipping2</code>
     */
    public void setAdditionalItemShippingCost(BigDecimal additionalItemShippingCost) {
        this.additionalItemShippingCost = additionalItemShippingCost;
    }

    /**
     * Returns transaction-based tax override variable
     * This property is an alias for Pay Pal attribute <code>tax</code>
     */
    public BigDecimal getTax() {
        return tax;
    }

    /**
     * Sets transaction-based tax override variable
     * This property is an alias for Pay Pal attribute <code>tax</code>
     */
    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

}
