/*
 * $Id: BuyNowRenderer.java,v 1.12 2006/08/11 21:37:38 jayashri Exp $
 */

/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: BuyNowRenderer.java,v 1.12 2006/08/11 21:37:38 jayashri Exp $
 */

package com.sun.j2ee.blueprints.ui.shopping;


import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.FacesException;

import java.io.IOException;

import com.sun.j2ee.blueprints.ui.util.Util;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.servlet.http.HttpServletResponse;

import java.util.HashMap;

import com.sun.j2ee.blueprints.ui.util.BaseRenderer;
import java.beans.Beans;
import java.beans.PropertyDescriptor;
import java.beans.Introspector;
import java.beans.IntrospectionException;
import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;
import javax.faces.el.ValueBinding;


/**
 * This renderer generates the appropriate markup to render BuyNowComponent as a
 * button which resides in its own <code>form</code> element.
 */

public class BuyNowRenderer extends BaseRenderer {
   
    /**
     * Default image that will be rendered if an image is not specified
     */
    static final String BUYNOW_IMAGE_DESIGN_TIME = 
            "/com/sun/j2ee/blueprints/ui/shopping/BuyNow.gif";
    static final String DONATION_IMAGE_DESIGN_TIME = "" +
            "/com/sun/j2ee/blueprints/ui/shopping/Donation.gif";
    static final String BUYNOW_IMAGE_RUN_TIME = 
            "http://www.paypal.com/en_US/i/btn/x-click-but01.gif";
    static final String DONATION_IMAGE_RUN_TIME = 
            "http://www.paypal.com/en_US/i/btn/x-click-butcc-donate.gif";
    
    private static final String FORM_SUFFIX = "_form";
    private static final String IMAGE_SUFFIX = "_image";
    
    static final String DONATION_TYPE = "Donation";
    
    /**
     * A Map of attribute names supported on the BuyNowPostData bean along
     * with thier corresponding PayPal API names.
     */
    static HashMap buyNowBeanAttrs= new HashMap(25);
    static {
        buyNowBeanAttrs.put( "itemNumber", "item_number" );
        buyNowBeanAttrs.put( "undefinedQuantity", "undefined_quantity" );
        buyNowBeanAttrs.put( "itemName", "item_name");
        buyNowBeanAttrs.put( "firstOptionFieldName", "on0" );
        buyNowBeanAttrs.put( "secondOptionFieldName", "on1" );
        buyNowBeanAttrs.put( "firstOptionFieldValue", "os0" );
        buyNowBeanAttrs.put( "secondOptionFieldValue", "os1" );
        buyNowBeanAttrs.put( "continueLabel", "cbt" );
        buyNowBeanAttrs.put( "noteFieldLabel", "cn" );
        buyNowBeanAttrs.put( "paymentPageHeaderImage", "cpp_header_image" ); 
        buyNowBeanAttrs.put( "headerBgColor", "cpp_headerback_color" );
        buyNowBeanAttrs.put( "headerBorderColor", "cpp_headerborder_color" );
        buyNowBeanAttrs.put("headerPayFlowColor", "cpp_payflow_color" );
        buyNowBeanAttrs.put( "paymentPageBgColor", "cs" );
        buyNowBeanAttrs.put( "promptPaymentNote", "no_note" );
        buyNowBeanAttrs.put( "promptShippingAddress", "no_shipping" );
        buyNowBeanAttrs.put( "currencyCode", "currency_code" );
        buyNowBeanAttrs.put( "pageStyle", "page_style" );
        buyNowBeanAttrs.put( "handlingCost", "handling" );
        buyNowBeanAttrs.put( "invoiceNumber", "invoice" );
        buyNowBeanAttrs.put( "shippingCost", "shipping" );
        buyNowBeanAttrs.put( "additionalItemShippingCost", "shipping2" );
        buyNowBeanAttrs.put( "tax", "tax" );
        buyNowBeanAttrs.put( "submissionMethod", "return" );
    };

    public void encodeEnd(FacesContext context, UIComponent component)
    throws IOException {
        ResponseWriter writer = context.getResponseWriter();
           
        BuyNowComponent comp = (BuyNowComponent) component;
        // during design time, just render the image.
        if (Beans.isDesignTime()) {
            renderImage(context, comp);
            return;
        }
    
        String clientId = component.getClientId(context);
        writer.startElement("form", comp);
        writer.writeAttribute("id", (clientId + FORM_SUFFIX), "clientId");
        writer.writeAttribute("name", (clientId + FORM_SUFFIX), "name");        
        writer.writeAttribute("method", "post", null);
        
        // if running in the test mode, direct the post to sandbox.
        if (comp.isTestMode()) {
            writer.writeAttribute("action", 
                    "https://www.sandbox.paypal.com/cgi-bin/webscr",  null);
        } else {
            writer.writeAttribute("action", 
                    "https://www.paypal.com/cgi-bin/webscr", null);
        }
        // render target attribute if its set
        String target = comp.getTarget();
        if ( target != null && target.length() != 0) {
            writer.writeAttribute("target", target, "target");    
        }
        writer.write("\n");
        // render image
        renderImageButton(context, comp);
        renderPostAttributes(context, comp);
        writer.endElement("form");
    }
    
    /**
     * <p>Pay Pal attributes that must be URL encoded.</p>
     */
    static String urlAttributes[] =
    { "notify_url", "image_url","cpp_header_image"};
    
   
    /**
     * A Map of attribute names supported on the BuyNow component along
     * with thier corresponding PayPal API names.
     */
    static final String[][] buyNowCompAttrs = {
        { "business", "business" },
        { "amount", "amount" },
        { "itemName", "item_name" },
        { "quantity", "quantity" },
        { "imageUrl", "image_url" },
        { "notifyUrl", "notify_url" },
        { "paymentCancelledUrl", "cancel_return" },
        { "returnUrl", "return" }         
    };
    
    
    /**
     * Renders attributes that need to be posted to Pay Pal as a hidden field.
     * This method handles all the attributes that are specified on the component
     * as well as BuyNowPostData bean.
     * @param context <code>FacesContext</code> for the current request
     * @param comp BuyNowComponent thats bring rendered by this renderer.
     */
    private void renderPostAttributes(FacesContext context, 
            BuyNowComponent comp) throws IOException {
        Object attr_obj = null;
        String attr_value = "";
        ResponseWriter writer = context.getResponseWriter();
       
        renderHiddenField(context, writer, "cmd", "_xclick", comp);     
        for (int i = 0; i < buyNowCompAttrs.length; ++i) {
            attr_obj = comp.getAttributes().get(buyNowCompAttrs[i][0]);            
            if (attr_obj != null) {
                attr_value = attr_obj.toString();
                // URL encode attribute values if needed.
                String result = urlEncodeIfNecessary(buyNowCompAttrs[i][1], 
                        attr_value, context);
                if ( result != null) {                     
                    renderHiddenField(context, writer, buyNowCompAttrs[i][1], result, comp);
                } else {
                    if (this.shouldRenderAttribute(attr_obj)) {
                        renderHiddenField(context, writer, buyNowCompAttrs[i][1], attr_value, 
                            comp);
                    }
                }
            }
        }        
        /* Because "return" is a Java keyword, return_url serves as an alias
        // for return.
        attr_value = (String) comp.getAttributes().get("return_url");
        if (attr_value != null && attr_value.length() > 0) {
             renderHiddenField(writer, "return", attr_value, comp);
        }*/
        
        // render data specified as part of BuyNowPostData Bean.        
        BuyNowPostData postData = comp.getPostData();
        if (postData != null) {
            PropertyDescriptor pd[] = this.getPropertyDescriptors();
            if (pd != null && pd.length > 0) {
                for (int i = 0; i < pd.length; i++) {
                    attr_value = getPostAttributeValue(postData, pd[i]);  
                    if (attr_value != null) {
                        String payPalName = (String)
                                this.buyNowBeanAttrs.get(pd[i].getName());
                        /*
                         * we only want to render the value of option fields
                         * if the names are set.
                         */
                        if (payPalName.equals("os0")) {
                            if (postData.getFirstOptionFieldName() != null &&
                                    postData.getFirstOptionFieldName() != "") {
                                renderHiddenField(context, writer, payPalName, attr_value,
                                comp);
                            }
                        } else if (payPalName.equals("os1")) {
                            if (postData.getSecondOptionFieldName() != null && 
                                    postData.getSecondOptionFieldName() != "") {
                                renderHiddenField(context, writer, payPalName, attr_value,
                                comp);
                            }
                        } else {
                            renderHiddenField(context, writer, payPalName, attr_value,
                                    comp);
                        }
                    }
                }
            }
        }
    } 
    
    /**
     * Renders an image during design time.
     * @param context <code>FacesContext</code> for the current request
     * @param comp BuyNowComponent thats bring rendered by this renderer.
     */
    private void renderImage(FacesContext context, BuyNowComponent comp) 
        throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String button_image = (String)comp.getAttributes().get("image");
        
        //  during design time, render style and style class on the image because
        // we don't render a link during design time.
        writer.startElement("img", comp);              
        String styleClass = (String)comp.getAttributes().get("styleClass");
        if (null != styleClass) {
            writer.writeAttribute("class", styleClass, "styleClass");
        }

        String style = (String)comp.getAttributes().get("style");
        if (style != null) {
           writer.writeAttribute("style", style, "style");
        }    
        if (button_image == null || button_image.length() == 0) {
            String type = comp.getType();
            if ( type != null && type.equalsIgnoreCase("Donation")) {
                button_image = BuyNowRenderer.class.getResource(DONATION_IMAGE_DESIGN_TIME).toString();
            } else {
                button_image = BuyNowRenderer.class.getResource(BUYNOW_IMAGE_DESIGN_TIME).toString();
            }
            writer.writeURIAttribute("src", button_image, "src");
        } else {
            writer.writeURIAttribute("src", src(context, button_image), "src");       
        }
        writer.endElement("img");
       
    }
    
    /**
     * Renders an image button that submits data to PayPal
     * @param context <code>FacesContext</code> for the current request
     * @param comp BuyNowComponent thats bring rendered by this renderer.
     */
    private void renderImageButton(FacesContext context, BuyNowComponent comp) 
        throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String button_image = (String)comp.getAttributes().get("image");
        String clientId = comp.getClientId(context);
        writer.startElement("input", comp);
        writer.writeAttribute("id", (clientId + IMAGE_SUFFIX), "clientId");
        writer.writeAttribute("name", (clientId + IMAGE_SUFFIX), "clientId");
        writer.writeAttribute("type", "image", "type");
       
        renderPassThruAttributes(writer, comp);
        renderBooleanPassThruAttributes(writer, comp);
        
        String styleClass =(String)comp.getAttributes().get("styleClass");
        if (null != styleClass) {
            writer.writeAttribute("class", styleClass, "styleClass");
        }

        String style = (String)comp.getAttributes().get("style");
        if (style != null) {
           writer.writeAttribute("style", style, "style");
        }                   
       
        String type = comp.getType();
        if (button_image == null || button_image.length() == 0) {             
             if ( type != null && type.equalsIgnoreCase("Donation")) {
                button_image = DONATION_IMAGE_RUN_TIME;
            } else {
                button_image = BUYNOW_IMAGE_RUN_TIME;
            }
        }
        
        // if "alt" is not specified, render type as alt.
        String alt = (String)comp.getAttributes().get("alt");
        if (alt == null) {
           writer.writeAttribute("alt", type, "alt");
        }  
        
        writer.writeURIAttribute("src", src(context, button_image), "src");       
        writer.endElement("input");       
        writer.write("\n");
    }
    
    /*
     * Prepends context path to relative URLs and URL encodes the passed in url.
     * @param context 
     * @param image_url url of the resource.
     * @param context <code>FacesContext</code> for the current request
     * @return String resource url with context path prepended if its a relative
     * URL and url encoded.
     */
     protected String src(FacesContext context, String image_url) {
        String result = null;
        result = context.getApplication().getViewHandler().
            getResourceURL(context, image_url);
        return (context.getExternalContext().encodeResourceURL(result));
    }
   
     /**
      * Returns all the PropertyDescriptors of BuyNowPostData Bean.
      * @return an array of PropertyDescriptors that describe various 
      * properties of BuyNowPostData bean.
      */
    protected PropertyDescriptor[] getPropertyDescriptors() {
        PropertyDescriptor[] pd = null;
        try {
            pd = Introspector.getBeanInfo(BuyNowPostData.class).
                getPropertyDescriptors();
        } catch (IntrospectionException e) {
            throw new FacesException(e);
        }
        return (pd);
    }
    
    /**
     * Returns the value of the property represented by the passed in 
     * PropertyDescriptor.
     * @param postDataBean JavaBean that encapsulates data that needs to be
     * posted to PayPal
     * @param pd PropertyDescriptor representing a particular property of
     * postDataBean
     * @return String value of the property represened by the PropertyDescriptor.
     */
     protected String getPostAttributeValue(BuyNowPostData postDataBean, 
             PropertyDescriptor pd) {
        Object result = null;
        String value = null;
        // do not process "class" attribute, which one of the attributes 
        //returned by getPropertyDescriptors().
        if (pd == null || pd.getName().equals("class")) {
            return null;
        }   
    
        try {
            Method readMethod = pd.getReadMethod();
            if (readMethod != null) {
                result =  (readMethod.invoke
                        (postDataBean, null));
            }
        } catch (IllegalAccessException e) {
            throw new FacesException(e);
        } catch (InvocationTargetException e) {
            throw new FacesException
                (e.getTargetException());
        }
        if ( result != null && shouldRenderAttribute(result)) {
            value = result.toString();
        }
        // if the property is a pass through variable, then PayPal API only
        // expects the name of the variable to be included. So ignore the value
        // and return an empty string.
        if ( pd.getName().equals("itemNumber") || 
             pd.getName().equals("undefinedQuantity")) {
             if ( value != null) {
                 value = "";
             }
        }
        return value;       
     }
     
     /**
      * URL encodes a property value that is specified by PayPal as an
      * attribute that must be URL encoded.
      * @param propertyName property to check if it needs to be URL encoded.
      * @param value value of the property to URL encode if specified by PayPal.
      * @return String URL encoded property value or null if the property doesn't 
      * have to be URL encoded.
      */
     protected String urlEncodeIfNecessary(String propertyName, String value,
             FacesContext context) {
         for (int i = 0; i < urlAttributes.length; ++i) {
             if ( urlAttributes[i].equals(propertyName)) {
                 return (context.getExternalContext().
                         encodeResourceURL(value));
             }
         }
         return null;
     }
     
    /** 
     * Renders a given property name and value to be posted to Pay Pal
     * as a hidden field.
     * @param writer <code>ResponseWriter</code> to write the response to
     * @param propertyName Name of the property to render as hidden field
     * @param propertyValue Value of the property to render as value of the
     *                      hidden field
     */
     private void renderHiddenField(FacesContext context, ResponseWriter writer, 
             String propertyName,String propertyValue, BuyNowComponent comp) 
             throws IOException {
         String id = comp.getClientId(context);
         // use clientId  and property name to generate the id for the hidden
         // fields.
         id = id + "_" + propertyName;
         writer.startElement("input", comp);
         writer.writeAttribute("type", "hidden", "type");
         writer.writeAttribute("id", id, "id");
         //writer.writeAttribute("type", "hidden", "type");
         writer.writeAttribute("name", propertyName, "name");
         if (propertyValue != null && propertyValue.length() > 0) {
             writer.writeAttribute("value", propertyValue, "value");
         }
         writer.endElement("input");   
         writer.write("\n");
     }
    
    
}
