/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: BuyNowTag.java,v 1.6 2006/04/20 01:20:29 jayashri Exp $
 */

/*
 * $Id: BuyNowTag.java,v 1.6 2006/04/20 01:20:29 jayashri Exp $
 */

package com.sun.j2ee.blueprints.ui.shopping;

import com.sun.j2ee.blueprints.ui.util.Util;
import com.sun.j2ee.blueprints.ui.util.AbstractActionSourceUIComponentTag;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

import javax.faces.el.ValueBinding;
import javax.faces.el.MethodBinding;
import javax.faces.webapp.UIComponentTag;

import java.math.BigDecimal;


/**
 * <p><strong>BuyNowTag</strong> is the tag handler that processes the
 * <code>buynow</code> custom tag.</p>
 */

public class BuyNowTag extends AbstractActionSourceUIComponentTag {
    
    private String amount = null;
    private String business = null;
    private String returnUrl = null;
    private String imageUrl = null;
    private String itemName = null;
    private String quantity = null;
    private String postBackUrl = null;
    private String image = null;
    private String paymentCancelledUrl = null;
    private String postData = null;
    
    private String onblur = null;
    private String onclick = null;
    private String onfocus = null;
    private String onkeydown = null;
    private String onkeypress = null;
    private String onkeyup = null;
    private String onmousedown = null;
    private String onmousemove = null;
    private String onmouseout = null;
    private String onmouseover = null;
    private String onmouseup = null;
    private String tabIndex = null;   
    private String title = null;
    private String accesskey = null;
    private String dir = null;
    private String alt = null;
    private String lang = null;
    private String target = null;
    private String type = null;
    private String testMode = null;
    private String disabled = null;
    private String displayMode = null;
        
    /**
     * <p>Return the type of the component.
     */
    public String getComponentType() {
       return ("com.sun.j2ee.blueprints.ui.shopping.BuyNow"); //NOI18N              
    }
    
    
    /**
     * <p>Return the renderer type (if any)
     */
    public String getRendererType() {
        if (displayMode != null && displayMode.equalsIgnoreCase("link")) {
            return ("com.sun.j2ee.blueprints.ui.shopping.BuyNowLink"); //NOI18N
        }
        return ("com.sun.j2ee.blueprints.ui.shopping.BuyNow");
    }
   
    public void setAmount(String amount) {
        this.amount = amount;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public void setPaymentCancelledUrl(String cancelReturn) {
        this.paymentCancelledUrl = cancelReturn;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public void setQuantity(String itemQuantity) {
        this.quantity = itemQuantity;
    }

    public void setPostBackUrl(String notifyUrl) {
        this.postBackUrl = notifyUrl;
    }

    public void setImage(String image) {
        this.image = image;
    }
    
    public void setReturnUrl(String return_url) {
        this.returnUrl = return_url;
    }
    
    public void setPostData(String postData) {
        this.postData = postData;
    }
   
    public void setTarget(String target) {
        this.target = target;
    }
    
    public void setType(String type) {
        this.type= type;
    }
       
    public void setOnblur(String onblur) {
        this.onblur = onblur;
    }

 
    public void setOnclick(String onclick) {
        this.onclick = onclick;
    }

    public void setOnfocus(String onfocus) {
        this.onfocus = onfocus;
    }
   
    public void setOnkeydown(String onkeydown) {
        this.onkeydown = onkeydown;
    }

 
    public void setOnkeypress(String onkeypress) {
        this.onkeypress = onkeypress;
    }

  
    public void setOnkeyup(String onkeyup) {
        this.onkeyup = onkeyup;
    }

   
    public void setOnmousedown(String onmousedown) {
        this.onmousedown = onmousedown;
    }

   
    public void setOnmousemove(String onmousemove) {
        this.onmousemove = onmousemove;
    }
  
    public void setOnmouseout(String onmouseout) {
        this.onmouseout = onmouseout;
    }

   
    public void setOnmouseover(String onmouseover) {
        this.onmouseover = onmouseover;
    }

    
    public void setOnmouseup(String onmouseup) {
        this.onmouseup = onmouseup;
    }

  
    public void setTabIndex(String tabIndex) {
        this.tabIndex = tabIndex;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setAccesskey(String accesskey) {
        this.accesskey = accesskey;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public void setAlt(String alt) {
        this.alt = alt;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }
    
    public void setTestMode(String mode) {
        this.testMode = mode;
    }
    
    public void setDisabled(String disabled) {
        this.disabled = disabled;
    }
    
    public void setDisplayMode(String displayMode) {
        this.displayMode = displayMode;
    }
     
    /**
     * <p>Release any resources used by this tag handler
     */
    public void release() {
        super.release();
        amount = null;
        business = null;
        paymentCancelledUrl = null;
        imageUrl = null;
        itemName = null;
        quantity = null;
        postBackUrl = null;
        image = null;
        returnUrl = null;
        postData = null;
        target = null;
        disabled = null;
        testMode = null;
        type = null;
        displayMode = null;
        
        setOnblur(null);
        setOnclick(null);
        setOnfocus(null);
        setOnkeydown(null);
        setOnkeypress(null);
        setOnkeyup(null);
        setOnmousedown(null);
        setOnmousemove(null);
        setOnmouseout(null);
        setOnmouseover(null);
        setOnmouseup(null);
        setTabIndex(null);
        setTitle(null);
        setAccesskey(null);
        setDir(null);
        setDir(null);
        setAlt(null);
        setLang(null);
    }
    
    /**
     * <p>Set the component properties
     */
    protected void setProperties(UIComponent component) {
        super.setProperties(component);
        BuyNowComponent buynow = (BuyNowComponent) component;

        if (amount != null) {
            if (isValueReference(amount)) {
                ValueBinding vb = FacesContext.getCurrentInstance()
                .getApplication().createValueBinding(amount);
                buynow.setValueBinding("amount", vb); //NOI18N
            } else {
                buynow.setAmount(new BigDecimal(amount));
            }
        }
        
        if (quantity != null) {
            if (isValueReference(quantity)) {
                ValueBinding vb = FacesContext.getCurrentInstance()
                .getApplication().createValueBinding(quantity);
                buynow.setValueBinding("quantity", vb); //NOI18N
            } else {
                int initQty = Integer.parseInt(quantity);
                buynow.setQuantity(initQty);
            }
        }
        
        configureString(component, "business", business);
        configureString(component, "paymentCancelledUrl", paymentCancelledUrl);
        configureString(component, "imageUrl", imageUrl);
        configureString(component, "itemName", itemName);
        configureString(component, "postBackUrl", postBackUrl); 
        configureString(component, "returnUrl", returnUrl); 
        configureString(component, "image", image); 
        
        configureString(component, "dir", dir);
        configureString(component, "title", title);
        configureString(component, "lang", lang);       
        configureString(component, "accesskey", accesskey);
        configureString(component, "alt", alt);
        configureString(component, "target", target);
        configureString(component, "type", type);
        configureBoolean(component, "testMode", testMode);
        configureBoolean(component, "disabled", disabled);
        
        configureString(component, "onblur", onblur);
        configureString(component, "onclick", onclick);
        configureString(component, "onfocus", onfocus);
        configureString(component, "onkeydown", onkeydown);
        configureString(component, "onkeypress", onkeypress);
        configureString(component, "onkeyup", onkeyup);
        configureString(component, "onmousedown", onmousedown);
        configureString(component, "onmousemove", onmousemove);
        configureString(component, "onmouseout", onmouseout);
        configureString(component, "onmouseover", onmouseover);
        configureString(component, "onmouseup", onmouseup);
                
        if (postData != null) {
            if (isValueReference(postData)) {
                ValueBinding vb = FacesContext.getCurrentInstance()
                .getApplication().createValueBinding(postData);
                buynow.setValueBinding("postData", vb); //NOI18N
            } else {
                throw new IllegalArgumentException("'postData' should be valid ValueBinding Expression");
            }
        }
    }

    
   
    
}
