/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: AbstractActionSourceUIComponentTag.java,v 1.2 2006/01/19 20:01:45 craig_mcc Exp $
 */

package com.sun.j2ee.blueprints.ui.util;

import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.el.MethodBinding;
import javax.faces.event.ActionEvent;

/**
 * <p>Convenient base class for JSP tag handlers that extend
 * <code>javax.faces.webapp.UIComponentTag</code>, for
 * components that implement <code>ActionSource</code>.</p>
 */
public abstract class AbstractActionSourceUIComponentTag
        extends AbstractUIComponentTag {
    

    // -------------------------------------------------------- Static Variables


    /**
     * <p>The method signature for an <code>action</code> method binding.</p>
     */
    private static final Class ACTION_SIGNATURE[] = null;


    /**
     * <p>The method signature for an <code>actionListener</code> method binding.</p>
     */
    private static final Class ACTION_LISTENER_SIGNATURE[] =
    { ActionEvent.class };


    // ---------------------------------------------------------- Tag Attributes


    /**
     * <p>The action method binding or literal outcome value.
     */
    private String action = null;

    public void setAction(String action) {
        this.action = action;
    }


    /**
     * <p>The action listener method binding.
     */
    private String actionListener = null;

    public void setActionListener(String actionListener) {
        this.actionListener = actionListener;
    }


    /**
     * <p>The immediate flag.</p>
     */
    private String immediate = null;

    public void setImmediate(String immediate) {
        this.immediate = immediate;
    }


    // -------------------------------------------------- UIComponentTag Methods


    /**
     * <p>Release any variables we allocated.</p>
     */
    public void release() {

        super.release();
        this.action = null;
        this.actionListener = null;
        this.immediate = null;

    }


    /**
     * <p>Configure attributes set on this tag into the component instance.</p>
     *
     * @param component <code>UIComponent</code> being configured
     */
    protected void setProperties(UIComponent component) {

        super.setProperties(component);
        configureAction(component, "action", action);
        configureActionListener(component, "actionListener", actionListener);
        configureBoolean(component, "immediate", immediate);

    }


    // ------------------------------------------------------- Protected Methods


    /**
     * <p>Configure an action method binding or literal outcome.</p>
     *
     * @param component <code>UIComponent</code> being configured
     * @param name Name of the property being configured
     * @param value Value or expression to configure
     */
    protected void configureAction(UIComponent component, String name, String value) {

        if (value == null) {
            return;
        }
        if (isValueReference(value)) {
            MethodBinding mb =
              getFacesContext().getApplication().
              createMethodBinding(value, ACTION_SIGNATURE);
            ((ActionSource) component).setAction(mb);
        } else {
            ((ActionSource) component).setAction(new ConstantMethodBinding(value));
        }

    }


    /**
     * <p>Configure an action listener method binding.</p>
     *
     * @param component <code>UIComponent</code> being configured
     * @param name Name of the property being configured
     * @param value Value or expression to configure
     */
    protected void configureActionListener(UIComponent component, String name, String value) {

        if (value == null) {
            return;
        }
        if (isValueReference(value)) {
            MethodBinding mb =
              getFacesContext().getApplication().
              createMethodBinding(value, ACTION_LISTENER_SIGNATURE);
            ((ActionSource) component).setActionListener(mb);
        } else {
            throw new IllegalArgumentException(value);
        }

    }


}
