/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: AbstractEditableValueHolderUIComponentTag.java,v 1.2 2006/01/19 20:01:45 craig_mcc Exp $
 */

package com.sun.j2ee.blueprints.ui.util;

import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.ValueChangeEvent;

/**
 * <p>Convenient base class for JSP tag handlers that extend
 * <code>javax.faces.webapp.UIComponentTag</code>, for
 * components that implement <code>EditableValueHolder</code>.</p>
 */
public abstract class AbstractEditableValueHolderUIComponentTag
        extends AbstractValueHolderUIComponentTag {
    

    // -------------------------------------------------------- Static Variables


    /**
     * <p>The method signature for a <code>validator</code> method binding.</p>
     */
    private static final Class VALIDATOR_SIGNATURE[] =
    { FacesContext.class, UIComponent.class, Object.class };


    /**
     * <p>The method signature for a <code>valueChangeListener</code> method binding.</p>
     */
    private static final Class VALUE_CHANGE_LISTENER_SIGNATURE[] =
    { ValueChangeEvent.class };


    // ---------------------------------------------------------- Tag Attributes


    /**
     * <p>The immediate flag.</p>
     */
    private String immediate = null;

    public void setImmediate(String immediate) {
        this.immediate = immediate;
    }


    /**
     * <p>The required flag.</p>
     */
    private String required = null;

    public void setRequired(String required) {
        this.required = required;
    }


    /**
     * <p>The validator method binding.</p>
     */
    private String validator = null;

    public void setValidator(String validator) {
        this.validator = validator;
    }


    /**
     * <p>The value change listener method binding.</p>
     */
    private String valueChangeListener = null;

    public void setValueChangeListener(String valueChangeListener) {
        this.valueChangeListener = valueChangeListener;
    }


    // -------------------------------------------------- UIComponentTag Methods


    /**
     * <p>Release any variables we allocated.</p>
     */
    public void release() {

        super.release();
        this.immediate = null;
        this.required = null;
        this.validator = null;
        this.valueChangeListener = null;

    }


    /**
     * <p>Configure attributes set on this tag into the component instance.</p>
     *
     * @param component <code>UIComponent</code> being configured
     */
    protected void setProperties(UIComponent component) {

        super.setProperties(component);
        configureBoolean(component, "immediate", immediate);
        configureBoolean(component, "required", required);
        configureValidator(component, "validator", validator);
        configureValueChangeListener(component, "valueChangeListener", valueChangeListener);

    }


    // ------------------------------------------------------- Protected Methods


    /**
     * <p>Configure a validator method binding.</p>
     *
     * @param component <code>UIComponent</code> being configured
     * @param name Name of the property being configured
     * @param value Value or expression to configure
     */
    protected void configureValidator(UIComponent component, String name, String value) {

        if (value == null) {
            return;
        }
        if (isValueReference(value)) {
            MethodBinding mb =
              getFacesContext().getApplication().
              createMethodBinding(value, VALIDATOR_SIGNATURE);
            ((EditableValueHolder) component).setValidator(mb);
        } else {
            throw new IllegalArgumentException(value);
        }

    }


    /**
     * <p>Configure a value change listener method binding.</p>
     *
     * @param component <code>UIComponent</code> being configured
     * @param name Name of the property being configured
     * @param value Value or expression to configure
     */
    protected void configureValueChangeListener(UIComponent component, String name, String value) {

        if (value == null) {
            return;
        }
        if (isValueReference(value)) {
            MethodBinding mb =
              getFacesContext().getApplication().
              createMethodBinding(value, VALUE_CHANGE_LISTENER_SIGNATURE);
            ((EditableValueHolder) component).setValueChangeListener(mb);
        } else {
            throw new IllegalArgumentException(value);
        }

    }


}
