/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: AbstractValueHolderUIComponentTag.java,v 1.2 2006/01/19 20:01:46 craig_mcc Exp $
 */

package com.sun.j2ee.blueprints.ui.util;

import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.el.ValueBinding;

/**
 * <p>Convenient base class for JSP tag handlers that extend
 * <code>javax.faces.webapp.UIComponentTag</code>, for
 * components that implement <code>ValueHolder</code>.</p>
 */
public abstract class AbstractValueHolderUIComponentTag
        extends AbstractUIComponentTag {
    

    // ---------------------------------------------------------- Tag Attributes


    /**
     * <p>The converter value binding.</p>
     */
    private String converter = null;

    public void setConverter(String converter) {
        this.converter = converter;
    }


    /**
     * <p>The component value.</p>
     */
    private String value = null;

    public void setValue(String value) {
        this.value = value;
    }


    // -------------------------------------------------- UIComponentTag Methods


    /**
     * <p>Release any variables we allocated.</p>
     */
    public void release() {

        super.release();
        this.converter = null;
        this.value = null;

    }


    /**
     * <p>Configure attributes set on this tag into the component instance.</p>
     *
     * @param component <code>UIComponent</code> being configured
     */
    protected void setProperties(UIComponent component) {

        super.setProperties(component);
        configureConverter(component, "converter", converter);
        configureObject(component, "value", value);

    }


    // ------------------------------------------------------- Protected Methods


    /**
     * <p>Configure a component property of type <code>Converter</code>.</p>
     *
     * @param component <code>UIComponent</code> being configured
     * @param name Name of the property being configured
     * @param value Value or expression to configure
     */
    protected void configureConverter(UIComponent component, String name, String value) {

        if (value == null) {
            return;
        }
        if (isValueReference(value)) {
            ValueBinding vb =
              getFacesContext().getApplication().createValueBinding(value);
            component.setValueBinding(name, vb);
        } else {
            throw new IllegalArgumentException(value);
        }

    }


}
