/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: BaseRenderer.java,v 1.5 2006/01/19 20:01:46 craig_mcc Exp $
 */

package com.sun.j2ee.blueprints.ui.util;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.FactoryFinder;
import javax.faces.render.RenderKit;
import javax.faces.render.Renderer;
import javax.faces.render.RenderKitFactory;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

/**
 * <p>Convenient base class for <code>Renderer</code> implementations.</p>
 */

public abstract class BaseRenderer extends Renderer {

    public static final String BUNDLE_ATTR = "com.sun.faces.bundle";
    
    public String convertClientId(FacesContext context, String clientId) {
        return clientId;
    }
    
    public ResponseWriter setupResponseWriter(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (writer == null) {
	    HttpServletRequest request = (HttpServletRequest)
		context.getExternalContext().getRequest();
	    HttpServletResponse response = (HttpServletResponse)
		context.getExternalContext().getResponse();


	    RenderKitFactory renderFactory = (RenderKitFactory)
		FactoryFinder.getFactory(FactoryFinder.RENDER_KIT_FACTORY);
	    RenderKit renderKit = 
		renderFactory.getRenderKit
                (context, context.getViewRoot().getRenderKitId());
	    // PENDING(edburns): spec: add content/type and character
	    // encoding to external context?
            writer = 
		renderKit.createResponseWriter(response.getWriter(),
                                               "text/html",
					       request.getCharacterEncoding());
	    
            context.setResponseWriter(writer);
        }
	return writer;
    }    

    protected String getKeyAndLookupInBundle(FacesContext context,
                                             UIComponent component,
                                             String keyAttr)
        throws MissingResourceException {
        String key = null, bundleName = null;
        ResourceBundle bundle = null;

        key = (String) component.getAttributes().get(keyAttr);
        bundleName = (String) component.getAttributes().get(BUNDLE_ATTR);

        // if the bundleName is null for this component, it might have
        // been set on the root component.
        if (bundleName == null) {
            UIComponent root = context.getViewRoot();

            bundleName = (String) root.getAttributes().get(BUNDLE_ATTR);
        }
        // verify our component has the proper attributes for key and bundle.
        if (null == key || null == bundleName) {
            throw new MissingResourceException("Can't load JSTL classes",
                                               bundleName, key);
        }

        // verify the required Class is loadable
        // PENDING(edburns): Find a way to do this once per ServletContext.
        if (null == Thread.currentThread().getContextClassLoader().
            getResource("javax.servlet.jsp.jstl.fmt.LocalizationContext")) {
            Object[] params = {
                "javax.servlet.jsp.jstl.fmt.LocalizationContext"
            };
            throw new MissingResourceException("Can't load JSTL classes",
                                               bundleName, key);
        }
        return bundle.getString(key);
    }


    protected void encodeRecursive(FacesContext context, UIComponent component)
        throws IOException {
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            Iterator kids = component.getChildren().iterator();
            while (kids.hasNext()) {
                UIComponent kid = (UIComponent) kids.next();
                encodeRecursive(context, kid);
            }
        }
        component.encodeEnd(context);

    }
    
     // -------------------------------------------------- Static Utility Methods


    private static String booleanPassthruAttributes[] =
    { "disabled", "readonly", "ismap" };

    private static String passthruAttributes[] =
    { "accept", "accesskey", "alt", "bgcolor", "border",
      "cellpadding", "cellspacing", "charset", "cols",
      "coords", "dir", "enctype", "frame", "height",
      "hreflang", "lang", "longdesc", "maxlength", "onblur",
      "onclick", "ondblclick", "onfocus", "onchange",
      "onkeydown", "onkeypress", "onkeyup", "onload",
      "onmousedown", "onmousemove", "onmouseout",
      "onmouseover", "onmouseup", "onreset", "onselect",
      "onsubmit", "onunload", "rel", "rev", "rows",
      "rules", "shape", "size", "summary",
      "tabindex", "target", "title", "usemap", "width" };

    protected static void renderBooleanPassThruAttributes(ResponseWriter writer, UIComponent component)
        throws IOException {

        boolean result = false;
        Object value;
        for (int i = 0; i < booleanPassthruAttributes.length; i++) {
            value = component.getAttributes().get(booleanPassthruAttributes[i]);
            if (value != null) {
                if (value instanceof Boolean) {
                    result = ((Boolean) value).booleanValue();
                } else if (value instanceof String) {
                    result = (new Boolean((String) value)).booleanValue();
                }
                if (result) {
                    writer.writeAttribute(booleanPassthruAttributes[i],
                                          booleanPassthruAttributes[i],
                                          booleanPassthruAttributes[i]);
                }
            }
        }

    }
    
    protected static void renderPassThruAttributes(ResponseWriter writer, 
            UIComponent component) throws IOException {
        renderPassThruAttributes(writer, component, null);
    }

    protected static void renderPassThruAttributes(ResponseWriter writer, 
            UIComponent component, String[] excludes) throws IOException {
        boolean skip = false;
        Object value;
        for (int i = 0; i < passthruAttributes.length; i++) {
            skip = false;
            if (null != excludes) {
                for (int j = 0, jLen = excludes.length; j < jLen; j++) {
                    if (null != excludes[j] &&
                        excludes[j].equals(passthruAttributes[i])) {
                        skip = true;
                        break;
                    }
                }
            }
            if (skip) {
                continue;
            }
            
            value = component.getAttributes().get(passthruAttributes[i]);
            if (value != null && shouldRenderAttribute(value)) {
                if (!(value instanceof String)) {
                    value = value.toString();
                }
                writer.writeAttribute(passthruAttributes[i],(String) value,
                        passthruAttributes[i]);
            }
        }

    }
    
    /**
     * Return true if and only if the argument <code>attributeVal</code> is an 
     * instance of a wrapper for a primitive type and its value is equal to the 
     * default value for that type as given in the spec.
     */

    protected static boolean shouldRenderAttribute(Object attributeVal) {
        if (attributeVal instanceof Boolean &&
            ((Boolean) attributeVal).booleanValue() ==
            Boolean.FALSE.booleanValue()) {
            return false;
        } else if (attributeVal instanceof Integer &&
            ((Integer) attributeVal).intValue() == Integer.MIN_VALUE) {
            return false;
        } else if (attributeVal instanceof Double &&
            ((Double) attributeVal).doubleValue() == Double.MIN_VALUE) {
            return false;
        } else if (attributeVal instanceof Character &&
            ((Character) attributeVal).charValue() == Character.MIN_VALUE) {
            return false;
        } else if (attributeVal instanceof Float &&
            ((Float) attributeVal).floatValue() == Float.MIN_VALUE) {
            return false;
        } else if (attributeVal instanceof Short &&
            ((Short) attributeVal).shortValue() == Short.MIN_VALUE) {
            return false;
        } else if (attributeVal instanceof Byte &&
            ((Byte) attributeVal).byteValue() == Byte.MIN_VALUE) {
            return false;
        } else if (attributeVal instanceof Long &&
            ((Long) attributeVal).longValue() == Long.MIN_VALUE) {
            return false;
        }
        return true;
    }
    
    public static boolean componentIsDisabledOnReadonly(UIComponent component) {
        Object disabledOrReadonly = null;
        boolean result = false;
        if (null !=
            (disabledOrReadonly = component.getAttributes().get("disabled"))) {
            if (disabledOrReadonly instanceof String) {
                result = ((String) disabledOrReadonly).equalsIgnoreCase("true");
            } else {
                result = disabledOrReadonly.equals(Boolean.TRUE);
            }
        }
        if ((result == false) &&
            null !=
            (disabledOrReadonly = component.getAttributes().get("readonly"))) {
            if (disabledOrReadonly instanceof String) {
                result = ((String) disabledOrReadonly).equalsIgnoreCase("true");
            } else {
                result = disabledOrReadonly.equals(Boolean.TRUE);
            }
        }

        return result;
    }


}
